/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.webank.weid.constant.CredentialFieldDisclosureValue;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.Cpt;
import com.webank.weid.protocol.base.Credential;
import com.webank.weid.protocol.base.CredentialWrapper;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.base.WeIdPublicKey;
import com.webank.weid.protocol.request.CreateCredentialArgs;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.CptService;
import com.webank.weid.rpc.CredentialService;
import com.webank.weid.rpc.WeIdService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.CptServiceImpl;
import com.webank.weid.service.impl.WeIdServiceImpl;
import com.webank.weid.util.CredentialUtils;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SignatureException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.crypto.Sign;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialServiceImpl
extends BaseService
implements CredentialService {
    private static final Logger logger = LoggerFactory.getLogger(CredentialServiceImpl.class);
    private CptService cptService = new CptServiceImpl();
    private WeIdService weIdService = new WeIdServiceImpl();

    @Override
    public ResponseData<CredentialWrapper> createCredential(CreateCredentialArgs args) {
        CredentialWrapper credentialWrapper = new CredentialWrapper();
        try {
            ErrorCode innerResponse = this.checkCreateCredentialArgsValidity(args, true);
            if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
                logger.error("Generate Credential input format error!");
                return new ResponseData<Object>(null, innerResponse);
            }
            Credential result = new Credential();
            String context = CredentialUtils.getDefaultCredentialContext();
            result.setContext(context);
            result.setId(UUID.randomUUID().toString());
            result.setCptId(args.getCptId());
            result.setIssuer(args.getIssuer());
            Long issuanceDate = args.getIssuanceDate();
            if (issuanceDate == null) {
                result.setIssuanceDate(System.currentTimeMillis());
            } else {
                result.setIssuanceDate(issuanceDate);
            }
            result.setExpirationDate(args.getExpirationDate());
            result.setClaim(args.getClaim());
            HashMap<String, Object> disclosureMap = new HashMap<String, Object>(args.getClaim());
            for (Map.Entry entry : disclosureMap.entrySet()) {
                disclosureMap.put((String)entry.getKey(), CredentialFieldDisclosureValue.DISCLOSED.getStatus());
            }
            credentialWrapper.setDisclosure(disclosureMap);
            Map<String, String> credentialProof = CredentialUtils.buildCredentialProof(result, args.getWeIdPrivateKey().getPrivateKey(), disclosureMap);
            result.setProof(credentialProof);
            credentialWrapper.setCredential(result);
            ResponseData<CredentialWrapper> responseData = new ResponseData<CredentialWrapper>(credentialWrapper, ErrorCode.SUCCESS);
            return responseData;
        }
        catch (Exception e) {
            logger.error("Generate Credential failed due to system error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> verify(CredentialWrapper credentialWrapper) {
        return this.verifyCredentialContent(credentialWrapper, null);
    }

    @Override
    public ResponseData<Boolean> verify(Credential credential) {
        HashMap<String, Object> disclosureMap = new HashMap<String, Object>(credential.getClaim());
        for (Map.Entry entry : disclosureMap.entrySet()) {
            disclosureMap.put((String)entry.getKey(), CredentialFieldDisclosureValue.DISCLOSED.getStatus());
        }
        CredentialWrapper credentialWrapper = new CredentialWrapper();
        credentialWrapper.setCredential(credential);
        credentialWrapper.setDisclosure(disclosureMap);
        return this.verifyCredentialContent(credentialWrapper, null);
    }

    @Override
    public ResponseData<Boolean> verifyCredentialWithSpecifiedPubKey(CredentialWrapper credentialWrapper, WeIdPublicKey weIdPublicKey) {
        if (credentialWrapper == null) {
            return new ResponseData<Boolean>(false, ErrorCode.ILLEGAL_INPUT);
        }
        if (weIdPublicKey == null) {
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_ISSUER_MISMATCH);
        }
        return this.verifyCredentialContent(credentialWrapper, weIdPublicKey.getPublicKey());
    }

    @Override
    public ResponseData<String> getCredentialHash(Credential args) {
        ErrorCode innerResponse = CredentialUtils.isCredentialValid(args);
        if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
            logger.error("Credential input format error!");
            return new ResponseData<String>("", innerResponse);
        }
        ResponseData<String> responseData = new ResponseData<String>(CredentialUtils.getCredentialHash(args), ErrorCode.SUCCESS);
        return responseData;
    }

    private ResponseData<Boolean> verifyCredentialContent(CredentialWrapper credentialWrapper, String publicKey) {
        try {
            Credential credential = credentialWrapper.getCredential();
            ErrorCode innerResponse = CredentialUtils.isCredentialValid(credential);
            if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
                logger.error("Credential input format error!");
                return new ResponseData<Boolean>(false, innerResponse);
            }
            ResponseData<Boolean> responseData = this.verifyIssuerExistence(credential.getIssuer());
            if (!responseData.getResult().booleanValue()) {
                return responseData;
            }
            ErrorCode errorCode = this.verifyCptFormat(credential.getCptId(), credential.getClaim());
            if (ErrorCode.SUCCESS.getCode() != errorCode.getCode()) {
                return new ResponseData<Object>(null, errorCode);
            }
            responseData = this.verifyNotExpired(credential);
            if (!responseData.getResult().booleanValue()) {
                return responseData;
            }
            responseData = this.verifySignature(credentialWrapper, publicKey);
            return responseData;
        }
        catch (Exception e) {
            logger.error("Verify Credential failed due to generic error: ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_ERROR);
        }
    }

    private ErrorCode checkCreateCredentialArgsValidity(CreateCredentialArgs args, boolean privateKeyRequired) {
        ErrorCode innerResponseData = CredentialUtils.isCreateCredentialArgsValid(args);
        if (ErrorCode.SUCCESS.getCode() != innerResponseData.getCode()) {
            logger.error("Create Credential Args illegal: {}", (Object)innerResponseData.getCodeDesc());
            return innerResponseData;
        }
        if (privateKeyRequired && StringUtils.isEmpty((CharSequence)args.getWeIdPrivateKey().getPrivateKey())) {
            logger.error(ErrorCode.CREDENTIAL_PRIVATE_KEY_NOT_EXISTS.getCodeDesc());
            return ErrorCode.CREDENTIAL_PRIVATE_KEY_NOT_EXISTS;
        }
        return ErrorCode.SUCCESS;
    }

    private ResponseData<Boolean> verifyIssuerExistence(String issuerWeId) {
        ResponseData<Boolean> responseData = this.weIdService.isWeIdExist(issuerWeId);
        if (responseData == null || !responseData.getResult().booleanValue()) {
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_ISSUER_NOT_EXISTS);
        }
        return responseData;
    }

    private ErrorCode verifyCptFormat(Integer cptId, Map<String, Object> claim) {
        try {
            String claimStr = DataToolUtils.serialize(claim);
            Cpt cpt = this.cptService.queryCpt(cptId).getResult();
            if (cpt == null) {
                logger.error(ErrorCode.CREDENTIAL_CPT_NOT_EXISTS.getCodeDesc());
                return ErrorCode.CREDENTIAL_CPT_NOT_EXISTS;
            }
            String cptJsonSchema = DataToolUtils.serialize(cpt.getCptJsonSchema());
            if (!DataToolUtils.isCptJsonSchemaValid(cptJsonSchema)) {
                logger.error(ErrorCode.CPT_JSON_SCHEMA_INVALID.getCodeDesc());
                return ErrorCode.CPT_JSON_SCHEMA_INVALID;
            }
            if (!DataToolUtils.isValidateJsonVersusSchema(claimStr, cptJsonSchema)) {
                logger.error(ErrorCode.CREDENTIAL_CLAIM_DATA_ILLEGAL.getCodeDesc());
                return ErrorCode.CREDENTIAL_CLAIM_DATA_ILLEGAL;
            }
            return ErrorCode.SUCCESS;
        }
        catch (Exception e) {
            logger.error("Generic error occurred during verify cpt format when verifyCredential: " + e);
            return ErrorCode.CREDENTIAL_ERROR;
        }
    }

    private ResponseData<Boolean> verifyNotExpired(Credential credential) {
        try {
            Date expireDate = new Date(credential.getExpirationDate());
            Date currentDate = new Date();
            boolean result = currentDate.before(expireDate);
            ResponseData<Boolean> responseData = new ResponseData<Boolean>(result, ErrorCode.SUCCESS);
            if (!result) {
                responseData.setErrorCode(ErrorCode.CREDENTIAL_EXPIRED);
            }
            return responseData;
        }
        catch (Exception e) {
            logger.error("Generic error occurred during verify expiration when verifyCredential: " + e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_ERROR);
        }
    }

    private ResponseData<Boolean> verifySignature(CredentialWrapper credentialWrapper, String publicKey) {
        try {
            Credential credential = credentialWrapper.getCredential();
            Map<String, Object> disclosureMap = credentialWrapper.getDisclosure();
            String rawData = CredentialUtils.getCredentialThumbprintWithoutSig(credential, disclosureMap);
            Sign.SignatureData signatureData = DataToolUtils.simpleSignatureDeserialization(DataToolUtils.base64Decode(credential.getSignature().getBytes(StandardCharsets.UTF_8)));
            if (StringUtils.isEmpty((CharSequence)publicKey)) {
                String credentialIssuer = credential.getIssuer();
                ResponseData<WeIdDocument> innerResponseData = this.weIdService.getWeIdDocument(credentialIssuer);
                if (innerResponseData.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                    logger.error("Error occurred when fetching WeIdentity DID document for: {}, msg: {}", (Object)credentialIssuer, (Object)innerResponseData.getErrorMessage());
                    return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_WEID_DOCUMENT_ILLEGAL);
                }
                WeIdDocument weIdDocument = innerResponseData.getResult();
                ErrorCode errorCode = DataToolUtils.verifySignatureFromWeId(rawData, signatureData, weIdDocument);
                if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
                    return new ResponseData<Boolean>(false, errorCode);
                }
                return new ResponseData<Boolean>(true, ErrorCode.SUCCESS);
            }
            boolean result = DataToolUtils.verifySignature(rawData, signatureData, new BigInteger(publicKey));
            if (!result) {
                return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_SIGNATURE_BROKEN);
            }
            return new ResponseData<Boolean>(true, ErrorCode.SUCCESS);
        }
        catch (SignatureException e) {
            logger.error("Generic signatureException occurred during verify signature when verifyCredential: ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_EXCEPTION_VERIFYSIGNATURE);
        }
        catch (WeIdBaseException e) {
            logger.error("Generic signatureException occurred during verify signature ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_SIGNATURE_BROKEN);
        }
        catch (Exception e) {
            logger.error("Generic exception occurred during verify signature when verifyCredential: ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_ERROR);
        }
    }

    @Override
    public ResponseData<CredentialWrapper> createSelectiveCredential(Credential credential, String disclosure) {
        Map disclosureMap = DataToolUtils.deserialize(disclosure, HashMap.class);
        CredentialWrapper credentialResult = new CredentialWrapper();
        ErrorCode checkResp = CredentialUtils.isCredentialValid(credential);
        if (ErrorCode.SUCCESS.getCode() != checkResp.getCode()) {
            return new ResponseData<CredentialWrapper>(credentialResult, checkResp);
        }
        Map<String, Object> claim = credential.getClaim();
        HashMap<String, Object> hashMap = new HashMap<String, Object>(claim);
        for (Map.Entry<String, Object> entry : claim.entrySet()) {
            claim.put(entry.getKey(), CredentialUtils.getFieldHash(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : disclosureMap.entrySet()) {
            if (!CredentialFieldDisclosureValue.DISCLOSED.getStatus().equals(entry.getValue())) continue;
            claim.put(entry.getKey(), hashMap.get(entry.getKey()));
        }
        credentialResult.setCredential(credential);
        credentialResult.setDisclosure(disclosureMap);
        return new ResponseData<CredentialWrapper>(credentialResult, ErrorCode.SUCCESS);
    }

    @Override
    public ResponseData<String> getCredentialJson(Credential credential) {
        ErrorCode errorCode = CredentialUtils.isCredentialValid(credential);
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return new ResponseData<String>("", ErrorCode.getTypeByErrorCode(errorCode.getCode()));
        }
        try {
            Map<String, Object> credMap = DataToolUtils.objToMap(credential);
            String issuanceDate = DateUtils.convertTimestampToUtc(credential.getIssuanceDate());
            String expirationDate = DateUtils.convertTimestampToUtc(credential.getExpirationDate());
            credMap.put("issuanceDate", issuanceDate);
            credMap.put("expirationDate", expirationDate);
            credMap.remove("context");
            credMap.put("@context", "https://github.com/WeBankFinTech/WeIdentity/blob/master/context/v1");
            String credentialString = DataToolUtils.mapToCompactJson(credMap);
            return new ResponseData<String>(credentialString, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("Json conversion failed in getCredentialJson: ", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.CREDENTIAL_ERROR);
        }
    }
}

