/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.Credential;
import com.webank.weid.protocol.base.EvidenceInfo;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.base.WeIdPrivateKey;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.EvidenceService;
import com.webank.weid.rpc.WeIdService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.WeIdServiceImpl;
import com.webank.weid.service.impl.engine.EngineFactory;
import com.webank.weid.service.impl.engine.EvidenceServiceEngine;
import com.webank.weid.util.CredentialUtils;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.WeIdUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.crypto.Sign;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceServiceImpl
extends BaseService
implements EvidenceService {
    private static final Logger logger = LoggerFactory.getLogger(EvidenceServiceImpl.class);
    private WeIdService weIdService = new WeIdServiceImpl();
    private EvidenceServiceEngine evidenceServiceEngine = EngineFactory.createEvidenceServiceEngine();

    @Override
    public ResponseData<String> createEvidence(Credential credential, WeIdPrivateKey weIdPrivateKey) {
        ErrorCode innerResponse = CredentialUtils.isCreateEvidenceArgsValid(credential, weIdPrivateKey);
        if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
            logger.error("Create Evidence input format error!");
            return new ResponseData<String>("", innerResponse);
        }
        innerResponse = CredentialUtils.isCredentialValid(credential);
        if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
            logger.error("Create Evidence input format error: credential!");
            return new ResponseData<String>("", innerResponse);
        }
        try {
            String credentialHash = CredentialUtils.getCredentialHash(credential);
            String credentialHashOnChain = credentialHash.replaceAll("0x", "");
            ArrayList<String> hashAttributes = new ArrayList<String>();
            hashAttributes.add(credentialHashOnChain.substring(0, WeIdConstant.BYTES32_FIXED_LENGTH));
            hashAttributes.add(credentialHashOnChain.substring(WeIdConstant.BYTES32_FIXED_LENGTH, WeIdConstant.BYTES32_FIXED_LENGTH * 2));
            ArrayList<String> extraValueList = new ArrayList<String>();
            extraValueList.add("");
            Sign.SignatureData sigData = DataToolUtils.signMessage(credentialHash, weIdPrivateKey.getPrivateKey());
            return this.evidenceServiceEngine.createEvidence(sigData, hashAttributes, extraValueList, weIdPrivateKey.getPrivateKey());
        }
        catch (Exception e) {
            logger.error("create evidence failed due to system error. ", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
        }
    }

    @Override
    public ResponseData<EvidenceInfo> getEvidence(String evidenceAddress) {
        if (StringUtils.isEmpty((CharSequence)evidenceAddress) || !WeIdUtils.isValidAddress(evidenceAddress)) {
            logger.error("Evidence argument illegal input: address. ");
            return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
        }
        try {
            return this.evidenceServiceEngine.getInfo(evidenceAddress);
        }
        catch (Exception e) {
            logger.error("get evidence failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> verify(Credential credential, String evidenceAddress) {
        ErrorCode innerResponse = CredentialUtils.isCredentialValid(credential);
        if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
            logger.error("Verify EvidenceInfo input illegal: credential");
            return new ResponseData<Boolean>(false, innerResponse);
        }
        if (!WeIdUtils.isValidAddress(evidenceAddress)) {
            logger.error("Verify EvidenceInfo input illegal: evidenceInfo address");
            return new ResponseData<Boolean>(false, ErrorCode.ILLEGAL_INPUT);
        }
        ResponseData<EvidenceInfo> innerEvidenceResponseData = this.getEvidence(evidenceAddress);
        if (innerEvidenceResponseData.getResult() == null) {
            return new ResponseData<Boolean>(false, ErrorCode.getTypeByErrorCode(innerEvidenceResponseData.getErrorCode()));
        }
        EvidenceInfo evidenceInfo = innerEvidenceResponseData.getResult();
        String hashOffChain = CredentialUtils.getCredentialHash(credential);
        if (!StringUtils.equalsIgnoreCase((CharSequence)hashOffChain, (CharSequence)evidenceInfo.getCredentialHash())) {
            logger.error("credential hash mismatches. Off-chain: {}, on-chain: {}", (Object)hashOffChain, (Object)evidenceInfo.getCredentialHash());
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_EVIDENCE_HASH_MISMATCH);
        }
        try {
            for (int i = 0; i < evidenceInfo.getSignatures().size(); ++i) {
                String signer = evidenceInfo.getSigners().get(i);
                String signature = evidenceInfo.getSignatures().get(i);
                if (!WeIdUtils.isEmptyAddress(new Address(signer))) {
                    Sign.SignatureData signatureData = DataToolUtils.simpleSignatureDeserialization(DataToolUtils.base64Decode(signature.getBytes(StandardCharsets.UTF_8)));
                    ResponseData<Boolean> innerResponseData = this.verifySignatureToSigner(hashOffChain, WeIdUtils.convertAddressToWeId(signer), signatureData);
                    if (innerResponseData.getResult().booleanValue()) continue;
                    return innerResponseData;
                }
                break;
            }
        }
        catch (WeIdBaseException e) {
            logger.error("Generic error occurred during verify evidenceInfo: ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_EVIDENCE_SIGNATURE_BROKEN);
        }
        catch (Exception e) {
            logger.error("Generic error occurred during verify evidenceInfo: ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
        }
        return new ResponseData<Boolean>(true, ErrorCode.SUCCESS);
    }

    private ResponseData<Boolean> verifySignatureToSigner(String rawData, String signerWeId, Sign.SignatureData signatureData) {
        try {
            ResponseData<WeIdDocument> innerResponseData = this.weIdService.getWeIdDocument(signerWeId);
            if (innerResponseData.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                logger.error("Error occurred when fetching WeIdentity DID document for: {}, msg: {}", (Object)signerWeId, (Object)innerResponseData.getErrorMessage());
                return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_WEID_DOCUMENT_ILLEGAL);
            }
            WeIdDocument weIdDocument = innerResponseData.getResult();
            ErrorCode errorCode = DataToolUtils.verifySignatureFromWeId(rawData, signatureData, weIdDocument);
            if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
                return new ResponseData<Boolean>(false, errorCode);
            }
            return new ResponseData<Boolean>(true, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("error occurred during verifying signatures from chain: ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
        }
    }
}

