/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.RawTransactionService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.engine.EngineFactory;
import com.webank.weid.service.impl.engine.RawTransactionServiceEngine;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawTransactionServiceImpl
extends BaseService
implements RawTransactionService {
    private static final Logger logger = LoggerFactory.getLogger(RawTransactionServiceImpl.class);
    private RawTransactionServiceEngine engine = EngineFactory.createRawTransactionServiceEngine();

    @Override
    public ResponseData<String> createWeId(String transactionHex) {
        if (StringUtils.isEmpty((CharSequence)transactionHex)) {
            logger.error("WeID transaction error");
            return new ResponseData<String>("", ErrorCode.ILLEGAL_INPUT);
        }
        return this.engine.createWeId(transactionHex);
    }

    @Override
    public ResponseData<String> registerAuthorityIssuer(String transactionHex) {
        if (StringUtils.isEmpty((CharSequence)transactionHex)) {
            logger.error("AuthorityIssuer transaction error");
            return new ResponseData<String>("", ErrorCode.ILLEGAL_INPUT);
        }
        return this.engine.registerAuthorityIssuer(transactionHex);
    }

    @Override
    public ResponseData<String> registerCpt(String transactionHex) {
        if (StringUtils.isEmpty((CharSequence)transactionHex)) {
            logger.error("CptService transaction error");
            return new ResponseData<String>("", ErrorCode.ILLEGAL_INPUT);
        }
        return this.engine.registerCpt(transactionHex);
    }
}

