/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.exception.LoadContractException;
import com.webank.weid.exception.PrivateKeyIllegalException;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.base.WeIdPrivateKey;
import com.webank.weid.protocol.base.WeIdPublicKey;
import com.webank.weid.protocol.request.CreateWeIdArgs;
import com.webank.weid.protocol.request.SetAuthenticationArgs;
import com.webank.weid.protocol.request.SetPublicKeyArgs;
import com.webank.weid.protocol.request.SetServiceArgs;
import com.webank.weid.protocol.response.CreateWeIdDataResult;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.WeIdService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.engine.EngineFactory;
import com.webank.weid.service.impl.engine.WeIdServiceEngine;
import com.webank.weid.util.WeIdUtils;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.crypto.ECKeyPair;
import org.bcos.web3j.crypto.Keys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeIdServiceImpl
extends BaseService
implements WeIdService {
    private static final Logger logger = LoggerFactory.getLogger(WeIdServiceImpl.class);
    private static WeIdServiceEngine weIdServiceEngine = EngineFactory.createWeIdServiceEngine();

    @Override
    public ResponseData<CreateWeIdDataResult> createWeId() {
        CreateWeIdDataResult result = new CreateWeIdDataResult();
        ECKeyPair keyPair = null;
        try {
            keyPair = Keys.createEcKeyPair();
        }
        catch (Exception e) {
            logger.error("Create weId failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.WEID_KEYPAIR_CREATE_FAILED);
        }
        String publicKey = String.valueOf(keyPair.getPublicKey());
        String privateKey = String.valueOf(keyPair.getPrivateKey());
        WeIdPublicKey userWeIdPublicKey = new WeIdPublicKey();
        userWeIdPublicKey.setPublicKey(publicKey);
        result.setUserWeIdPublicKey(userWeIdPublicKey);
        WeIdPrivateKey userWeIdPrivateKey = new WeIdPrivateKey();
        userWeIdPrivateKey.setPrivateKey(privateKey);
        result.setUserWeIdPrivateKey(userWeIdPrivateKey);
        String weId = WeIdUtils.convertPublicKeyToWeId(publicKey);
        result.setWeId(weId);
        ResponseData<Boolean> innerResp = this.processCreateWeId(weId, publicKey, privateKey);
        if (innerResp.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[createWeId] Create weId failed. error message is :{}", (Object)innerResp.getErrorMessage());
            return new ResponseData<Object>(null, ErrorCode.getTypeByErrorCode(innerResp.getErrorCode()), innerResp.getTransactionInfo());
        }
        return new ResponseData<CreateWeIdDataResult>(result, ErrorCode.getTypeByErrorCode(innerResp.getErrorCode()), innerResp.getTransactionInfo());
    }

    @Override
    public ResponseData<String> createWeId(CreateWeIdArgs createWeIdArgs) {
        if (createWeIdArgs == null) {
            logger.error("[createWeId]: input parameter createWeIdArgs is null.");
            return new ResponseData<String>("", ErrorCode.ILLEGAL_INPUT);
        }
        if (!WeIdUtils.isPrivateKeyValid(createWeIdArgs.getWeIdPrivateKey())) {
            return new ResponseData<String>("", ErrorCode.WEID_PRIVATEKEY_INVALID);
        }
        String privateKey = createWeIdArgs.getWeIdPrivateKey().getPrivateKey();
        String publicKey = createWeIdArgs.getPublicKey();
        if (StringUtils.isNotBlank((CharSequence)publicKey)) {
            if (!WeIdUtils.isKeypairMatch(privateKey, publicKey)) {
                return new ResponseData<String>("", ErrorCode.WEID_PUBLICKEY_AND_PRIVATEKEY_NOT_MATCHED);
            }
            String weId = WeIdUtils.convertPublicKeyToWeId(publicKey);
            ResponseData<Boolean> isWeIdExistResp = this.isWeIdExist(weId);
            if (isWeIdExistResp.getResult() == null || isWeIdExistResp.getResult().booleanValue()) {
                logger.error("[createWeId]: create weid failed, the weid :{} is already exist", (Object)weId);
                return new ResponseData<String>("", ErrorCode.WEID_ALREADY_EXIST);
            }
            ResponseData<Boolean> innerResp = this.processCreateWeId(weId, publicKey, privateKey);
            if (innerResp.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                logger.error("[createWeId]: create weid failed. error message is :{}, public key is {}", (Object)innerResp.getErrorMessage(), (Object)publicKey);
                return new ResponseData<String>("", ErrorCode.getTypeByErrorCode(innerResp.getErrorCode()), innerResp.getTransactionInfo());
            }
            return new ResponseData<String>(weId, ErrorCode.getTypeByErrorCode(innerResp.getErrorCode()), innerResp.getTransactionInfo());
        }
        return new ResponseData<String>("", ErrorCode.WEID_PUBLICKEY_INVALID);
    }

    @Override
    public ResponseData<WeIdDocument> getWeIdDocument(String weId) {
        if (!WeIdUtils.isWeIdValid(weId)) {
            logger.error("Input weId : {} is invalid.", (Object)weId);
            return new ResponseData<Object>(null, ErrorCode.WEID_INVALID);
        }
        return weIdServiceEngine.getWeIdDocument(weId);
    }

    @Override
    public ResponseData<String> getWeIdDocumentJson(String weId) {
        String weIdDocument;
        ResponseData<WeIdDocument> responseData = this.getWeIdDocument(weId);
        WeIdDocument result = responseData.getResult();
        if (result == null) {
            return new ResponseData<String>("", ErrorCode.getTypeByErrorCode(responseData.getErrorCode()));
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            weIdDocument = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)result);
        }
        catch (Exception e) {
            return new ResponseData<String>("", ErrorCode.getTypeByErrorCode(responseData.getErrorCode()));
        }
        weIdDocument = new StringBuffer().append(weIdDocument).insert(1, "\"@context\" : \"https://github.com/WeBankFinTech/WeIdentity/blob/master/context/v1\",").toString();
        ResponseData<String> responseDataJson = new ResponseData<String>();
        responseDataJson.setResult(weIdDocument);
        responseDataJson.setErrorCode(ErrorCode.getTypeByErrorCode(responseData.getErrorCode()));
        return responseDataJson;
    }

    @Override
    public ResponseData<Boolean> setPublicKey(SetPublicKeyArgs setPublicKeyArgs) {
        if (!this.verifySetPublicKeyArgs(setPublicKeyArgs)) {
            logger.error("[setPublicKey]: input parameter setPublicKeyArgs is illegal.");
            return new ResponseData<Boolean>(false, ErrorCode.ILLEGAL_INPUT);
        }
        if (!WeIdUtils.isPrivateKeyValid(setPublicKeyArgs.getUserWeIdPrivateKey())) {
            return new ResponseData<Boolean>(false, ErrorCode.WEID_PRIVATEKEY_INVALID);
        }
        String weId = setPublicKeyArgs.getWeId();
        String weAddress = WeIdUtils.convertWeIdToAddress(weId);
        if (StringUtils.isEmpty((CharSequence)weAddress)) {
            logger.error("setPublicKey: weId : {} is invalid.", (Object)weId);
            return new ResponseData<Boolean>(false, ErrorCode.WEID_INVALID);
        }
        String owner = setPublicKeyArgs.getOwner();
        if (StringUtils.isEmpty((CharSequence)owner)) {
            owner = weAddress;
        } else if (WeIdUtils.isWeIdValid(owner)) {
            owner = WeIdUtils.convertWeIdToAddress(owner);
        } else {
            logger.error("setPublicKey: owner : {} is invalid.", (Object)owner);
            return new ResponseData<Boolean>(false, ErrorCode.WEID_INVALID);
        }
        String pubKey = setPublicKeyArgs.getPublicKey();
        String privateKey = setPublicKeyArgs.getUserWeIdPrivateKey().getPrivateKey();
        try {
            String attributeKey = new StringBuffer().append("/weId/pubkey").append("/").append(setPublicKeyArgs.getType()).append("/").append("base64").toString();
            String attrValue = new StringBuffer().append(pubKey).append("/").append(owner).toString();
            return weIdServiceEngine.setAttribute(weAddress, attributeKey, attrValue, privateKey);
        }
        catch (PrivateKeyIllegalException e) {
            logger.error("[setPublicKey] set PublicKey failed because privateKey is illegal. ", (Throwable)e);
            return new ResponseData<Boolean>(false, e.getErrorCode());
        }
        catch (Exception e) {
            logger.error("[setPublicKey] set PublicKey failed with exception. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> setService(SetServiceArgs setServiceArgs) {
        if (!this.verifySetServiceArgs(setServiceArgs)) {
            logger.error("[setService]: input parameter setServiceArgs is illegal.");
            return new ResponseData<Boolean>(false, ErrorCode.ILLEGAL_INPUT);
        }
        if (!WeIdUtils.isPrivateKeyValid(setServiceArgs.getUserWeIdPrivateKey())) {
            return new ResponseData<Boolean>(false, ErrorCode.WEID_PRIVATEKEY_INVALID);
        }
        if (!this.verifyServiceType(setServiceArgs.getType())) {
            logger.error("[setService]: the length of service type is overlimit");
            return new ResponseData<Boolean>(false, ErrorCode.WEID_SERVICE_TYPE_OVERLIMIT);
        }
        String weId = setServiceArgs.getWeId();
        String serviceType = setServiceArgs.getType();
        String serviceEndpoint = setServiceArgs.getServiceEndpoint();
        if (WeIdUtils.isWeIdValid(weId)) {
            String privateKey = setServiceArgs.getUserWeIdPrivateKey().getPrivateKey();
            try {
                String attributeKey = new StringBuffer().append("/weId/service").append("/").append(serviceType).toString();
                return weIdServiceEngine.setAttribute(WeIdUtils.convertWeIdToAddress(weId), attributeKey, serviceEndpoint, privateKey);
            }
            catch (PrivateKeyIllegalException e) {
                logger.error("[setService] set PublicKey failed because privateKey is illegal. ", (Throwable)e);
                return new ResponseData<Boolean>(false, e.getErrorCode());
            }
            catch (Exception e) {
                logger.error("[setService] set service failed. Error message :{}", (Throwable)e);
                return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
            }
        }
        logger.error("[setService] set service failed, weid -->{} is invalid.", (Object)weId);
        return new ResponseData<Boolean>(false, ErrorCode.WEID_INVALID);
    }

    @Override
    public ResponseData<Boolean> isWeIdExist(String weId) {
        if (!WeIdUtils.isWeIdValid(weId)) {
            logger.error("[isWeIdExist] check weid failed. weid : {} is invalid.", (Object)weId);
            return new ResponseData<Boolean>(false, ErrorCode.WEID_INVALID);
        }
        return weIdServiceEngine.isWeIdExist(weId);
    }

    @Override
    public ResponseData<Boolean> setAuthentication(SetAuthenticationArgs setAuthenticationArgs) {
        if (!this.verifySetAuthenticationArgs(setAuthenticationArgs)) {
            logger.error("[setAuthentication]: input parameter setAuthenticationArgs is illegal.");
            return new ResponseData<Boolean>(false, ErrorCode.ILLEGAL_INPUT);
        }
        if (!WeIdUtils.isPrivateKeyValid(setAuthenticationArgs.getUserWeIdPrivateKey())) {
            return new ResponseData<Boolean>(false, ErrorCode.WEID_PRIVATEKEY_INVALID);
        }
        String weId = setAuthenticationArgs.getWeId();
        if (WeIdUtils.isWeIdValid(weId)) {
            String weAddress = WeIdUtils.convertWeIdToAddress(weId);
            String owner = setAuthenticationArgs.getOwner();
            if (StringUtils.isEmpty((CharSequence)owner)) {
                owner = weAddress;
            } else if (WeIdUtils.isWeIdValid(owner)) {
                owner = WeIdUtils.convertWeIdToAddress(owner);
            } else {
                logger.error("[setAuthentication]: owner : {} is invalid.", (Object)owner);
                return new ResponseData<Boolean>(false, ErrorCode.WEID_INVALID);
            }
            String privateKey = setAuthenticationArgs.getUserWeIdPrivateKey().getPrivateKey();
            try {
                String attrValue = new StringBuffer().append(setAuthenticationArgs.getPublicKey()).append("/").append(owner).toString();
                return weIdServiceEngine.setAttribute(weAddress, "/weId/auth", attrValue, privateKey);
            }
            catch (PrivateKeyIllegalException e) {
                logger.error("Set authenticate with private key exception. Error message :{}", (Throwable)e);
                return new ResponseData<Boolean>(false, e.getErrorCode());
            }
            catch (Exception e) {
                logger.error("Set authenticate failed. Error message :{}", (Throwable)e);
                return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
            }
        }
        logger.error("Set authenticate failed. weid : {} is invalid.", (Object)weId);
        return new ResponseData<Boolean>(false, ErrorCode.WEID_INVALID);
    }

    private boolean verifySetServiceArgs(SetServiceArgs setServiceArgs) {
        return setServiceArgs != null && !StringUtils.isBlank((CharSequence)setServiceArgs.getType()) && setServiceArgs.getUserWeIdPrivateKey() != null && !StringUtils.isBlank((CharSequence)setServiceArgs.getServiceEndpoint());
    }

    private boolean verifyServiceType(String type) {
        String serviceType = new StringBuffer().append("/weId/service").append("/").append(type).toString();
        int serviceTypeLength = serviceType.getBytes(StandardCharsets.UTF_8).length;
        return serviceTypeLength <= WeIdConstant.BYTES32_FIXED_LENGTH;
    }

    private ResponseData<Boolean> processCreateWeId(String weId, String publicKey, String privateKey) {
        String address = WeIdUtils.convertWeIdToAddress(weId);
        try {
            return weIdServiceEngine.createWeId(address, publicKey, privateKey);
        }
        catch (PrivateKeyIllegalException e) {
            logger.error("[createWeId] create weid failed because privateKey is illegal. ", (Throwable)e);
            return new ResponseData<Boolean>(false, e.getErrorCode());
        }
        catch (LoadContractException e) {
            logger.error("[createWeId] create weid failed because Load Contract with exception. ", (Throwable)e);
            return new ResponseData<Boolean>(false, e.getErrorCode());
        }
        catch (Exception e) {
            logger.error("[createWeId] create weid failed with exception. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
        }
    }

    private boolean verifySetPublicKeyArgs(SetPublicKeyArgs setPublicKeyArgs) {
        return setPublicKeyArgs != null && setPublicKeyArgs.getType() != null && setPublicKeyArgs.getUserWeIdPrivateKey() != null && !StringUtils.isBlank((CharSequence)setPublicKeyArgs.getPublicKey());
    }

    private boolean verifySetAuthenticationArgs(SetAuthenticationArgs setAuthenticationArgs) {
        return setAuthenticationArgs != null && setAuthenticationArgs.getUserWeIdPrivateKey() != null && !StringUtils.isEmpty((CharSequence)setAuthenticationArgs.getPublicKey());
    }
}

