/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.callback;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.protocol.amop.GetEncryptKeyArgs;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.response.GetEncryptKeyResponse;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.WeIdService;
import com.webank.weid.rpc.callback.AmopCallback;
import com.webank.weid.service.impl.WeIdServiceImpl;
import com.webank.weid.suite.api.persistence.Persistence;
import com.webank.weid.suite.persistence.sql.driver.MysqlDriver;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.PropertyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerCallback
extends AmopCallback {
    private static final Logger logger = LoggerFactory.getLogger(KeyManagerCallback.class);
    private Persistence dataDriver = new MysqlDriver();
    private WeIdService weidService;
    private static final String TRANSENCRYPTIONDOMAIN = PropertyUtils.getProperty("default.domain");

    private WeIdService getWeIdService() {
        if (this.weidService == null) {
            this.weidService = new WeIdServiceImpl();
        }
        return this.weidService;
    }

    @Override
    public GetEncryptKeyResponse onPush(GetEncryptKeyArgs arg) {
        logger.info("[KeyManagerCallback.onPush] begin query key param:{}", (Object)arg);
        GetEncryptKeyResponse encryptResponse = new GetEncryptKeyResponse();
        ResponseData<String> keyResponse = this.dataDriver.get(TRANSENCRYPTIONDOMAIN, arg.getKeyId());
        if (keyResponse.getErrorCode().intValue() == ErrorCode.SUCCESS.getCode() && StringUtils.isBlank((CharSequence)keyResponse.getResult())) {
            logger.info("[KeyManagerCallback.onPush] the encrypt key is not exists.");
            encryptResponse.setEncryptKey("");
            encryptResponse.setErrorCode(ErrorCode.ENCRYPT_KEY_NOT_EXISTS.getCode());
            encryptResponse.setErrorMessage(ErrorCode.ENCRYPT_KEY_NOT_EXISTS.getCodeDesc());
        } else {
            encryptResponse.setEncryptKey("");
            if (keyResponse.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                encryptResponse.setErrorCode((int)keyResponse.getErrorCode());
                encryptResponse.setErrorMessage(keyResponse.getErrorMessage());
                return encryptResponse;
            }
            try {
                Map keyMap = (Map)DataToolUtils.deserialize(keyResponse.getResult(), new HashMap().getClass());
                if (!this.checkAuthority(arg, keyMap)) {
                    encryptResponse.setErrorCode(ErrorCode.ENCRYPT_KEY_NO_PERMISSION.getCode());
                    encryptResponse.setErrorMessage(ErrorCode.ENCRYPT_KEY_NO_PERMISSION.getCodeDesc());
                } else if (this.isExpire(keyMap)) {
                    logger.info("[KeyManagerCallback.onPush]  the key is expire.");
                    encryptResponse.setErrorCode(ErrorCode.ENCRYPT_KEY_EXPIRE.getCode());
                    encryptResponse.setErrorMessage(ErrorCode.ENCRYPT_KEY_EXPIRE.getCodeDesc());
                } else {
                    encryptResponse.setEncryptKey((String)keyMap.get("keyData"));
                    encryptResponse.setErrorCode(ErrorCode.SUCCESS.getCode());
                    encryptResponse.setErrorMessage(ErrorCode.SUCCESS.getCodeDesc());
                }
            }
            catch (DataTypeCastException e) {
                logger.error("[KeyManagerCallback.onPush]  deserialize the data error.", (Throwable)e);
                encryptResponse.setErrorCode(ErrorCode.ENCRYPT_KEY_INVALID.getCode());
                encryptResponse.setErrorMessage(ErrorCode.ENCRYPT_KEY_INVALID.getCodeDesc());
            }
        }
        return encryptResponse;
    }

    private boolean checkAuthority(GetEncryptKeyArgs arg, Map<String, Object> keyMap) {
        if (keyMap == null) {
            logger.info("[checkAuthority] illegal input.");
            return false;
        }
        ArrayList verifiers = (ArrayList)keyMap.get("verifiers");
        if (CollectionUtils.isEmpty((Collection)verifiers) || StringUtils.isBlank((CharSequence)arg.getWeId()) || !verifiers.contains(arg.getWeId())) {
            logger.info("[checkAuthority] no access to get the data, this weid is {}.", (Object)arg.getWeId());
            return false;
        }
        ResponseData<WeIdDocument> domRes = this.getWeIdService().getWeIdDocument(arg.getWeId());
        if (domRes.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
            logger.info("[checkAuthority] can not get the WeIdDocument, this weid is {}.", (Object)arg.getWeId());
            return false;
        }
        ErrorCode errorCode = DataToolUtils.verifySignatureFromWeId(arg.getKeyId(), arg.getSignValue(), domRes.getResult());
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            logger.info("[checkAuthority] the data is be changed, this weid is {}.", (Object)arg.getWeId());
            return false;
        }
        return true;
    }

    private boolean isExpire(Map<String, Object> keyMap) {
        long expire = (Long)keyMap.get("expirationDate");
        return System.currentTimeMillis() > expire;
    }
}

