/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.callback;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.amop.GetPolicyAndChallengeArgs;
import com.webank.weid.protocol.base.PolicyAndChallenge;
import com.webank.weid.protocol.response.GetPolicyAndChallengeResponse;
import com.webank.weid.rpc.callback.AmopCallback;
import com.webank.weid.service.impl.callback.PresentationPolicyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresentationCallback
extends AmopCallback {
    private static final Logger logger = LoggerFactory.getLogger(PresentationCallback.class);
    private PresentationPolicyService policyService;

    @Override
    public GetPolicyAndChallengeResponse onPush(GetPolicyAndChallengeArgs arg) {
        PolicyAndChallenge policyAndChallenge;
        logger.info("PresentationCallback param:{}", (Object)arg);
        GetPolicyAndChallengeResponse response = new GetPolicyAndChallengeResponse();
        if (this.policyService == null) {
            logger.error("PresentationCallback policyService is null");
            response.setErrorCode(ErrorCode.POLICY_SERVICE_NOT_EXISTS.getCode());
            response.setErrorMessage(ErrorCode.POLICY_SERVICE_NOT_EXISTS.getCodeDesc());
            return response;
        }
        try {
            policyAndChallenge = this.policyService.policyAndChallengeOnPush(arg.getPolicyId(), arg.getTargetUserWeId());
        }
        catch (Exception e) {
            logger.error("the policy service call fail, please check the error log.", (Throwable)e);
            response.setErrorCode(ErrorCode.POLICY_SERVICE_CALL_FAIL.getCode());
            response.setErrorMessage(ErrorCode.POLICY_SERVICE_CALL_FAIL.getCodeDesc());
            return response;
        }
        response.setErrorCode(ErrorCode.SUCCESS.getCode());
        response.setErrorMessage(ErrorCode.SUCCESS.getCodeDesc());
        response.setPolicyAndChallenge(policyAndChallenge);
        return response;
    }

    public void registPolicyService(PresentationPolicyService service) {
        this.policyService = service;
    }
}

