/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine;

import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.exception.LoadContractException;
import com.webank.weid.service.BaseService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseEngine
extends BaseService {
    private static final Logger logger = LoggerFactory.getLogger(BaseEngine.class);

    private static <T> T loadContract(String contractAddress, Object credentials, Class<T> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = cls.getMethod("load", String.class, BaseEngine.getWeb3jClass(), credentials.getClass(), BigInteger.class, BigInteger.class);
        Object contract = method.invoke(null, contractAddress, BaseEngine.getWeb3j(), credentials, WeIdConstant.GAS_PRICE, WeIdConstant.GAS_LIMIT);
        return (T)contract;
    }

    protected static <T> T reloadContract(String contractAddress, String privateKey, Class<T> cls) {
        if (weServer == null) {
            BaseEngine.init();
        }
        T contract = null;
        try {
            contract = BaseEngine.loadContract(contractAddress, weServer.createCredentials(privateKey), cls);
            logger.info(cls.getSimpleName() + " init succ");
        }
        catch (Exception e) {
            logger.error("load contract :{} failed. Error message is :{}", (Object)cls.getSimpleName(), (Object)e);
            throw new LoadContractException();
        }
        if (contract == null) {
            throw new LoadContractException();
        }
        return contract;
    }

    protected static <T> T getContractService(String contractAddress, Class<T> cls) {
        T contract = null;
        try {
            if (weServer == null) {
                BaseEngine.init();
            }
            contract = BaseEngine.loadContract(contractAddress, weServer.getCredentials(), cls);
            logger.info(cls.getSimpleName() + " init succ");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.error("load contract :{} failed. Error message is :{}", (Object)cls.getSimpleName(), (Object)e);
            throw new LoadContractException();
        }
        catch (Exception e) {
            logger.error("load contract Exception:{} failed. Error message is :{}", (Object)cls.getSimpleName(), (Object)e);
            throw new LoadContractException();
        }
        if (contract == null) {
            throw new LoadContractException();
        }
        return contract;
    }
}

