/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine;

import com.webank.weid.service.impl.engine.AuthorityIssuerServiceEngine;
import com.webank.weid.service.impl.engine.CptServiceEngine;
import com.webank.weid.service.impl.engine.EvidenceServiceEngine;
import com.webank.weid.service.impl.engine.RawTransactionServiceEngine;
import com.webank.weid.service.impl.engine.WeIdServiceEngine;
import com.webank.weid.service.impl.engine.fiscov1.AuthorityIssuerEngineV1;
import com.webank.weid.service.impl.engine.fiscov1.CptServiceEngineV1;
import com.webank.weid.service.impl.engine.fiscov1.EvidenceServiceEngineV1;
import com.webank.weid.service.impl.engine.fiscov1.RawTransactionServiceEngineV1;
import com.webank.weid.service.impl.engine.fiscov1.WeIdServiceEngineV1;
import com.webank.weid.service.impl.engine.fiscov2.AuthorityIssuerEngineV2;
import com.webank.weid.service.impl.engine.fiscov2.CptServiceEngineV2;
import com.webank.weid.service.impl.engine.fiscov2.EvidenceServiceEngineV2;
import com.webank.weid.service.impl.engine.fiscov2.RawTransactionServiceEngineV2;
import com.webank.weid.service.impl.engine.fiscov2.WeIdServiceEngineV2;
import com.webank.weid.util.PropertyUtils;

public class EngineFactory {
    private static String fiscoVersion = PropertyUtils.getProperty("bcos.version", "1.3");

    public static WeIdServiceEngine createWeIdServiceEngine() {
        if (fiscoVersion.startsWith("1")) {
            return new WeIdServiceEngineV1();
        }
        return new WeIdServiceEngineV2();
    }

    public static CptServiceEngine createCptServiceEngine() {
        if (fiscoVersion.startsWith("1")) {
            return new CptServiceEngineV1();
        }
        return new CptServiceEngineV2();
    }

    public static AuthorityIssuerServiceEngine createAuthorityIssuerServiceEngine() {
        if (fiscoVersion.startsWith("1")) {
            return new AuthorityIssuerEngineV1();
        }
        return new AuthorityIssuerEngineV2();
    }

    public static EvidenceServiceEngine createEvidenceServiceEngine() {
        if (fiscoVersion.startsWith("1")) {
            return new EvidenceServiceEngineV1();
        }
        return new EvidenceServiceEngineV2();
    }

    public static RawTransactionServiceEngine createRawTransactionServiceEngine() {
        if (fiscoVersion.startsWith("1")) {
            return new RawTransactionServiceEngineV1();
        }
        return new RawTransactionServiceEngineV2();
    }
}

