/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov1;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.v1.AuthorityIssuerController;
import com.webank.weid.contract.v1.SpecificIssuerController;
import com.webank.weid.protocol.base.AuthorityIssuer;
import com.webank.weid.protocol.request.RegisterAuthorityIssuerArgs;
import com.webank.weid.protocol.request.RemoveAuthorityIssuerArgs;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.AuthorityIssuerServiceEngine;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.WeIdUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.Bool;
import org.bcos.web3j.abi.datatypes.DynamicArray;
import org.bcos.web3j.abi.datatypes.DynamicBytes;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityIssuerEngineV1
extends BaseEngine
implements AuthorityIssuerServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityIssuerEngineV1.class);
    private static AuthorityIssuerController authorityIssuerController = AuthorityIssuerEngineV1.getContractService(fiscoConfig.getIssuerAddress(), AuthorityIssuerController.class);
    private static SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV1.getContractService(fiscoConfig.getSpecificIssuerAddress(), SpecificIssuerController.class);

    private static AuthorityIssuerController reloadAuthorityIssuerContract(String privateKey) {
        AuthorityIssuerController authorityIssuerController = AuthorityIssuerEngineV1.reloadContract(fiscoConfig.getIssuerAddress(), privateKey, AuthorityIssuerController.class);
        return authorityIssuerController;
    }

    private static SpecificIssuerController reloadSpecificIssuerContract(String privateKey) {
        SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV1.reloadContract(fiscoConfig.getSpecificIssuerAddress(), privateKey, SpecificIssuerController.class);
        return specificIssuerController;
    }

    private static ErrorCode verifyAuthorityIssuerRelatedEvent(AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event, Integer opcode) {
        if (event == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (event.addr == null || event.operation == null || event.retCode == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        Integer eventOpcode = event.operation.getValue().intValue();
        if (eventOpcode.equals(opcode)) {
            Integer eventRetCode = event.retCode.getValue().intValue();
            return ErrorCode.getTypeByErrorCode(eventRetCode);
        }
        return ErrorCode.AUTHORITY_ISSUER_OPCODE_MISMATCH;
    }

    @Override
    public ResponseData<Boolean> addAuthorityIssuer(RegisterAuthorityIssuerArgs args) {
        AuthorityIssuer authorityIssuer = args.getAuthorityIssuer();
        String weAddress = WeIdUtils.convertWeIdToAddress(authorityIssuer.getWeId());
        String[] stringAttributes = this.loadNameToStringAttributes(authorityIssuer.getName());
        long[] longAttributes = new long[16];
        Long createDate = DateUtils.getNoMillisecondTimeStamp();
        longAttributes[0] = createDate;
        Address addr = new Address(weAddress);
        try {
            DynamicBytes accValue = new DynamicBytes(authorityIssuer.getAccValue().getBytes(StandardCharsets.UTF_8));
            AuthorityIssuerController authorityIssuerController = AuthorityIssuerEngineV1.reloadAuthorityIssuerContract(args.getWeIdPrivateKey().getPrivateKey());
            Future future = authorityIssuerController.addAuthorityIssuer(addr, DataToolUtils.stringArrayToBytes32StaticArray(stringAttributes), DataToolUtils.longArrayToInt256StaticArray(longAttributes), accValue);
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            TransactionInfo info = new TransactionInfo(receipt);
            List eventList = AuthorityIssuerController.getAuthorityIssuerRetLogEvents((TransactionReceipt)receipt);
            AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event = (AuthorityIssuerController.AuthorityIssuerRetLogEventResponse)eventList.get(0);
            ErrorCode errorCode = AuthorityIssuerEngineV1.verifyAuthorityIssuerRelatedEvent(event, WeIdConstant.ADD_AUTHORITY_ISSUER_OPCODE);
            return new ResponseData<Boolean>(Boolean.valueOf(errorCode.getCode() == ErrorCode.SUCCESS.getCode()), errorCode, info);
        }
        catch (TimeoutException e) {
            logger.error("register authority issuer failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("register authority issuer failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    private String[] loadNameToStringAttributes(String name) {
        String[] nameArray = new String[WeIdConstant.AUTHORITY_ISSUER_ARRAY_LEGNTH.intValue()];
        nameArray[0] = name;
        return nameArray;
    }

    @Override
    public ResponseData<Boolean> removeAuthorityIssuer(RemoveAuthorityIssuerArgs args) {
        String weId = args.getWeId();
        Address addr = new Address(WeIdUtils.convertWeIdToAddress(weId));
        try {
            AuthorityIssuerController authorityIssuerController = AuthorityIssuerEngineV1.reloadAuthorityIssuerContract(args.getWeIdPrivateKey().getPrivateKey());
            Future future = authorityIssuerController.removeAuthorityIssuer(addr);
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            List eventList = AuthorityIssuerController.getAuthorityIssuerRetLogEvents((TransactionReceipt)receipt);
            TransactionInfo info = new TransactionInfo(receipt);
            AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event = (AuthorityIssuerController.AuthorityIssuerRetLogEventResponse)eventList.get(0);
            if (event != null) {
                ErrorCode errorCode = AuthorityIssuerEngineV1.verifyAuthorityIssuerRelatedEvent(event, WeIdConstant.REMOVE_AUTHORITY_ISSUER_OPCODE);
                if (ErrorCode.SUCCESS.getCode() != errorCode.getCode()) {
                    return new ResponseData<Boolean>(Boolean.valueOf(false), errorCode, info);
                }
                return new ResponseData<Boolean>(Boolean.valueOf(true), errorCode, info);
            }
            logger.error("remove authority issuer failed, transcation event decoding failure.");
            return new ResponseData<Boolean>(Boolean.valueOf(false), ErrorCode.AUTHORITY_ISSUER_ERROR, info);
        }
        catch (TimeoutException e) {
            logger.error("remove authority issuer failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("remove authority issuer failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> isAuthorityIssuer(String address) {
        ResponseData<Boolean> resultData = new ResponseData<Boolean>();
        Address addr = new Address(address);
        try {
            Future future = authorityIssuerController.isAuthorityIssuer(addr);
            Boolean result = ((Bool)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS)).getValue();
            resultData.setResult(result);
            if (result.booleanValue()) {
                resultData.setErrorCode(ErrorCode.SUCCESS);
            } else {
                resultData.setErrorCode(ErrorCode.AUTHORITY_ISSUER_CONTRACT_ERROR_NOT_EXISTS);
            }
            return resultData;
        }
        catch (TimeoutException e) {
            logger.error("check authority issuer id failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("check authority issuer id failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<AuthorityIssuer> getAuthorityIssuerInfoNonAccValue(String weId) {
        ResponseData<AuthorityIssuer> resultData = new ResponseData<AuthorityIssuer>();
        Address addr = new Address(WeIdUtils.convertWeIdToAddress(weId));
        try {
            List rawResult = (List)authorityIssuerController.getAuthorityIssuerInfoNonAccValue(addr).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            if (rawResult == null) {
                return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_ERROR);
            }
            DynamicArray bytes32Attributes = (DynamicArray)rawResult.get(0);
            DynamicArray int256Attributes = (DynamicArray)rawResult.get(1);
            AuthorityIssuer result = new AuthorityIssuer();
            result.setWeId(weId);
            String name = this.extractNameFromBytes32Attributes(bytes32Attributes.getValue());
            Long createDate = ((Int256)int256Attributes.getValue().get(0)).getValue().longValue();
            if (StringUtils.isEmpty((CharSequence)name) && createDate.equals(WeIdConstant.LONG_VALUE_ZERO)) {
                return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_CONTRACT_ERROR_NOT_EXISTS);
            }
            result.setName(name);
            result.setCreated(createDate);
            result.setAccValue("");
            resultData.setResult(result);
            return resultData;
        }
        catch (TimeoutException e) {
            logger.error("query authority issuer failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("query authority issuer failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    private String extractNameFromBytes32Attributes(List<Bytes32> bytes32Array) {
        StringBuffer name = new StringBuffer();
        int maxLength = WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH / 32;
        for (int i = 0; i < maxLength; ++i) {
            name.append(DataToolUtils.bytes32ToString(bytes32Array.get(i)));
        }
        return name.toString();
    }

    @Override
    public List<String> getAuthorityIssuerAddressList(Integer index, Integer num) {
        ArrayList<String> addrList = new ArrayList<String>();
        try {
            List addressList = ((DynamicArray)authorityIssuerController.getAuthorityIssuerAddressList(new Uint256((long)index.intValue()), new Uint256((long)num.intValue())).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS)).getValue();
            if (CollectionUtils.isNotEmpty((Collection)addressList)) {
                for (Address addr : addressList) {
                    addrList.add(addr.toString());
                }
            }
        }
        catch (TimeoutException e) {
            logger.error("query authority issuer list failed due to system timeout. ", (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("query authority issuer list failed due to transaction error. ", (Throwable)e);
        }
        return addrList;
    }

    @Override
    public ResponseData<Boolean> removeIssuer(String issuerType, String issuerAddress, String privateKey) {
        try {
            SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV1.reloadSpecificIssuerContract(privateKey);
            Future future = specificIssuerController.removeIssuer(DataToolUtils.stringToBytes32(issuerType), new Address(issuerAddress));
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            TransactionInfo info = new TransactionInfo(receipt);
            ErrorCode errorCode = this.resolveSpecificIssuerEvents(receipt, false, issuerAddress);
            return new ResponseData<Boolean>(Boolean.valueOf(errorCode.getCode() == ErrorCode.SUCCESS.getCode()), errorCode, info);
        }
        catch (TimeoutException e) {
            logger.error("remove issuer from type failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("remove issuer from type failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    private ErrorCode resolveSpecificIssuerEvents(TransactionReceipt transactionReceipt, boolean isRegister, String address) {
        List eventList = SpecificIssuerController.getSpecificIssuerRetLogEvents((TransactionReceipt)transactionReceipt);
        SpecificIssuerController.SpecificIssuerRetLogEventResponse event = (SpecificIssuerController.SpecificIssuerRetLogEventResponse)eventList.get(0);
        if (event != null) {
            if (isRegister ? event.operation.getValue().intValue() != WeIdConstant.ADD_AUTHORITY_ISSUER_OPCODE.intValue() || !StringUtils.equalsIgnoreCase((CharSequence)event.addr.toString(), (CharSequence)address) : event.operation.getValue().intValue() != WeIdConstant.REMOVE_AUTHORITY_ISSUER_OPCODE.intValue() || !StringUtils.equalsIgnoreCase((CharSequence)event.addr.toString(), (CharSequence)address)) {
                return ErrorCode.TRANSACTION_EXECUTE_ERROR;
            }
            Integer eventRetCode = event.retCode.getValue().intValue();
            return ErrorCode.getTypeByErrorCode(eventRetCode);
        }
        logger.error("specific issuer type resolution failed due to event decoding failure.");
        return ErrorCode.UNKNOW_ERROR;
    }

    @Override
    public ResponseData<Boolean> isSpecificTypeIssuer(String issuerType, String address) {
        try {
            Future future = specificIssuerController.isSpecificTypeIssuer(DataToolUtils.stringToBytes32(issuerType), new Address(address));
            Boolean result = ((Bool)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS)).getValue();
            if (!result.booleanValue()) {
                return new ResponseData<Boolean>(result, ErrorCode.SPECIFIC_ISSUER_CONTRACT_ERROR_ALREADY_NOT_EXIST);
            }
            return new ResponseData<Boolean>(result, ErrorCode.SUCCESS);
        }
        catch (TimeoutException e) {
            logger.error("check issuer type failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("check issuer type failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<List<String>> getSpecificTypeIssuerList(String issuerType, Integer index, Integer num) {
        try {
            List addresses = ((DynamicArray)specificIssuerController.getSpecificTypeIssuerList(DataToolUtils.stringToBytes32(issuerType), new Uint256((long)index.intValue()), new Uint256((long)num.intValue())).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS)).getValue();
            ArrayList<String> addressList = new ArrayList<String>();
            for (Address addr : addresses) {
                if (WeIdUtils.isEmptyAddress(addr)) continue;
                addressList.add(addr.toString());
            }
            return new ResponseData<List<String>>(addressList, ErrorCode.SUCCESS);
        }
        catch (TimeoutException e) {
            logger.error("get all specific issuers failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("get all specific issuers failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> registerIssuerType(String issuerType, String privateKey) {
        try {
            SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV1.reloadSpecificIssuerContract(privateKey);
            Future future = specificIssuerController.registerIssuerType(DataToolUtils.stringToBytes32(issuerType));
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            TransactionInfo info = new TransactionInfo(receipt);
            String emptyAddress = new Address(BigInteger.ZERO).toString();
            ErrorCode errorCode = this.resolveSpecificIssuerEvents(receipt, true, emptyAddress);
            return new ResponseData<Boolean>(Boolean.valueOf(errorCode.getCode() == ErrorCode.SUCCESS.getCode()), errorCode, info);
        }
        catch (TimeoutException e) {
            logger.error("register issuer type failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("register issuer type failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> addIssuer(String issuerType, String issuerAddress, String privateKey) {
        try {
            SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV1.reloadSpecificIssuerContract(privateKey);
            Future future = specificIssuerController.addIssuer(DataToolUtils.stringToBytes32(issuerType), new Address(issuerAddress));
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            TransactionInfo info = new TransactionInfo(receipt);
            ErrorCode errorCode = this.resolveSpecificIssuerEvents(receipt, true, issuerAddress);
            return new ResponseData<Boolean>(Boolean.valueOf(errorCode.getCode() == ErrorCode.SUCCESS.getCode()), errorCode, info);
        }
        catch (TimeoutException e) {
            logger.error("add issuer into type failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("add issuer into type failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }
}

