/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov1;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.v1.CptController;
import com.webank.weid.protocol.base.Cpt;
import com.webank.weid.protocol.base.CptBaseInfo;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.RsvSignature;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.service.impl.engine.CptServiceEngine;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.TransactionUtils;
import com.webank.weid.util.WeIdUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections4.CollectionUtils;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.DynamicArray;
import org.bcos.web3j.abi.datatypes.StaticArray;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.abi.datatypes.generated.Uint8;
import org.bcos.web3j.crypto.Sign;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CptServiceEngineV1
extends BaseEngine
implements CptServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(CptServiceEngineV1.class);
    private static CptController cptController = CptServiceEngineV1.getContractService(fiscoConfig.getCptAddress(), CptController.class);

    public static ResponseData<CptBaseInfo> resolveRegisterCptEvents(TransactionReceipt transactionReceipt) {
        List event = CptController.getRegisterCptRetLogEvents((TransactionReceipt)transactionReceipt);
        if (CollectionUtils.isEmpty((Collection)event)) {
            logger.error("[registerCpt] event is empty");
            return new ResponseData<Object>(null, ErrorCode.CPT_EVENT_LOG_NULL);
        }
        return CptServiceEngineV1.getResultByResolveEvent(((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).retCode, ((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).cptId, ((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).cptVersion, transactionReceipt);
    }

    public static ResponseData<CptBaseInfo> resolveUpdateCptEvents(TransactionReceipt transactionReceipt) {
        List event = CptController.getUpdateCptRetLogEvents((TransactionReceipt)transactionReceipt);
        if (CollectionUtils.isEmpty((Collection)event)) {
            logger.error("[updateCpt] event is empty");
            return new ResponseData<Object>(null, ErrorCode.CPT_EVENT_LOG_NULL);
        }
        return CptServiceEngineV1.getResultByResolveEvent(((CptController.UpdateCptRetLogEventResponse)event.get((int)0)).retCode, ((CptController.UpdateCptRetLogEventResponse)event.get((int)0)).cptId, ((CptController.UpdateCptRetLogEventResponse)event.get((int)0)).cptVersion, transactionReceipt);
    }

    public static ResponseData<CptBaseInfo> getResultByResolveEvent(Uint256 retCode, Uint256 cptId, Int256 cptVersion, TransactionReceipt receipt) {
        TransactionInfo info = new TransactionInfo(receipt);
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_ID_AUTHORITY_ISSUER_EXCEED_MAX.getCode()) {
            logger.error("[getResultByResolveEvent] cptId limited max value. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_ID_AUTHORITY_ISSUER_EXCEED_MAX, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_ALREADY_EXIST.getCode()) {
            logger.error("[getResultByResolveEvent] cpt already exists on chain. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_ALREADY_EXIST, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_NO_PERMISSION.getCode()) {
            logger.error("[getResultByResolveEvent] no permission. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_NO_PERMISSION, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_PUBLISHER_NOT_EXIST.getCode()) {
            logger.error("[getResultByResolveEvent] publisher does not exist. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_PUBLISHER_NOT_EXIST, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_NOT_EXISTS.getCode()) {
            logger.error("[getResultByResolveEvent] cpt id : {} does not exist.", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_NOT_EXISTS, info);
        }
        CptBaseInfo result = new CptBaseInfo();
        result.setCptId(DataToolUtils.uint256ToInt(cptId));
        result.setCptVersion(DataToolUtils.int256ToInt(cptVersion));
        return new ResponseData<CptBaseInfo>(result, ErrorCode.SUCCESS, info);
    }

    @Override
    public ResponseData<CptBaseInfo> updateCpt(int cptId, String address, String cptJsonSchemaNew, RsvSignature rsvSignature, String privateKey) {
        StaticArray<Bytes32> bytes32Array = DataToolUtils.stringArrayToBytes32StaticArray(new String[WeIdConstant.CPT_STRING_ARRAY_LENGTH.intValue()]);
        try {
            CptController cptController = CptServiceEngineV1.reloadContract(fiscoConfig.getCptAddress(), privateKey, CptController.class);
            TransactionReceipt receipt = (TransactionReceipt)cptController.updateCpt(DataToolUtils.intToUint256(cptId), new Address(address), TransactionUtils.getParamUpdated(WeIdConstant.CPT_LONG_ARRAY_LENGTH), bytes32Array, TransactionUtils.getParamJsonSchema(cptJsonSchemaNew), rsvSignature.getV(), rsvSignature.getR(), rsvSignature.getS()).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            return CptServiceEngineV1.resolveUpdateCptEvents(receipt);
        }
        catch (TimeoutException e) {
            logger.error("[updateCpt] transaction execute with timeout exception. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("[updateCpt] transaction execute with exception. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> registerCpt(int cptId, String address, String cptJsonSchemaNew, RsvSignature rsvSignature, String privateKey) {
        StaticArray<Bytes32> bytes32Array = DataToolUtils.stringArrayToBytes32StaticArray(new String[WeIdConstant.CPT_STRING_ARRAY_LENGTH.intValue()]);
        try {
            CptController cptController = CptServiceEngineV1.reloadContract(fiscoConfig.getCptAddress(), privateKey, CptController.class);
            TransactionReceipt receipt = (TransactionReceipt)cptController.registerCpt(DataToolUtils.intToUint256(cptId), new Address(address), TransactionUtils.getParamCreated(WeIdConstant.CPT_LONG_ARRAY_LENGTH), bytes32Array, TransactionUtils.getParamJsonSchema(cptJsonSchemaNew), rsvSignature.getV(), rsvSignature.getR(), rsvSignature.getS()).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            return CptServiceEngineV1.resolveRegisterCptEvents(receipt);
        }
        catch (TimeoutException e) {
            logger.error("[updateCpt] transaction execute with timeout exception. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("[updateCpt] transaction execute with exception. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> registerCpt(String address, String cptJsonSchemaNew, RsvSignature rsvSignature, String privateKey) {
        StaticArray<Bytes32> bytes32Array = DataToolUtils.stringArrayToBytes32StaticArray(new String[WeIdConstant.CPT_STRING_ARRAY_LENGTH.intValue()]);
        try {
            CptController cptController = CptServiceEngineV1.reloadContract(fiscoConfig.getCptAddress(), privateKey, CptController.class);
            TransactionReceipt receipt = (TransactionReceipt)cptController.registerCpt(new Address(address), TransactionUtils.getParamCreated(WeIdConstant.CPT_LONG_ARRAY_LENGTH), bytes32Array, TransactionUtils.getParamJsonSchema(cptJsonSchemaNew), rsvSignature.getV(), rsvSignature.getR(), rsvSignature.getS()).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            return CptServiceEngineV1.resolveRegisterCptEvents(receipt);
        }
        catch (TimeoutException e) {
            logger.error("[updateCpt] transaction execute with timeout exception. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("[updateCpt] transaction execute with exception. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<Cpt> queryCpt(int cptId) {
        try {
            List typeList = (List)cptController.queryCpt(DataToolUtils.intToUint256(cptId)).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            if (typeList == null || typeList.isEmpty()) {
                logger.error("Query cpt id : {} does not exist, result is null.", (Object)cptId);
                return new ResponseData<Object>(null, ErrorCode.CPT_NOT_EXISTS);
            }
            if ("0x0000000000000000000000000000000000000000".equals(((Address)typeList.get(0)).toString())) {
                logger.error("Query cpt id : {} does not exist.", (Object)cptId);
                return new ResponseData<Object>(null, ErrorCode.CPT_NOT_EXISTS);
            }
            Cpt cpt = new Cpt();
            cpt.setCptId(cptId);
            cpt.setCptPublisher(WeIdUtils.convertAddressToWeId(((Address)typeList.get(0)).toString()));
            long[] longArray = DataToolUtils.int256DynamicArrayToLongArray((DynamicArray<Int256>)((DynamicArray)typeList.get(1)));
            cpt.setCptVersion((int)longArray[0]);
            cpt.setCreated(longArray[1]);
            cpt.setUpdated(longArray[2]);
            String jsonSchema = DataToolUtils.bytes32DynamicArrayToStringWithoutTrim((DynamicArray<Bytes32>)((DynamicArray)typeList.get(3)));
            Map jsonSchemaMap = DataToolUtils.deserialize(jsonSchema.toString().trim(), HashMap.class);
            cpt.setCptJsonSchema(jsonSchemaMap);
            int v = DataToolUtils.uint8ToInt((Uint8)typeList.get(4));
            byte[] r = DataToolUtils.bytes32ToBytesArray((Bytes32)typeList.get(5));
            byte[] s = DataToolUtils.bytes32ToBytesArray((Bytes32)typeList.get(6));
            Sign.SignatureData signatureData = DataToolUtils.rawSignatureDeserialization(v, r, s);
            String cptSignature = new String(DataToolUtils.base64Encode(DataToolUtils.simpleSignatureSerialization(signatureData)), StandardCharsets.UTF_8);
            cpt.setCptSignature(cptSignature);
            return new ResponseData<Cpt>(cpt, ErrorCode.SUCCESS);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("query cpt failed. Error message :{}", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
        catch (TimeoutException e) {
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
    }
}

