/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov1;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.v1.Evidence;
import com.webank.weid.contract.v1.EvidenceFactory;
import com.webank.weid.protocol.base.EvidenceInfo;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.service.impl.engine.EvidenceServiceEngine;
import com.webank.weid.util.DataToolUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.DynamicArray;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Uint8;
import org.bcos.web3j.crypto.ECKeyPair;
import org.bcos.web3j.crypto.Keys;
import org.bcos.web3j.crypto.Sign;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceServiceEngineV1
extends BaseEngine
implements EvidenceServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(EvidenceServiceEngineV1.class);

    @Override
    public ResponseData<String> createEvidence(Sign.SignatureData sigData, List<String> hashAttributes, List<String> extraValueList, String privateKey) {
        try {
            Bytes32 r = DataToolUtils.bytesArrayToBytes32(sigData.getR());
            Bytes32 s = DataToolUtils.bytesArrayToBytes32(sigData.getS());
            Uint8 v = DataToolUtils.intToUnt8(sigData.getV());
            ArrayList<Address> signer = new ArrayList<Address>();
            ECKeyPair keyPair = ECKeyPair.create((BigInteger)new BigInteger(privateKey));
            signer.add(new Address(Keys.getAddress((ECKeyPair)keyPair)));
            EvidenceFactory evidenceFactory = EvidenceServiceEngineV1.reloadContract(fiscoConfig.getEvidenceAddress(), privateKey, EvidenceFactory.class);
            Future future = evidenceFactory.createEvidence(new DynamicArray(this.generateBytes32List(hashAttributes)), new DynamicArray(signer), r, s, v, new DynamicArray(this.generateBytes32List(extraValueList)));
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            TransactionInfo info = new TransactionInfo(receipt);
            List eventResponseList = EvidenceFactory.getCreateEvidenceLogEvents((TransactionReceipt)receipt);
            EvidenceFactory.CreateEvidenceLogEventResponse event = (EvidenceFactory.CreateEvidenceLogEventResponse)eventResponseList.get(0);
            if (event != null) {
                ErrorCode innerResponse = this.verifyCreateEvidenceEvent(event.retCode.getValue().intValue(), event.addr.toString());
                if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
                    return new ResponseData<String>("", innerResponse, info);
                }
                return new ResponseData<String>(event.addr.toString(), ErrorCode.SUCCESS, info);
            }
            logger.error("create evidence failed due to transcation event decoding failure.");
            return new ResponseData<String>("", ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR, info);
        }
        catch (TimeoutException e) {
            logger.error("create evidence failed due to system timeout. ", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("create evidence failed due to transaction error. ", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    private List<Bytes32> generateBytes32List(List<String> bytes32List) {
        int desiredLength = bytes32List.size();
        ArrayList<Bytes32> finalList = new ArrayList<Bytes32>();
        for (int i = 0; i < desiredLength; ++i) {
            finalList.add(DataToolUtils.stringToBytes32(bytes32List.get(i)));
        }
        return finalList;
    }

    @Override
    public ResponseData<EvidenceInfo> getInfo(String evidenceAddress) {
        try {
            Evidence evidence = EvidenceServiceEngineV1.getContractService(evidenceAddress, Evidence.class);
            List rawResult = (List)evidence.getInfo().get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            if (rawResult == null) {
                return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
            }
            List credentialHashList = ((DynamicArray)rawResult.get(0)).getValue();
            List issuerList = ((DynamicArray)rawResult.get(1)).getValue();
            EvidenceInfo evidenceInfoData = new EvidenceInfo();
            evidenceInfoData.setCredentialHash("0x" + DataToolUtils.bytes32ToString((Bytes32)credentialHashList.get(0)) + DataToolUtils.bytes32ToString((Bytes32)credentialHashList.get(1)));
            ArrayList<String> signerStringList = new ArrayList<String>();
            for (Address addr : issuerList) {
                signerStringList.add(addr.toString());
            }
            evidenceInfoData.setSigners(signerStringList);
            ArrayList<String> signaturesList = new ArrayList<String>();
            List rlist = ((DynamicArray)rawResult.get(2)).getValue();
            List slist = ((DynamicArray)rawResult.get(3)).getValue();
            List vlist = ((DynamicArray)rawResult.get(4)).getValue();
            for (int index = 0; index < rlist.size(); ++index) {
                byte v = (byte)((Uint8)vlist.get(index)).getValue().intValue();
                byte[] r = ((Bytes32)rlist.get(index)).getValue();
                byte[] s = ((Bytes32)slist.get(index)).getValue();
                Sign.SignatureData sigData = new Sign.SignatureData(v, r, s);
                signaturesList.add(new String(DataToolUtils.base64Encode(DataToolUtils.simpleSignatureSerialization(sigData)), StandardCharsets.UTF_8));
            }
            evidenceInfoData.setSignatures(signaturesList);
            return new ResponseData<EvidenceInfo>(evidenceInfoData, ErrorCode.SUCCESS);
        }
        catch (TimeoutException e) {
            logger.error("create evidence failed due to system timeout. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("create evidence failed due to transaction error. ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }
}

