/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov1;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.ResolveEventLogStatus;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.v1.WeIdContract;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.exception.ResolveAttributeException;
import com.webank.weid.protocol.base.AuthenticationProperty;
import com.webank.weid.protocol.base.PublicKeyProperty;
import com.webank.weid.protocol.base.ServiceProperty;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.response.ResolveEventLogResult;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.service.impl.engine.WeIdServiceEngine;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.WeIdUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.abi.EventEncoder;
import org.bcos.web3j.abi.TypeReference;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.Bool;
import org.bcos.web3j.abi.datatypes.DynamicBytes;
import org.bcos.web3j.abi.datatypes.Event;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.protocol.Web3j;
import org.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.bcos.web3j.protocol.core.DefaultBlockParameterNumber;
import org.bcos.web3j.protocol.core.methods.response.EthBlock;
import org.bcos.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.bcos.web3j.protocol.core.methods.response.Log;
import org.bcos.web3j.protocol.core.methods.response.Transaction;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeIdServiceEngineV1
extends BaseEngine
implements WeIdServiceEngine {
    private static final int STOP_RESOLVE_BLOCK_NUMBER = 0;
    private static final Logger logger = LoggerFactory.getLogger(WeIdServiceEngineV1.class);
    private static final HashMap<String, String> topicMap = new HashMap();
    private static WeIdContract weIdContract;

    private static ResolveEventLogResult resolveAttributeEvent(String weId, TransactionReceipt receipt, WeIdDocument result) {
        List eventlog = WeIdContract.getWeIdAttributeChangedEvents((TransactionReceipt)receipt);
        ResolveEventLogResult response = new ResolveEventLogResult();
        if (CollectionUtils.isEmpty((Collection)eventlog)) {
            response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_EVENTLOG_NULL);
            return response;
        }
        int previousBlock = 0;
        for (WeIdContract.WeIdAttributeChangedEventResponse res : eventlog) {
            String weAddress;
            if (res.identity == null || res.updated == null || res.previousBlock == null) {
                response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_RES_NULL);
                return response;
            }
            String identity = res.identity.toString();
            if (result.getUpdated() == null) {
                long timeStamp = res.updated.getValue().longValue();
                result.setUpdated(timeStamp);
            }
            if (!StringUtils.equals((CharSequence)(weAddress = WeIdUtils.convertWeIdToAddress(weId)), (CharSequence)identity)) {
                response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_WEID_NOT_MATCH);
                return response;
            }
            String key = DataToolUtils.bytes32ToString(res.key);
            String value = DataToolUtils.dynamicBytesToString(res.value);
            previousBlock = res.previousBlock.getValue().intValue();
            WeIdServiceEngineV1.buildupWeIdAttribute(key, value, weId, result);
        }
        response.setPreviousBlock(previousBlock);
        response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_SUCCESS);
        return response;
    }

    private static void buildupWeIdAttribute(String key, String value, String weId, WeIdDocument result) {
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)"/weId/pubkey")) {
            WeIdServiceEngineV1.buildWeIdPublicKeys(value, weId, result);
        } else if (StringUtils.startsWith((CharSequence)key, (CharSequence)"/weId/auth")) {
            WeIdServiceEngineV1.buildWeIdPublicKeys(value, weId, result);
            WeIdServiceEngineV1.buildWeIdAuthentication(value, weId, result);
        } else if (StringUtils.startsWith((CharSequence)key, (CharSequence)"/weId/service")) {
            WeIdServiceEngineV1.buildWeIdService(key, value, weId, result);
        } else {
            WeIdServiceEngineV1.buildWeIdAttributeDefault(key, value, weId, result);
        }
    }

    private static void buildWeIdPublicKeys(String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdPublicKeys() parameter::value:{}, weId:{}, result:{}", new Object[]{value, weId, result});
        List<PublicKeyProperty> pubkeyList = result.getPublicKey();
        for (PublicKeyProperty pr : pubkeyList) {
            if (!StringUtils.contains((CharSequence)value, (CharSequence)pr.getPublicKey())) continue;
            return;
        }
        PublicKeyProperty pubKey = new PublicKeyProperty();
        pubKey.setId(new StringBuffer().append(weId).append("#keys-").append(result.getPublicKey().size()).toString());
        String[] publicKeyData = StringUtils.splitByWholeSeparator((String)value, (String)"/");
        if (publicKeyData != null && publicKeyData.length == 2) {
            pubKey.setPublicKey(publicKeyData[0]);
            String weAddress = publicKeyData[1];
            String owner = WeIdUtils.convertAddressToWeId(weAddress);
            pubKey.setOwner(owner);
        }
        result.getPublicKey().add(pubKey);
    }

    private static void buildWeIdAuthentication(String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdAuthentication() parameter::value:{}, weId:{}, result:{}", new Object[]{value, weId, result});
        AuthenticationProperty auth = new AuthenticationProperty();
        List<PublicKeyProperty> keys = result.getPublicKey();
        List<AuthenticationProperty> authList = result.getAuthentication();
        for (PublicKeyProperty r : keys) {
            if (!StringUtils.contains((CharSequence)value, (CharSequence)r.getPublicKey())) continue;
            for (AuthenticationProperty ar : authList) {
                if (!StringUtils.equals((CharSequence)ar.getPublicKey(), (CharSequence)r.getId())) continue;
                return;
            }
            auth.setPublicKey(r.getId());
            result.getAuthentication().add(auth);
        }
    }

    private static void buildWeIdService(String key, String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdService() parameter::key{}, value:{}, weId:{}, result:{}", new Object[]{key, value, weId, result});
        String service = StringUtils.splitByWholeSeparator((String)key, (String)"/")[2];
        List<ServiceProperty> serviceList = result.getService();
        for (ServiceProperty sr : serviceList) {
            if (!StringUtils.equals((CharSequence)service, (CharSequence)sr.getType())) continue;
            return;
        }
        ServiceProperty serviceResult = new ServiceProperty();
        serviceResult.setType(service);
        serviceResult.setServiceEndpoint(value);
        result.getService().add(serviceResult);
    }

    private static void buildWeIdAttributeDefault(String key, String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdAttributeDefault() parameter::key{}, value:{}, weId:{}, result:{}", new Object[]{key, value, weId, result});
        switch (key) {
            case "created": {
                result.setCreated(Long.valueOf(value));
                break;
            }
        }
    }

    private static ResolveEventLogResult resolveEventLog(String weId, Log log, TransactionReceipt receipt, WeIdDocument result) {
        String topic = (String)log.getTopics().get(0);
        String event = topicMap.get(topic);
        if (StringUtils.isNotBlank((CharSequence)event)) {
            switch (event) {
                case "WeIdAttributeChanged": {
                    return WeIdServiceEngineV1.resolveAttributeEvent(weId, receipt, result);
                }
            }
        }
        ResolveEventLogResult response = new ResolveEventLogResult();
        response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_EVENT_NULL);
        return response;
    }

    private static void resolveTransaction(String weId, int blockNumber, WeIdDocument result) {
        int previousBlock = blockNumber;
        while (previousBlock != 0) {
            int currentBlockNumber = previousBlock;
            EthBlock latestBlock = null;
            try {
                latestBlock = (EthBlock)((Web3j)WeIdServiceEngineV1.getWeb3j()).ethGetBlockByNumber((DefaultBlockParameter)new DefaultBlockParameterNumber((long)currentBlockNumber), true).send();
            }
            catch (IOException e) {
                logger.error("[resolveTransaction]:get block by number :{} failed. Exception message:{}", (Object)currentBlockNumber, (Object)e);
            }
            if (latestBlock == null) {
                logger.info("[resolveTransaction]:get block by number :{} . latestBlock is null", (Object)currentBlockNumber);
                return;
            }
            List transList = latestBlock.getBlock().getTransactions().stream().map(transactionResult -> (Transaction)transactionResult.get()).collect(Collectors.toList());
            previousBlock = 0;
            try {
                for (Transaction transaction : transList) {
                    String transHash = transaction.getHash();
                    EthGetTransactionReceipt rec1 = (EthGetTransactionReceipt)((Web3j)WeIdServiceEngineV1.getWeb3j()).ethGetTransactionReceipt(transHash).send();
                    TransactionReceipt receipt = (TransactionReceipt)rec1.getTransactionReceipt().get();
                    List logs = ((TransactionReceipt)rec1.getResult()).getLogs();
                    for (Log log : logs) {
                        ResolveEventLogResult returnValue = WeIdServiceEngineV1.resolveEventLog(weId, log, receipt, result);
                        if (!returnValue.getResultStatus().equals((Object)ResolveEventLogStatus.STATUS_SUCCESS) || returnValue.getPreviousBlock() == currentBlockNumber) continue;
                        previousBlock = returnValue.getPreviousBlock();
                    }
                }
            }
            catch (DataTypeCastException | IOException e) {
                logger.error("[resolveTransaction]: get TransactionReceipt by weId :{} failed.", (Object)weId, (Object)e);
                throw new ResolveAttributeException(ErrorCode.TRANSACTION_EXECUTE_ERROR.getCode(), ErrorCode.TRANSACTION_EXECUTE_ERROR.getCodeDesc());
            }
        }
    }

    @Override
    public ResponseData<Boolean> isWeIdExist(String weId) {
        try {
            Bool isExist = (Bool)weIdContract.isIdentityExist(new Address(WeIdUtils.convertWeIdToAddress(weId))).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            Boolean result = isExist.getValue();
            return new ResponseData<Boolean>(result, ErrorCode.SUCCESS);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("[isWeIdExist] execute failed. Error message :{}", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
        catch (TimeoutException e) {
            logger.error("[isWeIdExist] execute with timeout. Error message :{}", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (Exception e) {
            logger.error("[isWeIdExist] execute failed. Error message :{}", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<WeIdDocument> getWeIdDocument(String weId) {
        WeIdDocument result = new WeIdDocument();
        result.setId(weId);
        int latestBlockNumber = 0;
        try {
            String identityAddr = WeIdUtils.convertWeIdToAddress(weId);
            latestBlockNumber = ((Uint256)weIdContract.getLatestRelatedBlock(new Address(identityAddr)).get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS)).getValue().intValue();
            if (0 == latestBlockNumber) {
                return new ResponseData<Object>(null, ErrorCode.WEID_DOES_NOT_EXIST);
            }
            WeIdServiceEngineV1.resolveTransaction(weId, latestBlockNumber, result);
            return new ResponseData<WeIdDocument>(result, ErrorCode.SUCCESS);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Set weId service failed. Error message :{}", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
        catch (TimeoutException e) {
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (ResolveAttributeException e) {
            logger.error("[getWeIdDocument]: resolveTransaction failed. weId: {}, errorCode:{}", new Object[]{weId, e.getErrorCode(), e});
            return new ResponseData<Object>(null, ErrorCode.getTypeByErrorCode(e.getErrorCode()));
        }
        catch (Exception e) {
            logger.error("[getWeIdDocument]: exception.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> createWeId(String weAddress, String publicKey, String privateKey) {
        WeIdContract weIdContract = WeIdServiceEngineV1.reloadContract(fiscoConfig.getWeIdAddress(), privateKey, WeIdContract.class);
        try {
            DynamicBytes auth = DataToolUtils.stringToDynamicBytes(new StringBuffer().append(publicKey).append("/").append(weAddress).toString());
            DynamicBytes created = DataToolUtils.stringToDynamicBytes(DateUtils.getNoMillisecondTimeStampString());
            Future future = weIdContract.createWeId(new Address(weAddress), auth, created, DateUtils.getNoMillisecondTimeStampInt256());
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            TransactionInfo info = new TransactionInfo(receipt);
            List response = WeIdContract.getWeIdAttributeChangedEvents((TransactionReceipt)receipt);
            if (CollectionUtils.isEmpty((Collection)response)) {
                logger.error("The input private key does not match the current weid, operation of modifying weid is not allowed. we address is {}", (Object)weAddress);
                return new ResponseData<Boolean>(Boolean.valueOf(false), ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH, info);
            }
            return new ResponseData<Boolean>(Boolean.valueOf(true), ErrorCode.SUCCESS, info);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Set public key failed. Error message :{}", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
        catch (TimeoutException e) {
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
    }

    @Override
    public ResponseData<Boolean> setAttribute(String weAddress, String attributeKey, String value, String privateKey) {
        try {
            WeIdContract weIdContract = WeIdServiceEngineV1.reloadContract(fiscoConfig.getWeIdAddress(), privateKey, WeIdContract.class);
            Future future = weIdContract.setAttribute(new Address(weAddress), DataToolUtils.stringToBytes32(attributeKey), DataToolUtils.stringToDynamicBytes(value), DateUtils.getNoMillisecondTimeStampInt256());
            TransactionReceipt receipt = (TransactionReceipt)future.get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            TransactionInfo info = new TransactionInfo(receipt);
            List response = WeIdContract.getWeIdAttributeChangedEvents((TransactionReceipt)receipt);
            if (CollectionUtils.isNotEmpty((Collection)response)) {
                return new ResponseData<Boolean>(Boolean.valueOf(true), ErrorCode.SUCCESS, info);
            }
            return new ResponseData<Boolean>(Boolean.valueOf(false), ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH, info);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Set public key failed. Error message :{}", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
        catch (TimeoutException e) {
            return new ResponseData<Boolean>(false, ErrorCode.TRANSACTION_TIMEOUT);
        }
    }

    static {
        Event event = new Event("WeIdAttributeChanged", Arrays.asList(new TypeReference<Address>(){}), Arrays.asList(new TypeReference<Bytes32>(){}, new TypeReference<DynamicBytes>(){}, new TypeReference<Uint256>(){}, new TypeReference<Int256>(){}));
        topicMap.put(EventEncoder.encode((Event)event), "WeIdAttributeChanged");
        weIdContract = WeIdServiceEngineV1.getContractService(fiscoConfig.getWeIdAddress(), WeIdContract.class);
    }
}

