/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov2;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.v2.AuthorityIssuerController;
import com.webank.weid.contract.v2.SpecificIssuerController;
import com.webank.weid.protocol.base.AuthorityIssuer;
import com.webank.weid.protocol.request.RegisterAuthorityIssuerArgs;
import com.webank.weid.protocol.request.RemoveAuthorityIssuerArgs;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.AuthorityIssuerServiceEngine;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.WeIdUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.fisco.bcos.web3j.abi.datatypes.Address;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tuples.generated.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorityIssuerEngineV2
extends BaseEngine
implements AuthorityIssuerServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(AuthorityIssuerEngineV2.class);
    private static AuthorityIssuerController authorityIssuerController = AuthorityIssuerEngineV2.getContractService(fiscoConfig.getIssuerAddress(), AuthorityIssuerController.class);
    private static SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV2.getContractService(fiscoConfig.getSpecificIssuerAddress(), SpecificIssuerController.class);

    @Override
    public ResponseData<Boolean> addAuthorityIssuer(RegisterAuthorityIssuerArgs args) {
        AuthorityIssuer authorityIssuer = args.getAuthorityIssuer();
        String weAddress = WeIdUtils.convertWeIdToAddress(authorityIssuer.getWeId());
        ArrayList<byte[]> stringAttributes = new ArrayList<byte[]>();
        stringAttributes.add(authorityIssuer.getName().getBytes());
        ArrayList<BigInteger> longAttributes = new ArrayList<BigInteger>();
        Long createDate = DateUtils.getNoMillisecondTimeStamp();
        longAttributes.add(BigInteger.valueOf(createDate));
        try {
            AuthorityIssuerController authorityIssuerController = AuthorityIssuerEngineV2.reloadContract(fiscoConfig.getIssuerAddress(), args.getWeIdPrivateKey().getPrivateKey(), AuthorityIssuerController.class);
            TransactionReceipt receipt = (TransactionReceipt)authorityIssuerController.addAuthorityIssuer(weAddress, DataToolUtils.bytesArrayListToBytes32ArrayList(stringAttributes, WeIdConstant.AUTHORITY_ISSUER_ARRAY_LEGNTH), DataToolUtils.listToListBigInteger(longAttributes, WeIdConstant.AUTHORITY_ISSUER_ARRAY_LEGNTH), authorityIssuer.getAccValue().getBytes()).send();
            ErrorCode errorCode = this.resolveRegisterAuthorityIssuerEvents(receipt);
            TransactionInfo info = new TransactionInfo(receipt);
            if (errorCode.equals((Object)ErrorCode.SUCCESS)) {
                return new ResponseData<Boolean>(Boolean.TRUE, ErrorCode.SUCCESS, info);
            }
            return new ResponseData<Boolean>(Boolean.FALSE, errorCode, info);
        }
        catch (Exception e) {
            logger.error("register authority issuer failed.", (Throwable)e);
            return new ResponseData<Boolean>(Boolean.FALSE, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    private ErrorCode resolveRegisterAuthorityIssuerEvents(TransactionReceipt transactionReceipt) {
        List eventList = authorityIssuerController.getAuthorityIssuerRetLogEvents(transactionReceipt);
        AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event = (AuthorityIssuerController.AuthorityIssuerRetLogEventResponse)eventList.get(0);
        if (event != null) {
            ErrorCode errorCode = this.verifyAuthorityIssuerRelatedEvent(event, WeIdConstant.ADD_AUTHORITY_ISSUER_OPCODE);
            return errorCode;
        }
        logger.error("register authority issuer failed due to transcation event decoding failure.");
        return ErrorCode.AUTHORITY_ISSUER_ERROR;
    }

    private ErrorCode verifyAuthorityIssuerRelatedEvent(AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event, Integer opcode) {
        if (event.addr == null || event.operation == null || event.retCode == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        Integer eventOpcode = event.operation.intValue();
        if (eventOpcode.equals(opcode)) {
            Integer eventRetCode = event.retCode.intValue();
            return ErrorCode.getTypeByErrorCode(eventRetCode);
        }
        return ErrorCode.AUTHORITY_ISSUER_OPCODE_MISMATCH;
    }

    @Override
    public ResponseData<Boolean> removeAuthorityIssuer(RemoveAuthorityIssuerArgs args) {
        String weId = args.getWeId();
        try {
            AuthorityIssuerController authorityIssuerController = AuthorityIssuerEngineV2.reloadContract(fiscoConfig.getIssuerAddress(), args.getWeIdPrivateKey().getPrivateKey(), AuthorityIssuerController.class);
            TransactionReceipt receipt = (TransactionReceipt)authorityIssuerController.removeAuthorityIssuer(WeIdUtils.convertWeIdToAddress(weId)).send();
            List eventList = authorityIssuerController.getAuthorityIssuerRetLogEvents(receipt);
            TransactionInfo info = new TransactionInfo(receipt);
            AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event = (AuthorityIssuerController.AuthorityIssuerRetLogEventResponse)eventList.get(0);
            if (event != null) {
                ErrorCode errorCode = this.verifyAuthorityIssuerRelatedEvent(event, WeIdConstant.REMOVE_AUTHORITY_ISSUER_OPCODE);
                if (ErrorCode.SUCCESS.getCode() != errorCode.getCode()) {
                    return new ResponseData<Boolean>(Boolean.valueOf(false), errorCode, info);
                }
                return new ResponseData<Boolean>(Boolean.valueOf(true), errorCode, info);
            }
            logger.error("remove authority issuer failed, transcation event decoding failure.");
            return new ResponseData<Boolean>(Boolean.valueOf(false), ErrorCode.AUTHORITY_ISSUER_ERROR, info);
        }
        catch (Exception e) {
            logger.error("remove authority issuer failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> isAuthorityIssuer(String address) {
        ResponseData<Boolean> resultData = new ResponseData<Boolean>();
        try {
            Boolean result = (Boolean)authorityIssuerController.isAuthorityIssuer(address).send();
            resultData.setResult(result);
            if (result.booleanValue()) {
                resultData.setErrorCode(ErrorCode.SUCCESS);
            } else {
                resultData.setErrorCode(ErrorCode.AUTHORITY_ISSUER_CONTRACT_ERROR_NOT_EXISTS);
            }
            return resultData;
        }
        catch (Exception e) {
            logger.error("check authority issuer id failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<AuthorityIssuer> getAuthorityIssuerInfoNonAccValue(String weId) {
        ResponseData<AuthorityIssuer> resultData = new ResponseData<AuthorityIssuer>();
        try {
            Tuple2 rawResult = (Tuple2)authorityIssuerController.getAuthorityIssuerInfoNonAccValue(WeIdUtils.convertWeIdToAddress(weId)).send();
            if (rawResult == null) {
                return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_ERROR);
            }
            List bytes32Attributes = (List)rawResult.getValue1();
            List int256Attributes = (List)rawResult.getValue2();
            AuthorityIssuer result = new AuthorityIssuer();
            result.setWeId(weId);
            String name = DataToolUtils.byte32ListToString(bytes32Attributes, WeIdConstant.AUTHORITY_ISSUER_ARRAY_LEGNTH);
            Long createDate = ((BigInteger)int256Attributes.get(0)).longValue();
            if (StringUtils.isEmpty((CharSequence)name) && createDate.equals(WeIdConstant.LONG_VALUE_ZERO)) {
                return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_CONTRACT_ERROR_NOT_EXISTS);
            }
            result.setName(name);
            result.setCreated(createDate);
            result.setAccValue("");
            resultData.setResult(result);
            return resultData;
        }
        catch (Exception e) {
            logger.error("query authority issuer failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public List<String> getAuthorityIssuerAddressList(Integer index, Integer num) {
        List<String> addressList = new ArrayList<String>();
        try {
            addressList = (List)authorityIssuerController.getAuthorityIssuerAddressList(new BigInteger(index.toString()), new BigInteger(num.toString())).send();
        }
        catch (Exception e) {
            logger.error("query authority issuer failed.", (Throwable)e);
        }
        return addressList;
    }

    @Override
    public ResponseData<Boolean> removeIssuer(String issuerType, String issuerAddress, String privateKey) {
        try {
            SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV2.reloadContract(fiscoConfig.getSpecificIssuerAddress(), privateKey, SpecificIssuerController.class);
            TransactionReceipt receipt = (TransactionReceipt)specificIssuerController.removeIssuer(DataToolUtils.stringToByte32Array(issuerType), issuerAddress).send();
            ErrorCode errorCode = this.resolveSpecificIssuerEvents(receipt, false, issuerAddress);
            TransactionInfo info = new TransactionInfo(receipt);
            return new ResponseData<Boolean>(Boolean.valueOf(errorCode.getCode() == ErrorCode.SUCCESS.getCode()), errorCode, info);
        }
        catch (Exception e) {
            logger.error("remove issuer from type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    private ErrorCode resolveSpecificIssuerEvents(TransactionReceipt transactionReceipt, boolean isRegister, String address) {
        List eventList = specificIssuerController.getSpecificIssuerRetLogEvents(transactionReceipt);
        SpecificIssuerController.SpecificIssuerRetLogEventResponse event = (SpecificIssuerController.SpecificIssuerRetLogEventResponse)eventList.get(0);
        if (event != null) {
            if (isRegister ? event.operation.intValue() != WeIdConstant.ADD_AUTHORITY_ISSUER_OPCODE.intValue() || !StringUtils.equalsIgnoreCase((CharSequence)event.addr.toString(), (CharSequence)address) : event.operation.intValue() != WeIdConstant.REMOVE_AUTHORITY_ISSUER_OPCODE.intValue() || !StringUtils.equalsIgnoreCase((CharSequence)event.addr.toString(), (CharSequence)address)) {
                return ErrorCode.TRANSACTION_EXECUTE_ERROR;
            }
            Integer eventRetCode = event.retCode.intValue();
            return ErrorCode.getTypeByErrorCode(eventRetCode);
        }
        logger.error("specific issuer type resolution failed due to event decoding failure.");
        return ErrorCode.UNKNOW_ERROR;
    }

    @Override
    public ResponseData<Boolean> isSpecificTypeIssuer(String issuerType, String address) {
        try {
            Boolean result = (Boolean)specificIssuerController.isSpecificTypeIssuer(DataToolUtils.stringToByte32Array(issuerType), address).send();
            if (!result.booleanValue()) {
                return new ResponseData<Boolean>(result, ErrorCode.SPECIFIC_ISSUER_CONTRACT_ERROR_ALREADY_NOT_EXIST);
            }
            return new ResponseData<Boolean>(result, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("check issuer type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<List<String>> getSpecificTypeIssuerList(String issuerType, Integer index, Integer num) {
        List addresses = new ArrayList();
        try {
            addresses = (List)specificIssuerController.getSpecificTypeIssuerList(DataToolUtils.stringToByte32Array(issuerType), new BigInteger(index.toString()), new BigInteger(num.toString())).send();
            ArrayList<String> addressList = new ArrayList<String>();
            for (String addr : addresses) {
                if (WeIdUtils.isEmptyStringAddress(addr)) continue;
                addressList.add(addr);
            }
            return new ResponseData<List<String>>(addressList, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("check issuer type failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> registerIssuerType(String issuerType, String privateKey) {
        try {
            SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV2.reloadContract(fiscoConfig.getSpecificIssuerAddress(), privateKey, SpecificIssuerController.class);
            TransactionReceipt receipt = (TransactionReceipt)specificIssuerController.registerIssuerType(DataToolUtils.stringToByte32Array(issuerType)).send();
            String emptyAddress = new Address(BigInteger.ZERO).toString();
            ErrorCode errorCode = this.resolveSpecificIssuerEvents(receipt, true, emptyAddress);
            TransactionInfo info = new TransactionInfo(receipt);
            return new ResponseData<Boolean>(Boolean.valueOf(errorCode.getCode() == ErrorCode.SUCCESS.getCode()), errorCode, info);
        }
        catch (Exception e) {
            logger.error("register issuer type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> addIssuer(String issuerType, String issuerAddress, String privateKey) {
        try {
            SpecificIssuerController specificIssuerController = AuthorityIssuerEngineV2.reloadContract(fiscoConfig.getSpecificIssuerAddress(), privateKey, SpecificIssuerController.class);
            TransactionReceipt receipt = (TransactionReceipt)specificIssuerController.addIssuer(DataToolUtils.stringToByte32Array(issuerType), issuerAddress).send();
            ErrorCode errorCode = this.resolveSpecificIssuerEvents(receipt, true, issuerAddress);
            TransactionInfo info = new TransactionInfo(receipt);
            return new ResponseData<Boolean>(Boolean.valueOf(errorCode.getCode() == ErrorCode.SUCCESS.getCode()), errorCode, info);
        }
        catch (Exception e) {
            logger.error("add issuer into type failed.", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.AUTHORITY_ISSUER_ERROR);
        }
    }
}

