/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov2;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.v2.CptController;
import com.webank.weid.protocol.base.Cpt;
import com.webank.weid.protocol.base.CptBaseInfo;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.RsvSignature;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.service.impl.engine.CptServiceEngine;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.TransactionUtils;
import com.webank.weid.util.WeIdUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.bcos.web3j.crypto.Sign;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tuples.generated.Tuple7;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CptServiceEngineV2
extends BaseEngine
implements CptServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(CptServiceEngineV2.class);
    private static CptController cptController;

    @Override
    public ResponseData<CptBaseInfo> updateCpt(int cptId, String address, String cptJsonSchemaNew, RsvSignature rsvSignature, String privateKey) {
        ArrayList<byte[]> byteArray = new ArrayList<byte[]>();
        try {
            CptController cptController = CptServiceEngineV2.reloadContract(fiscoConfig.getCptAddress(), privateKey, CptController.class);
            TransactionReceipt transactionReceipt = (TransactionReceipt)cptController.updateCpt(BigInteger.valueOf(cptId), address, DataToolUtils.listToListBigInteger(DataToolUtils.getParamCreatedList(WeIdConstant.CPT_LONG_ARRAY_LENGTH), WeIdConstant.CPT_LONG_ARRAY_LENGTH), DataToolUtils.bytesArrayListToBytes32ArrayList(byteArray, WeIdConstant.CPT_STRING_ARRAY_LENGTH), DataToolUtils.stringToByte32ArrayList(cptJsonSchemaNew, WeIdConstant.JSON_SCHEMA_ARRAY_LENGTH), rsvSignature.getV().getValue(), rsvSignature.getR().getValue(), rsvSignature.getS().getValue()).send();
            return this.processUpdateEventLog(cptController, transactionReceipt);
        }
        catch (Exception e) {
            logger.error("[updateCpt] cptId limited max value. cptId:{}", (Object)cptId);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> registerCpt(int cptId, String address, String cptJsonSchemaNew, RsvSignature rsvSignature, String privateKey) {
        ArrayList<byte[]> byteArray = new ArrayList<byte[]>();
        try {
            CptController cptController = CptServiceEngineV2.reloadContract(fiscoConfig.getCptAddress(), privateKey, CptController.class);
            TransactionReceipt transactionReceipt = (TransactionReceipt)cptController.registerCpt(BigInteger.valueOf(cptId), address, DataToolUtils.listToListBigInteger(DataToolUtils.getParamCreatedList(WeIdConstant.CPT_LONG_ARRAY_LENGTH), WeIdConstant.CPT_LONG_ARRAY_LENGTH), DataToolUtils.bytesArrayListToBytes32ArrayList(byteArray, WeIdConstant.CPT_STRING_ARRAY_LENGTH), DataToolUtils.stringToByte32ArrayList(cptJsonSchemaNew, WeIdConstant.JSON_SCHEMA_ARRAY_LENGTH), rsvSignature.getV().getValue(), rsvSignature.getR().getValue(), rsvSignature.getS().getValue()).send();
            return this.processRegisterEventLog(cptController, transactionReceipt);
        }
        catch (Exception e) {
            logger.error("[registerCpt] register cpt failed. exception message: ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<CptBaseInfo> registerCpt(String address, String cptJsonSchemaNew, RsvSignature rsvSignature, String privateKey) {
        ArrayList<byte[]> byteArray = new ArrayList<byte[]>();
        try {
            CptController cptController = CptServiceEngineV2.reloadContract(fiscoConfig.getCptAddress(), privateKey, CptController.class);
            TransactionReceipt transactionReceipt = (TransactionReceipt)cptController.registerCpt(address, DataToolUtils.listToListBigInteger(DataToolUtils.getParamCreatedList(WeIdConstant.CPT_LONG_ARRAY_LENGTH), WeIdConstant.CPT_LONG_ARRAY_LENGTH), DataToolUtils.bytesArrayListToBytes32ArrayList(byteArray, WeIdConstant.CPT_STRING_ARRAY_LENGTH), DataToolUtils.stringToByte32ArrayList(cptJsonSchemaNew, WeIdConstant.JSON_SCHEMA_ARRAY_LENGTH), rsvSignature.getV().getValue(), rsvSignature.getR().getValue(), rsvSignature.getS().getValue()).send();
            return this.processRegisterEventLog(cptController, transactionReceipt);
        }
        catch (Exception e) {
            logger.error("[registerCpt] register cpt failed. exception message: ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    private ResponseData<CptBaseInfo> processUpdateEventLog(CptController cptController, TransactionReceipt transactionReceipt) {
        List event = cptController.getUpdateCptRetLogEvents(transactionReceipt);
        if (CollectionUtils.isEmpty((Collection)event)) {
            return new ResponseData<Object>(null, ErrorCode.CPT_EVENT_LOG_NULL);
        }
        return TransactionUtils.getResultByResolveEvent(((CptController.UpdateCptRetLogEventResponse)event.get((int)0)).retCode, ((CptController.UpdateCptRetLogEventResponse)event.get((int)0)).cptId, ((CptController.UpdateCptRetLogEventResponse)event.get((int)0)).cptVersion, transactionReceipt);
    }

    private ResponseData<CptBaseInfo> processRegisterEventLog(CptController cptController, TransactionReceipt transactionReceipt) {
        List event = cptController.getRegisterCptRetLogEvents(transactionReceipt);
        if (CollectionUtils.isEmpty((Collection)event)) {
            return new ResponseData<Object>(null, ErrorCode.CPT_EVENT_LOG_NULL);
        }
        return TransactionUtils.getResultByResolveEvent(((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).retCode, ((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).cptId, ((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).cptVersion, transactionReceipt);
    }

    @Override
    public ResponseData<Cpt> queryCpt(int cptId) {
        try {
            Tuple7 valueList = (Tuple7)cptController.queryCpt(new BigInteger(String.valueOf(cptId))).sendAsync().get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
            if (valueList == null) {
                logger.error("Query cpt id : {} does not exist, result is null.", (Object)cptId);
                return new ResponseData<Object>(null, ErrorCode.CPT_NOT_EXISTS);
            }
            if ("0x0000000000000000000000000000000000000000".equals(valueList.getValue1())) {
                logger.error("Query cpt id : {} does not exist.", (Object)cptId);
                return new ResponseData<Object>(null, ErrorCode.CPT_NOT_EXISTS);
            }
            Cpt cpt = new Cpt();
            cpt.setCptId(cptId);
            cpt.setCptPublisher(WeIdUtils.convertAddressToWeId((String)valueList.getValue1()));
            List longArray = (List)valueList.getValue2();
            cpt.setCptVersion(((BigInteger)longArray.get(0)).intValue());
            cpt.setCreated(((BigInteger)longArray.get(1)).longValue());
            cpt.setUpdated(((BigInteger)longArray.get(2)).longValue());
            List jsonSchemaArray = (List)valueList.getValue4();
            String jsonSchema = DataToolUtils.byte32ListToString(jsonSchemaArray, WeIdConstant.JSON_SCHEMA_ARRAY_LENGTH);
            Map jsonSchemaMap = DataToolUtils.deserialize(jsonSchema.trim(), HashMap.class);
            cpt.setCptJsonSchema(jsonSchemaMap);
            int v = ((BigInteger)valueList.getValue5()).intValue();
            byte[] r = (byte[])valueList.getValue6();
            byte[] s = (byte[])valueList.getValue7();
            Sign.SignatureData signatureData = DataToolUtils.rawSignatureDeserialization(v, r, s);
            String cptSignature = new String(DataToolUtils.base64Encode(DataToolUtils.simpleSignatureSerialization(signatureData)), StandardCharsets.UTF_8);
            cpt.setCptSignature(cptSignature);
            ResponseData<Cpt> responseData = new ResponseData<Cpt>(cpt, ErrorCode.SUCCESS);
            return responseData;
        }
        catch (Exception e) {
            logger.error("[queryCpt] query Cpt failed. exception message: ", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    static {
        if (cptController == null) {
            cptController = CptServiceEngineV2.getContractService(fiscoConfig.getCptAddress(), CptController.class);
        }
    }
}

