/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov2;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.contract.v2.Evidence;
import com.webank.weid.contract.v2.EvidenceFactory;
import com.webank.weid.protocol.base.EvidenceInfo;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.service.impl.engine.EvidenceServiceEngine;
import com.webank.weid.util.DataToolUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.bcos.web3j.crypto.Sign;
import org.fisco.bcos.web3j.crypto.ECKeyPair;
import org.fisco.bcos.web3j.crypto.Keys;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tuples.generated.Tuple6;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvidenceServiceEngineV2
extends BaseEngine
implements EvidenceServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(EvidenceServiceEngineV2.class);

    @Override
    public ResponseData<String> createEvidence(Sign.SignatureData sigData, List<String> hashAttributes, List<String> extraValueList, String privateKey) {
        try {
            ArrayList<byte[]> hashAttributesByte = new ArrayList<byte[]>();
            for (String string : hashAttributes) {
                hashAttributesByte.add(DataToolUtils.stringToByte32Array(string));
            }
            ArrayList<byte[]> extraValueListByte = new ArrayList<byte[]>();
            for (String extraValue : extraValueList) {
                extraValueListByte.add(DataToolUtils.stringToByte32Array(extraValue));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            ECKeyPair keyPair = ECKeyPair.create((BigInteger)new BigInteger(privateKey));
            arrayList.add(Keys.getAddress((ECKeyPair)keyPair));
            EvidenceFactory evidenceFactory = EvidenceServiceEngineV2.reloadContract(fiscoConfig.getEvidenceAddress(), privateKey, EvidenceFactory.class);
            TransactionReceipt receipt = (TransactionReceipt)evidenceFactory.createEvidence(hashAttributesByte, arrayList, sigData.getR(), sigData.getS(), BigInteger.valueOf(sigData.getV()), extraValueListByte).send();
            TransactionInfo info = new TransactionInfo(receipt);
            List eventResponseList = evidenceFactory.getCreateEvidenceLogEvents(receipt);
            EvidenceFactory.CreateEvidenceLogEventResponse event = (EvidenceFactory.CreateEvidenceLogEventResponse)eventResponseList.get(0);
            if (event != null) {
                ErrorCode innerResponse = this.verifyCreateEvidenceEvent(event.retCode.intValue(), event.addr);
                if (ErrorCode.SUCCESS.getCode() != innerResponse.getCode()) {
                    return new ResponseData<String>("", innerResponse, info);
                }
                return new ResponseData<String>(event.addr.toString(), ErrorCode.SUCCESS, info);
            }
            logger.error("create evidence failed due to transcation event decoding failure.");
            return new ResponseData<String>("", ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR, info);
        }
        catch (Exception e) {
            logger.error("create evidence failed due to system error. ", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
        }
    }

    @Override
    public ResponseData<EvidenceInfo> getInfo(String evidenceAddress) {
        try {
            Evidence evidence = EvidenceServiceEngineV2.getContractService(evidenceAddress, Evidence.class);
            Tuple6 rawResult = (Tuple6)evidence.getInfo().send();
            if (rawResult == null) {
                return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
            }
            List credentialHashList = (List)rawResult.getValue1();
            List issuerList = (List)rawResult.getValue2();
            EvidenceInfo evidenceInfoData = new EvidenceInfo();
            evidenceInfoData.setCredentialHash("0x" + new String((byte[])credentialHashList.get(0)) + new String((byte[])credentialHashList.get(1)));
            ArrayList<String> signerStringList = new ArrayList<String>();
            for (String addr : issuerList) {
                signerStringList.add(addr);
            }
            evidenceInfoData.setSigners(signerStringList);
            ArrayList<String> signaturesList = new ArrayList<String>();
            List rlist = (List)rawResult.getValue3();
            List slist = (List)rawResult.getValue4();
            List vlist = (List)rawResult.getValue5();
            for (int index = 0; index < rlist.size(); ++index) {
                byte v = (byte)((BigInteger)vlist.get(index)).intValue();
                byte[] r = (byte[])rlist.get(index);
                byte[] s = (byte[])slist.get(index);
                Sign.SignatureData sigData = new Sign.SignatureData(v, r, s);
                signaturesList.add(new String(DataToolUtils.base64Encode(DataToolUtils.simpleSignatureSerialization(sigData)), StandardCharsets.UTF_8));
            }
            evidenceInfoData.setSignatures(signaturesList);
            return new ResponseData<EvidenceInfo>(evidenceInfoData, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("get evidence failed.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.CREDENTIAL_EVIDENCE_BASE_ERROR);
        }
    }
}

