/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov2;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.contract.v2.AuthorityIssuerController;
import com.webank.weid.contract.v2.CptController;
import com.webank.weid.contract.v2.WeIdContract;
import com.webank.weid.protocol.base.CptBaseInfo;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.service.impl.engine.RawTransactionServiceEngine;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.TransactionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosTransactionReceipt;
import org.fisco.bcos.web3j.protocol.core.methods.response.SendTransaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.protocol.exceptions.TransactionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawTransactionServiceEngineV2
extends BaseEngine
implements RawTransactionServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(RawTransactionServiceEngineV2.class);
    private static WeIdContract weIdContract = RawTransactionServiceEngineV2.getContractService(fiscoConfig.getWeIdAddress(), WeIdContract.class);
    private static AuthorityIssuerController authorityIssuerController = RawTransactionServiceEngineV2.getContractService(fiscoConfig.getIssuerAddress(), AuthorityIssuerController.class);
    private static CptController cptController = RawTransactionServiceEngineV2.getContractService(fiscoConfig.getCptAddress(), CptController.class);

    public static TransactionReceipt sendTransaction(String transactionHex) throws Exception {
        Web3j web3j = (Web3j)RawTransactionServiceEngineV2.getWeb3j();
        SendTransaction ethSendTransaction = (SendTransaction)web3j.sendRawTransaction(transactionHex).sendAsync().get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
        if (ethSendTransaction.hasError()) {
            logger.error("Error processing transaction request: " + ethSendTransaction.getError().getMessage());
            return null;
        }
        Optional<TransactionReceipt> receiptOptional = RawTransactionServiceEngineV2.getTransactionReceiptRequest(web3j, ethSendTransaction.getTransactionHash());
        int sumTime = 0;
        try {
            for (int i = 0; i < WeIdConstant.POLL_TRANSACTION_ATTEMPTS; ++i) {
                if (!receiptOptional.isPresent()) {
                    Thread.sleep(WeIdConstant.POLL_TRANSACTION_SLEEP_DURATION.intValue());
                    sumTime += WeIdConstant.POLL_TRANSACTION_SLEEP_DURATION.intValue();
                } else {
                    return receiptOptional.get();
                }
                receiptOptional = RawTransactionServiceEngineV2.getTransactionReceiptRequest(web3j, ethSendTransaction.getTransactionHash());
            }
        }
        catch (Exception e) {
            throw new TransactionTimeoutException("Transaction receipt was not generated after " + sumTime / 1000 + " seconds for transaction: " + ethSendTransaction);
        }
        return null;
    }

    private static Optional<TransactionReceipt> getTransactionReceiptRequest(Web3j web3j, String transactionHash) throws Exception {
        BcosTransactionReceipt transactionReceipt = (BcosTransactionReceipt)web3j.getTransactionReceipt(transactionHash).send();
        if (transactionReceipt.hasError()) {
            logger.error("Error processing transaction request: " + transactionReceipt.getError().getMessage());
            return Optional.empty();
        }
        return transactionReceipt.getTransactionReceipt();
    }

    public static ErrorCode verifyAuthorityIssuerRelatedEvent(AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event, Integer opcode) {
        if (event == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (event.addr == null || event.operation == null || event.retCode == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        Integer eventOpcode = event.operation.intValue();
        if (eventOpcode.equals(opcode)) {
            Integer eventRetCode = event.retCode.intValue();
            return ErrorCode.getTypeByErrorCode(eventRetCode);
        }
        return ErrorCode.AUTHORITY_ISSUER_OPCODE_MISMATCH;
    }

    public static ResponseData<CptBaseInfo> resolveRegisterCptEvents(TransactionReceipt transactionReceipt, CptController cptController) {
        List event = cptController.getRegisterCptRetLogEvents(transactionReceipt);
        if (CollectionUtils.isEmpty((Collection)event)) {
            logger.error("[registerCpt] event is empty");
            return new ResponseData<Object>(null, ErrorCode.CPT_EVENT_LOG_NULL);
        }
        return TransactionUtils.getResultByResolveEvent(((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).retCode, ((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).cptId, ((CptController.RegisterCptRetLogEventResponse)event.get((int)0)).cptVersion, transactionReceipt);
    }

    @Override
    public ResponseData<String> createWeId(String transactionHex) {
        try {
            TransactionReceipt transactionReceipt = RawTransactionServiceEngineV2.sendTransaction(transactionHex);
            List response = weIdContract.getWeIdAttributeChangedEvents(transactionReceipt);
            TransactionInfo info = new TransactionInfo(transactionReceipt);
            if (!CollectionUtils.isEmpty((Collection)response)) {
                return new ResponseData<String>(Boolean.TRUE.toString(), ErrorCode.SUCCESS, info);
            }
        }
        catch (Exception e) {
            logger.error("[createWeId] create failed due to unknown transaction error. ", (Throwable)e);
        }
        return new ResponseData<String>("", ErrorCode.TRANSACTION_EXECUTE_ERROR);
    }

    @Override
    public ResponseData<String> registerAuthorityIssuer(String transactionHex) {
        try {
            TransactionReceipt transactionReceipt = RawTransactionServiceEngineV2.sendTransaction(transactionHex);
            List eventList = authorityIssuerController.getAuthorityIssuerRetLogEvents(transactionReceipt);
            AuthorityIssuerController.AuthorityIssuerRetLogEventResponse event = (AuthorityIssuerController.AuthorityIssuerRetLogEventResponse)eventList.get(0);
            TransactionInfo info = new TransactionInfo(transactionReceipt);
            ErrorCode errorCode = RawTransactionServiceEngineV2.verifyAuthorityIssuerRelatedEvent(event, WeIdConstant.ADD_AUTHORITY_ISSUER_OPCODE);
            Boolean result = errorCode.getCode() == ErrorCode.SUCCESS.getCode();
            return new ResponseData<String>(result.toString(), errorCode, info);
        }
        catch (Exception e) {
            logger.error("[registerAuthorityIssuer] register failed due to transaction error.", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
    }

    @Override
    public ResponseData<String> registerCpt(String transactionHex) {
        try {
            TransactionReceipt transactionReceipt = RawTransactionServiceEngineV2.sendTransaction(transactionHex);
            CptBaseInfo cptBaseInfo = RawTransactionServiceEngineV2.resolveRegisterCptEvents(transactionReceipt, cptController).getResult();
            TransactionInfo info = new TransactionInfo(transactionReceipt);
            if (cptBaseInfo != null) {
                return new ResponseData<String>(DataToolUtils.objToJsonStrWithNoPretty(cptBaseInfo), ErrorCode.SUCCESS, info);
            }
        }
        catch (Exception e) {
            logger.error("[registerCpt] register failed due to unknown transaction error. ", (Throwable)e);
        }
        return new ResponseData<String>("", ErrorCode.TRANSACTION_EXECUTE_ERROR);
    }
}

