/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.service.impl.engine.fiscov2;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.ResolveEventLogStatus;
import com.webank.weid.contract.v2.WeIdContract;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.exception.ResolveAttributeException;
import com.webank.weid.protocol.base.AuthenticationProperty;
import com.webank.weid.protocol.base.PublicKeyProperty;
import com.webank.weid.protocol.base.ServiceProperty;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.response.ResolveEventLogResult;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.impl.engine.BaseEngine;
import com.webank.weid.service.impl.engine.WeIdServiceEngine;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.WeIdUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.fisco.bcos.web3j.abi.EventEncoder;
import org.fisco.bcos.web3j.abi.datatypes.Event;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameterNumber;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosBlock;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosTransactionReceipt;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.Transaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeIdServiceEngineV2
extends BaseEngine
implements WeIdServiceEngine {
    private static final Logger logger = LoggerFactory.getLogger(WeIdServiceEngineV2.class);
    private static final HashMap<String, String> topicMap = new HashMap();
    private static final int STOP_RESOLVE_BLOCK_NUMBER = 0;
    private static WeIdContract weIdContract;

    private static ResolveEventLogResult resolveAttributeEvent(String weId, TransactionReceipt receipt, WeIdDocument result) {
        List eventlog = weIdContract.getWeIdAttributeChangedEvents(receipt);
        ResolveEventLogResult response = new ResolveEventLogResult();
        if (CollectionUtils.isEmpty((Collection)eventlog)) {
            response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_EVENTLOG_NULL);
            return response;
        }
        int previousBlock = 0;
        for (WeIdContract.WeIdAttributeChangedEventResponse res : eventlog) {
            String weAddress;
            if (res.identity == null || res.updated == null || res.previousBlock == null) {
                response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_RES_NULL);
                return response;
            }
            String identity = res.identity.toString();
            if (result.getUpdated() == null) {
                long timeStamp = res.updated.longValue();
                result.setUpdated(timeStamp);
            }
            if (!StringUtils.equals((CharSequence)(weAddress = WeIdUtils.convertWeIdToAddress(weId)), (CharSequence)identity)) {
                response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_WEID_NOT_MATCH);
                return response;
            }
            String key = new String(res.key);
            String value = new String(res.value);
            previousBlock = res.previousBlock.intValue();
            WeIdServiceEngineV2.buildupWeIdAttribute(key, value, weId, result);
        }
        response.setPreviousBlock(previousBlock);
        response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_SUCCESS);
        return response;
    }

    private static void buildupWeIdAttribute(String key, String value, String weId, WeIdDocument result) {
        if (StringUtils.startsWith((CharSequence)key, (CharSequence)"/weId/pubkey")) {
            WeIdServiceEngineV2.buildWeIdPublicKeys(value, weId, result);
        } else if (StringUtils.startsWith((CharSequence)key, (CharSequence)"/weId/auth")) {
            WeIdServiceEngineV2.buildWeIdPublicKeys(value, weId, result);
            WeIdServiceEngineV2.buildWeIdAuthentication(value, weId, result);
        } else if (StringUtils.startsWith((CharSequence)key, (CharSequence)"/weId/service")) {
            WeIdServiceEngineV2.buildWeIdService(key, value, weId, result);
        } else {
            WeIdServiceEngineV2.buildWeIdAttributeDefault(key, value, weId, result);
        }
    }

    private static void buildWeIdPublicKeys(String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdPublicKeys() parameter::value:{}, weId:{}, result:{}", new Object[]{value, weId, result});
        List<PublicKeyProperty> pubkeyList = result.getPublicKey();
        for (PublicKeyProperty pr : pubkeyList) {
            if (!StringUtils.contains((CharSequence)value, (CharSequence)pr.getPublicKey())) continue;
            return;
        }
        PublicKeyProperty pubKey = new PublicKeyProperty();
        pubKey.setId(new StringBuffer().append(weId).append("#keys-").append(result.getPublicKey().size()).toString());
        String[] publicKeyData = StringUtils.splitByWholeSeparator((String)value, (String)"/");
        if (publicKeyData != null && publicKeyData.length == 2) {
            pubKey.setPublicKey(publicKeyData[0]);
            String weAddress = publicKeyData[1];
            String owner = WeIdUtils.convertAddressToWeId(weAddress);
            pubKey.setOwner(owner);
        }
        result.getPublicKey().add(pubKey);
    }

    private static void buildWeIdAuthentication(String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdAuthentication() parameter::value:{}, weId:{}, result:{}", new Object[]{value, weId, result});
        AuthenticationProperty auth = new AuthenticationProperty();
        List<PublicKeyProperty> keys = result.getPublicKey();
        List<AuthenticationProperty> authList = result.getAuthentication();
        for (PublicKeyProperty r : keys) {
            if (!StringUtils.contains((CharSequence)value, (CharSequence)r.getPublicKey())) continue;
            for (AuthenticationProperty ar : authList) {
                if (!StringUtils.equals((CharSequence)ar.getPublicKey(), (CharSequence)r.getId())) continue;
                return;
            }
            auth.setPublicKey(r.getId());
            result.getAuthentication().add(auth);
        }
    }

    private static void buildWeIdService(String key, String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdService() parameter::key{}, value:{}, weId:{}, result:{}", new Object[]{key, value, weId, result});
        String service = StringUtils.splitByWholeSeparator((String)key, (String)"/")[2];
        List<ServiceProperty> serviceList = result.getService();
        for (ServiceProperty sr : serviceList) {
            if (!StringUtils.equals((CharSequence)service, (CharSequence)sr.getType())) continue;
            return;
        }
        ServiceProperty serviceResult = new ServiceProperty();
        serviceResult.setType(service);
        serviceResult.setServiceEndpoint(value);
        result.getService().add(serviceResult);
    }

    private static void buildWeIdAttributeDefault(String key, String value, String weId, WeIdDocument result) {
        logger.info("method buildWeIdAttributeDefault() parameter::key{}, value:{}, weId:{}, result:{}", new Object[]{key, value, weId, result});
        switch (key) {
            case "created": {
                result.setCreated(Long.valueOf(value));
                break;
            }
        }
    }

    private static ResolveEventLogResult resolveEventLog(String weId, Log log, TransactionReceipt receipt, WeIdDocument result) {
        String topic = (String)log.getTopics().get(0);
        String event = topicMap.get(topic);
        if (StringUtils.isNotBlank((CharSequence)event)) {
            switch (event) {
                case "WeIdAttributeChanged": {
                    return WeIdServiceEngineV2.resolveAttributeEvent(weId, receipt, result);
                }
            }
        }
        ResolveEventLogResult response = new ResolveEventLogResult();
        response.setResolveEventLogStatus(ResolveEventLogStatus.STATUS_EVENT_NULL);
        return response;
    }

    private static void resolveTransaction(String weId, int blockNumber, WeIdDocument result) {
        int previousBlock = blockNumber;
        while (previousBlock != 0) {
            int currentBlockNumber = previousBlock;
            BcosBlock latestBlock = null;
            try {
                latestBlock = (BcosBlock)((Web3j)WeIdServiceEngineV2.getWeb3j()).getBlockByNumber((DefaultBlockParameter)new DefaultBlockParameterNumber((long)currentBlockNumber), true).send();
            }
            catch (IOException e) {
                logger.error("[resolveTransaction]:get block by number :{} failed. Exception message:{}", (Object)currentBlockNumber, (Object)e);
            }
            if (latestBlock == null) {
                logger.info("[resolveTransaction]:get block by number :{} . latestBlock is null", (Object)currentBlockNumber);
                return;
            }
            List transList = latestBlock.getBlock().getTransactions().stream().map(transactionResult -> (Transaction)transactionResult.get()).collect(Collectors.toList());
            previousBlock = 0;
            try {
                for (Transaction transaction : transList) {
                    String transHash = transaction.getHash();
                    BcosTransactionReceipt rec1 = (BcosTransactionReceipt)((Web3j)WeIdServiceEngineV2.getWeb3j()).getTransactionReceipt(transHash).send();
                    TransactionReceipt receipt = (TransactionReceipt)rec1.getTransactionReceipt().get();
                    List logs = ((TransactionReceipt)rec1.getResult()).getLogs();
                    for (Log log : logs) {
                        ResolveEventLogResult returnValue = WeIdServiceEngineV2.resolveEventLog(weId, log, receipt, result);
                        if (!returnValue.getResultStatus().equals((Object)ResolveEventLogStatus.STATUS_SUCCESS) || returnValue.getPreviousBlock() == currentBlockNumber) continue;
                        previousBlock = returnValue.getPreviousBlock();
                    }
                }
            }
            catch (DataTypeCastException | IOException e) {
                logger.error("[resolveTransaction]: get TransactionReceipt by weId :{} failed.", (Object)weId, (Object)e);
                throw new ResolveAttributeException(ErrorCode.TRANSACTION_EXECUTE_ERROR.getCode(), ErrorCode.TRANSACTION_EXECUTE_ERROR.getCodeDesc());
            }
        }
    }

    @Override
    public ResponseData<Boolean> isWeIdExist(String weId) {
        try {
            boolean isExist = (Boolean)weIdContract.isIdentityExist(WeIdUtils.convertWeIdToAddress(weId)).send();
            return new ResponseData<Boolean>(isExist, ErrorCode.SUCCESS);
        }
        catch (Exception e) {
            logger.error("[isWeIdExist] execute failed. Error message :{}", (Throwable)e);
            return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<WeIdDocument> getWeIdDocument(String weId) {
        WeIdDocument result = new WeIdDocument();
        result.setId(weId);
        int latestBlockNumber = 0;
        try {
            String identityAddr = WeIdUtils.convertWeIdToAddress(weId);
            latestBlockNumber = ((BigInteger)weIdContract.getLatestRelatedBlock(identityAddr).send()).intValue();
            if (0 == latestBlockNumber) {
                return new ResponseData<Object>(null, ErrorCode.WEID_DOES_NOT_EXIST);
            }
            WeIdServiceEngineV2.resolveTransaction(weId, latestBlockNumber, result);
            return new ResponseData<WeIdDocument>(result, ErrorCode.SUCCESS);
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Set weId service failed. Error message :{}", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_EXECUTE_ERROR);
        }
        catch (TimeoutException e) {
            return new ResponseData<Object>(null, ErrorCode.TRANSACTION_TIMEOUT);
        }
        catch (ResolveAttributeException e) {
            logger.error("[getWeIdDocument]: resolveTransaction failed. weId: {}, errorCode:{}", new Object[]{weId, e.getErrorCode(), e});
            return new ResponseData<WeIdDocument>(result, ErrorCode.getTypeByErrorCode(e.getErrorCode()));
        }
        catch (Exception e) {
            logger.error("[getWeIdDocument]: exception.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public ResponseData<Boolean> createWeId(String weAddress, String publicKey, String privateKey) {
        String auth = new StringBuffer().append(publicKey).append("/").append(weAddress).toString();
        String created = DateUtils.getNoMillisecondTimeStampString();
        WeIdContract weIdContract = WeIdServiceEngineV2.reloadContract(fiscoConfig.getWeIdAddress(), privateKey, WeIdContract.class);
        try {
            TransactionReceipt receipt = (TransactionReceipt)weIdContract.createWeId(weAddress, DataToolUtils.stringToByteArray(auth), DataToolUtils.stringToByteArray(created), BigInteger.valueOf(DateUtils.getNoMillisecondTimeStamp())).send();
            TransactionInfo info = new TransactionInfo(receipt);
            List response = weIdContract.getWeIdAttributeChangedEvents(receipt);
            if (CollectionUtils.isEmpty((Collection)response)) {
                logger.error("The input private key does not match the current weid, operation of modifying weid is not allowed. we address is {}", (Object)weAddress);
                return new ResponseData<Boolean>(Boolean.valueOf(false), ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH, info);
            }
            return new ResponseData<Boolean>(Boolean.valueOf(true), ErrorCode.SUCCESS, info);
        }
        catch (Exception e) {
            return new ResponseData<Boolean>(false, ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH);
        }
    }

    @Override
    public ResponseData<Boolean> setAttribute(String weAddress, String attributeKey, String value, String privateKey) {
        try {
            WeIdContract weIdContract = WeIdServiceEngineV2.reloadContract(fiscoConfig.getWeIdAddress(), privateKey, WeIdContract.class);
            byte[] attrValue = value.getBytes();
            BigInteger updated = BigInteger.valueOf(DateUtils.getNoMillisecondTimeStamp());
            TransactionReceipt transactionReceipt = (TransactionReceipt)weIdContract.setAttribute(weAddress, DataToolUtils.stringToByte32Array(attributeKey), attrValue, updated).send();
            TransactionInfo info = new TransactionInfo(transactionReceipt);
            List response = weIdContract.getWeIdAttributeChangedEvents(transactionReceipt);
            if (CollectionUtils.isNotEmpty((Collection)response)) {
                return new ResponseData<Boolean>(Boolean.valueOf(true), ErrorCode.SUCCESS, info);
            }
            return new ResponseData<Boolean>(Boolean.valueOf(false), ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH, info);
        }
        catch (Exception e) {
            return new ResponseData<Boolean>(false, ErrorCode.UNKNOW_ERROR);
        }
    }

    static {
        topicMap.put(EventEncoder.encode((Event)WeIdContract.WEIDATTRIBUTECHANGED_EVENT), "WeIdAttributeChanged");
        weIdContract = WeIdServiceEngineV2.getContractService(fiscoConfig.getWeIdAddress(), WeIdContract.class);
    }
}

