/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.crypto;

import com.webank.weid.exception.EncodeSuiteException;
import com.webank.weid.suite.crypto.CryptService;
import com.webank.weid.suite.encode.CipherEncodeProcessor;
import com.webank.weid.suite.entity.CryptType;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesCryptService
implements CryptService {
    private static final Logger logger = LoggerFactory.getLogger(CipherEncodeProcessor.class);
    private static final String KEY_ALGORITHM = CryptType.AES.name();
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final int KEY_LEN = 128;

    @Override
    public String encrypt(String content, String password) throws EncodeSuiteException {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            byte[] byteContent = content.getBytes(StandardCharsets.UTF_8.toString());
            cipher.init(1, AesCryptService.getSecretKey(password));
            byte[] result = cipher.doFinal(byteContent);
            return Base64.encodeBase64String((byte[])result);
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            logger.error("AES encrypt error, please check the log.", (Throwable)e);
            throw new EncodeSuiteException();
        }
    }

    @Override
    public String decrypt(String content, String password) throws EncodeSuiteException {
        try {
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(2, AesCryptService.getSecretKey(password));
            byte[] result = cipher.doFinal(Base64.decodeBase64((String)content));
            return new String(result, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            logger.error("AES decrypt error, please check the log.", (Throwable)e);
            throw new EncodeSuiteException();
        }
    }

    private static SecretKeySpec getSecretKey(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(password.getBytes(StandardCharsets.UTF_8.toString()));
        kg.init(128, random);
        SecretKey secretKey = kg.generateKey();
        return new SecretKeySpec(secretKey.getEncoded(), KEY_ALGORITHM);
    }
}

