/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.encode;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.exception.EncodeSuiteException;
import com.webank.weid.protocol.amop.GetEncryptKeyArgs;
import com.webank.weid.protocol.response.GetEncryptKeyResponse;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.AmopService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.AmopServiceImpl;
import com.webank.weid.suite.api.persistence.Persistence;
import com.webank.weid.suite.crypto.CryptServiceFactory;
import com.webank.weid.suite.crypto.KeyGenerator;
import com.webank.weid.suite.encode.EncodeProcessor;
import com.webank.weid.suite.entity.CryptType;
import com.webank.weid.suite.entity.EncodeData;
import com.webank.weid.suite.persistence.sql.driver.MysqlDriver;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.PropertyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherEncodeProcessor
extends BaseService
implements EncodeProcessor {
    private static final Logger logger = LoggerFactory.getLogger(CipherEncodeProcessor.class);
    private Persistence dataDriver = new MysqlDriver();
    protected AmopService amopService = new AmopServiceImpl();
    private static final String ENCRYPTIONDOMAIN = PropertyUtils.getProperty("default.domain");

    @Override
    public String encode(EncodeData encodeData) throws EncodeSuiteException {
        logger.info("[encode] cipher encode process, encryption with AES.");
        try {
            String key = KeyGenerator.getKey();
            HashMap<String, Object> keyMap = new HashMap<String, Object>();
            keyMap.put("keyData", key);
            keyMap.put("verifiers", encodeData.getVerifiers());
            long expireTime = System.currentTimeMillis() + (long)(encodeData.getExpireTime() * 1000);
            keyMap.put("expirationDate", expireTime);
            String saveData = DataToolUtils.serialize(keyMap);
            String value = CryptServiceFactory.getCryptService(CryptType.AES).encrypt(encodeData.getData(), key);
            ResponseData<Integer> response = this.dataDriver.save(ENCRYPTIONDOMAIN, encodeData.getId(), saveData);
            if (response.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                throw new EncodeSuiteException(ErrorCode.getTypeByErrorCode(response.getErrorCode()));
            }
            logger.info("[encode] cipher encode process finished.");
            return value;
        }
        catch (EncodeSuiteException e) {
            logger.error("[encode] encode processor has some error.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("[encode] encode processor has unknow error.", (Throwable)e);
            throw new EncodeSuiteException(e);
        }
    }

    @Override
    public String decode(EncodeData encodeData) throws EncodeSuiteException {
        logger.info("[decode] cipher decode process, decryption with AES.");
        try {
            String key = this.getEntryptKey(encodeData);
            String value = CryptServiceFactory.getCryptService(CryptType.AES).decrypt(encodeData.getData(), key);
            logger.info("[decode] cipher decode process finished.");
            return value;
        }
        catch (EncodeSuiteException e) {
            logger.error("[decode] decode processor has some error.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("[decode] decode processor has unknow error.", (Throwable)e);
            throw new EncodeSuiteException(e);
        }
    }

    private String getEntryptKey(EncodeData encodeData) {
        if (fiscoConfig.getCurrentOrgId().equals(encodeData.getOrgId())) {
            ResponseData<String> response = this.dataDriver.get(ENCRYPTIONDOMAIN, encodeData.getId());
            if (response.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                throw new EncodeSuiteException(ErrorCode.getTypeByErrorCode(response.getErrorCode()));
            }
            return this.getEncryptKey(encodeData, response.getResult());
        }
        return this.requestEncryptKeyByAmop(encodeData);
    }

    private String getEncryptKey(EncodeData encodeData, String value) {
        if (encodeData.getWeIdAuthentication() == null) {
            logger.info("[getEncryptKey] the weid Authentication is null.");
            throw new EncodeSuiteException(ErrorCode.ENCRYPT_KEY_NO_PERMISSION);
        }
        try {
            Map keyMap = (Map)DataToolUtils.deserialize(value, new HashMap().getClass());
            String weId = encodeData.getWeIdAuthentication().getWeId();
            ArrayList verifiers = (ArrayList)keyMap.get("verifiers");
            if (CollectionUtils.isEmpty((Collection)verifiers) || StringUtils.isBlank((CharSequence)weId) || !verifiers.contains(weId)) {
                logger.error("[getEncryptKey] no access to get the data, this weid is {}.", (Object)weId);
                throw new EncodeSuiteException(ErrorCode.ENCRYPT_KEY_NO_PERMISSION);
            }
            if (this.isExpire(keyMap)) {
                logger.error("[getEncryptKey] the encrypt key is expire, this weid is {}.", (Object)weId);
                throw new EncodeSuiteException(ErrorCode.ENCRYPT_KEY_EXPIRE);
            }
            return (String)keyMap.get("keyData");
        }
        catch (DataTypeCastException e) {
            logger.error("[getEncryptKey] deserialize the data error, you should upgrade SDK.", (Throwable)e);
            throw new EncodeSuiteException(ErrorCode.ENCRYPT_KEY_INVALID);
        }
    }

    private String requestEncryptKeyByAmop(EncodeData encodeData) {
        ResponseData<GetEncryptKeyResponse> resResponse;
        GetEncryptKeyArgs args = new GetEncryptKeyArgs();
        args.setKeyId(encodeData.getId());
        args.setMessageId(DataToolUtils.getUuId32());
        args.setToOrgId(encodeData.getOrgId());
        args.setFromOrgId(fiscoConfig.getCurrentOrgId());
        if (encodeData.getWeIdAuthentication() != null) {
            String signValue = DataToolUtils.sign(encodeData.getId(), encodeData.getWeIdAuthentication().getWeIdPrivateKey().getPrivateKey());
            args.setSignValue(signValue);
            args.setWeId(encodeData.getWeIdAuthentication().getWeId());
        }
        if ((resResponse = this.amopService.getEncryptKey(encodeData.getOrgId(), args)).getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[requestEncryptKeyByAmop] AMOP response fail, dataId={}, errorCode={}, errorMessage={}", new Object[]{encodeData.getId(), resResponse.getErrorCode(), resResponse.getErrorMessage()});
            throw new EncodeSuiteException(ErrorCode.getTypeByErrorCode(resResponse.getErrorCode()));
        }
        GetEncryptKeyResponse keyResponse = resResponse.getResult();
        ErrorCode errorCode = ErrorCode.getTypeByErrorCode(keyResponse.getErrorCode());
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            logger.error("[requestEncryptKeyByAmop] requestEncryptKey error, dataId={}, errorCode={}, errorMessage={}", new Object[]{encodeData.getId(), keyResponse.getErrorCode(), keyResponse.getErrorMessage()});
            throw new EncodeSuiteException(errorCode);
        }
        return keyResponse.getEncryptKey();
    }

    private boolean isExpire(Map<String, Object> keyMap) {
        long expire = (Long)keyMap.get("expirationDate");
        return System.currentTimeMillis() > expire;
    }
}

