/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.encode;

import com.webank.weid.exception.EncodeSuiteException;
import com.webank.weid.suite.api.transportation.params.EncodeType;
import com.webank.weid.suite.encode.CipherEncodeProcessor;
import com.webank.weid.suite.encode.EncodeProcessor;
import com.webank.weid.suite.encode.OriginalEncodeProcessor;
import java.util.HashMap;
import java.util.Map;

public class EncodeProcessorFactory {
    private static final Map<String, EncodeProcessor> encode_processor_map = new HashMap<String, EncodeProcessor>();

    public static EncodeProcessor getEncodeProcessor(EncodeType encodeType) {
        EncodeProcessor encodeProcessor = encode_processor_map.get(encodeType.name());
        if (encodeProcessor == null) {
            throw new EncodeSuiteException();
        }
        return encodeProcessor;
    }

    static {
        encode_processor_map.put(EncodeType.ORIGINAL.name(), new OriginalEncodeProcessor());
        encode_processor_map.put(EncodeType.CIPHER.name(), new CipherEncodeProcessor());
    }
}

