/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.persistence.sql;

import com.webank.weid.util.PropertyUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static final Logger logger;
    private static Map<String, BasicDataSource> connectionPoolMap;
    private static final LinkedList<String> SOURCE_NAME_LIST;

    private ConnectionPool() {
    }

    private static Properties initProperties(String dsNamePrefix) {
        String dbUrl = PropertyUtils.getProperty(dsNamePrefix + "jdbc.url");
        String userNameKey = dsNamePrefix + "jdbc.username";
        String userName = PropertyUtils.getProperty(userNameKey);
        String passWordKey = dsNamePrefix + "jdbc.password";
        String passWord = PropertyUtils.getProperty(passWordKey);
        String maxActiveKey = dsNamePrefix + "jdbc.maxActive";
        String maxActive = PropertyUtils.getProperty(maxActiveKey, "50");
        String minIdleKey = dsNamePrefix + "jdbc.minIdle";
        String minIdle = PropertyUtils.getProperty(minIdleKey, "5");
        String maxIdleKey = dsNamePrefix + "jdbc.maxIdle";
        String maxIdle = PropertyUtils.getProperty(maxIdleKey, "5");
        String maxWaitKey = dsNamePrefix + "jdbc.maxWait";
        String maxWait = PropertyUtils.getProperty(maxWaitKey, "10000");
        String timeBetweenKey = dsNamePrefix + "jdbc.timeBetweenEvictionRunsMillis";
        String timeBetween = PropertyUtils.getProperty(timeBetweenKey, "600000");
        String numTestsPerErKey = dsNamePrefix + "jdbc.numTestsPerEvictionRun";
        String numTestsPerEr = PropertyUtils.getProperty(numTestsPerErKey, "5");
        String minEitmKey = dsNamePrefix + "jdbc.minEvictableIdleTimeMillis";
        String minEitm = PropertyUtils.getProperty(minEitmKey, "1800000");
        Properties p = new Properties();
        p.setProperty("url", dbUrl);
        p.setProperty("username", userName);
        p.setProperty("password", passWord);
        p.setProperty("maxActive", maxActive);
        p.setProperty("minIdle", minIdle);
        p.setProperty("maxIdle", maxIdle);
        p.setProperty("maxWait", maxWait);
        p.setProperty("removeAbandoned", "true");
        p.setProperty("removeAbandonedTimeout", "180");
        p.setProperty("testOnBorrow", "false");
        p.setProperty("testWhileIdle", "true");
        p.setProperty("timeBetweenEvictionRunsMillis", timeBetween);
        p.setProperty("numTestsPerEvictionRun", numTestsPerEr);
        p.setProperty("validationQuery", "SELECT 1");
        p.setProperty("minEvictableIdleTimeMillis", minEitm);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() throws Exception {
        if (connectionPoolMap != null) return;
        Class<ConnectionPool> clazz = ConnectionPool.class;
        synchronized (ConnectionPool.class) {
            if (connectionPoolMap != null) return;
            connectionPoolMap = new ConcurrentHashMap<String, BasicDataSource>();
            for (int i = 0; i < SOURCE_NAME_LIST.size(); ++i) {
                Properties properties = ConnectionPool.initProperties(SOURCE_NAME_LIST.get(i) + ".");
                BasicDataSource connectionPool = BasicDataSourceFactory.createDataSource((Properties)properties);
                connectionPoolMap.put(SOURCE_NAME_LIST.get(i), connectionPool);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static Connection getConnection(String dsName) {
        Connection conn = null;
        try {
            if (connectionPoolMap == null) {
                ConnectionPool.init();
            }
            if (connectionPoolMap != null) {
                conn = connectionPoolMap.get(dsName).getConnection();
                conn.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            logger.error("get connection error, please check the log.", (Throwable)e);
        }
        return conn;
    }

    public static void close(Connection conn, PreparedStatement pstmt, ResultSet rs) {
        ConnectionPool.closeResources(rs);
        ConnectionPool.closeResources(pstmt);
        ConnectionPool.closeResources(conn);
    }

    public static void close(Connection conn, PreparedStatement pstmt) {
        ConnectionPool.close(conn, pstmt, null);
    }

    public static void close(Connection conn) {
        ConnectionPool.close(conn, null, null);
    }

    private static void closeResources(Connection conn) {
        if (conn != null) {
            try {
                conn.setAutoCommit(true);
                conn.close();
            }
            catch (SQLException e) {
                logger.error("close Connection error.", (Throwable)e);
            }
        }
    }

    private static void closeResources(PreparedStatement pstmt) {
        if (pstmt != null) {
            try {
                pstmt.close();
            }
            catch (SQLException e) {
                logger.error("close PreparedStatement error.", (Throwable)e);
            }
        }
    }

    private static void closeResources(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error("close ResultSet error.", (Throwable)e);
            }
        }
    }

    public static String getFirstDataSourceName() {
        return SOURCE_NAME_LIST.getFirst();
    }

    public static boolean checkDataSourceName(String dataSourceName) {
        return SOURCE_NAME_LIST.contains(dataSourceName);
    }

    static {
        String[] dataSourceNames;
        logger = LoggerFactory.getLogger(ConnectionPool.class);
        connectionPoolMap = null;
        SOURCE_NAME_LIST = new LinkedList();
        String dataSourceNameStr = PropertyUtils.getProperty("datasource.name");
        for (String string : dataSourceNames = dataSourceNameStr.split(",")) {
            SOURCE_NAME_LIST.add(string);
        }
    }
}

