/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.persistence.sql;

import com.webank.weid.constant.DataDriverConstant;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.suite.persistence.sql.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SqlExecutor.class);
    public static final String TABLE_CHAR = "$1";
    public static final String SQL_QUERY = "select id,data,created from $1 where id =?";
    public static final String SQL_SAVE = "insert into $1(id, data) values(?,?)";
    public static final String SQL_UPDATE = "update $1 set updated = ?, data = ? where id = ?";
    public static final String SQL_DELETE = "delete from $1 where id = ?";
    private static final String DEFAULT_TABLE = "sdk_all_data";
    private static final String SPLIT_CHAR = ":";
    private static final int BATCH_COMMIT_COUNT = 200;
    private String baseDomain;
    private String tableDomain;
    private static final Map<String, String> TABLE_CACHE = new ConcurrentHashMap<String, String>();

    public SqlExecutor(String domain) {
        this.resolveDomain(domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData<String> executeQuery(String sql, String ... data) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        ResponseData<String> result;
        block7: {
            result = new ResponseData<String>();
            conn = null;
            ps = null;
            rs = null;
            conn = ConnectionPool.getConnection(this.baseDomain);
            if (conn != null) break block7;
            ResponseData<String> responseData = new ResponseData<String>("", ErrorCode.SQL_GET_CONNECTION_ERROR);
            ConnectionPool.close(conn, ps, rs);
            return responseData;
        }
        try {
            ps = conn.prepareStatement(this.buildExecuteSql(sql));
            for (int i = 0; i < data.length; ++i) {
                ps.setString(i + 1, data[i]);
            }
            rs = ps.executeQuery();
            String value = null;
            if (rs.next()) {
                value = rs.getString("data");
            }
            rs.close();
            ps.close();
            result.setErrorCode(ErrorCode.SUCCESS);
            result.setResult(value);
        }
        catch (SQLException e) {
            try {
                logger.error("Query data from {{}} with exception", (Object)this.baseDomain, (Object)e);
                result.setErrorCode(ErrorCode.SQL_EXECUTE_FAILED);
                result.setResult("");
            }
            catch (Throwable throwable) {
                ConnectionPool.close(conn, ps, rs);
                throw throwable;
            }
            ConnectionPool.close(conn, ps, rs);
        }
        ConnectionPool.close(conn, ps, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData<Integer> execute(String sql, Object ... data) {
        PreparedStatement ps;
        Connection conn;
        ResponseData<Integer> result;
        block7: {
            result = new ResponseData<Integer>();
            conn = null;
            ps = null;
            conn = ConnectionPool.getConnection(this.baseDomain);
            if (conn != null) break block7;
            ResponseData<Integer> responseData = new ResponseData<Integer>(DataDriverConstant.SQL_EXECUTE_FAILED_STATUS, ErrorCode.SQL_GET_CONNECTION_ERROR);
            ConnectionPool.close(conn, ps);
            return responseData;
        }
        try {
            ps = conn.prepareStatement(this.buildExecuteSql(sql));
            for (int i = 0; data != null && i < data.length; ++i) {
                if (data[i] instanceof Date) {
                    Date date = (Date)data[i];
                    ps.setTimestamp(i + 1, new Timestamp(date.getTime()));
                    continue;
                }
                ps.setObject(i + 1, data[i]);
            }
            int rs = ps.executeUpdate();
            result.setErrorCode(ErrorCode.SUCCESS);
            result.setResult(rs);
        }
        catch (SQLException e) {
            try {
                logger.error("Update data into {{}} with exception", (Object)this.baseDomain, (Object)e);
                result.setErrorCode(ErrorCode.SQL_EXECUTE_FAILED);
                result.setResult(DataDriverConstant.SQL_EXECUTE_FAILED_STATUS);
            }
            catch (Throwable throwable) {
                ConnectionPool.close(conn, ps);
                throw throwable;
            }
            ConnectionPool.close(conn, ps);
        }
        ConnectionPool.close(conn, ps);
        return result;
    }

    public ResponseData<Integer> executeSave(String sql, String checkTableSql, String createTableSql, String ... data) {
        this.resolveTableDomain(checkTableSql, createTableSql);
        return this.execute(sql, Arrays.asList(data).toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseData<Integer> batchSave(String sql, List<List<String>> dataList) {
        result = new ResponseData<Integer>();
        conn = null;
        psts = null;
        try {
            values = dataList.get(dataList.size() - 1);
            for (List<String> list : dataList) {
                if (!CollectionUtils.isEmpty(list) && list.size() == values.size()) continue;
                var9_13 = new ResponseData<Integer>(DataDriverConstant.SQL_EXECUTE_FAILED_STATUS, ErrorCode.PRESISTENCE_BATCH_SAVE_DATA_MISMATCH);
                ** GOTO lbl20
            }
            ** GOTO lbl-1000
        }
        catch (SQLException e) {
            try {
                SqlExecutor.logger.error("Batch save data to {{}} with exception", (Object)this.baseDomain, (Object)e);
                result.setErrorCode(ErrorCode.SQL_EXECUTE_FAILED);
                result.setResult(DataDriverConstant.SQL_EXECUTE_FAILED_STATUS);
            }
            catch (Throwable var14_22) {
                ConnectionPool.close(conn, psts);
                throw var14_22;
            }
lbl20:
            // 1 sources

            ConnectionPool.close(conn, psts);
            return var9_13;
lbl-1000:
            // 1 sources

            {
                conn = ConnectionPool.getConnection(this.baseDomain);
                if (conn != null) ** GOTO lbl-1000
                var7_8 = new ResponseData<Integer>(DataDriverConstant.SQL_EXECUTE_FAILED_STATUS, ErrorCode.SQL_GET_CONNECTION_ERROR);
            }
            ConnectionPool.close(conn, psts);
            return var7_8;
lbl-1000:
            // 1 sources

            {
                conn.setAutoCommit(false);
                psts = conn.prepareStatement(this.buildExecuteSql(sql));
                count = 0;
                for (i = 0; i < values.size(); ++i) {
                    for (j = 0; j < dataList.size(); ++j) {
                        psts.setString(j + 1, dataList.get(j).get(i));
                    }
                    psts.addBatch();
                    if (i % 200 != 0) continue;
                    counts = psts.executeBatch();
                    conn.commit();
                    psts.clearBatch();
                    var10_17 = counts;
                    var11_19 = var10_17.length;
                    for (var12_20 = 0; var12_20 < var11_19; count += j, ++var12_20) {
                        j = var10_17[var12_20];
                    }
                }
                counts = psts.executeBatch();
                conn.commit();
                psts.clearBatch();
                var9_16 = counts;
                var10_18 = var9_16.length;
                for (var11_19 = 0; var11_19 < var10_18; count += j, ++var11_19) {
                    j = var9_16[var11_19];
                }
                result.setResult(count);
            }
            ConnectionPool.close(conn, psts);
            return result;
            ConnectionPool.close(conn, psts);
            return result;
        }
    }

    public ResponseData<Integer> batchSave(String sql, String checkTableSql, String createTableSql, List<List<String>> dataList) {
        this.resolveTableDomain(checkTableSql, createTableSql);
        return this.batchSave(sql, dataList);
    }

    private void resolveDomain(String domain) {
        if (StringUtils.isBlank((CharSequence)domain)) {
            this.baseDomain = ConnectionPool.getFirstDataSourceName();
            this.tableDomain = DEFAULT_TABLE;
        } else if (domain.contains(SPLIT_CHAR) && domain.split(SPLIT_CHAR).length == 2) {
            String[] domains = domain.split(SPLIT_CHAR);
            this.baseDomain = domains[0];
            this.tableDomain = domains[1];
            if (!ConnectionPool.checkDataSourceName(this.baseDomain)) {
                throw new WeIdBaseException(ErrorCode.PRESISTENCE_DOMAIN_INVALID);
            }
        } else {
            throw new WeIdBaseException(ErrorCode.PRESISTENCE_DOMAIN_ILLEGAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveTableDomain(String checkTableSql, String createTableSql) {
        String tableName = TABLE_CACHE.get(this.tableDomain);
        Map<String, String> map = TABLE_CACHE;
        synchronized (map) {
            if (StringUtils.isBlank((CharSequence)tableName)) {
                ResponseData<String> result = this.executeQuery(checkTableSql, new String[0]);
                if (this.tableDomain.equals(result.getResult())) {
                    TABLE_CACHE.put(this.tableDomain, this.tableDomain);
                    return;
                }
                ResponseData<Integer> createRes = this.execute(createTableSql, new Object[0]);
                if (createRes.getErrorCode().intValue() != ErrorCode.SUCCESS.getCode()) {
                    throw new WeIdBaseException(ErrorCode.PRESISTENCE_DOMAIN_INVALID);
                }
                result = this.executeQuery(checkTableSql, new String[0]);
                if (!this.tableDomain.equals(result.getResult())) {
                    throw new WeIdBaseException(ErrorCode.PRESISTENCE_DOMAIN_INVALID);
                }
                TABLE_CACHE.put(this.tableDomain, this.tableDomain);
            }
        }
    }

    private String buildExecuteSql(String sql) {
        return new StringBuffer(sql).toString().replace(TABLE_CHAR, this.tableDomain);
    }
}

