/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.persistence.sql.driver;

import com.webank.weid.constant.DataDriverConstant;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.suite.api.persistence.Persistence;
import com.webank.weid.suite.persistence.sql.SqlExecutor;
import com.webank.weid.util.DataToolUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDriver
implements Persistence {
    private static final Logger logger = LoggerFactory.getLogger(MysqlDriver.class);
    private static final String CHECK_TABLE_SQL = "SELECT table_name data FROM information_schema.TABLES WHERE table_name ='$1'";
    private static final String CREATE_TABLE_SQL = "CREATE TABLE `$1` (`id` varchar(128) NOT NULL COMMENT 'primary key',`data` blob DEFAULT NULL COMMENT 'the save data', `created` datetime DEFAULT CURRENT_TIMESTAMP COMMENT 'created', `updated` datetime DEFAULT CURRENT_TIMESTAMP COMMENT 'updated', `protocol` varchar(32) DEFAULT NULL COMMENT 'protocol', PRIMARY KEY (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='the data table'";
    private static final Integer FAILED_STATUS = DataDriverConstant.SQL_EXECUTE_FAILED_STATUS;
    private static final ErrorCode KEY_INVALID = ErrorCode.PRESISTENCE_DATA_KEY_INVALID;

    @Override
    public ResponseData<String> get(String domain, String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            logger.error("[mysql->get] the id of the data is empty.");
            return new ResponseData<String>("", KEY_INVALID);
        }
        String dataKey = DataToolUtils.getHash(id);
        try {
            ResponseData<String> response = new SqlExecutor(domain).executeQuery("select id,data,created from $1 where id =?", dataKey);
            if (response.getErrorCode().intValue() == ErrorCode.SUCCESS.getCode() && response.getResult() != null) {
                response.setResult(new String(response.getResult().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
            }
            return response;
        }
        catch (WeIdBaseException e) {
            logger.error("[mysql->get] get the data error.", (Throwable)e);
            return new ResponseData<String>("", e.getErrorCode());
        }
    }

    @Override
    public ResponseData<Integer> save(String domain, String id, String data) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            logger.error("[mysql->save] the id of the data is empty.");
            return new ResponseData<Integer>(FAILED_STATUS, KEY_INVALID);
        }
        String dataKey = DataToolUtils.getHash(id);
        try {
            return new SqlExecutor(domain).executeSave("insert into $1(id, data) values(?,?)", CHECK_TABLE_SQL, CREATE_TABLE_SQL, dataKey, data);
        }
        catch (WeIdBaseException e) {
            logger.error("[mysql->save] save the data error.", (Throwable)e);
            return new ResponseData<Integer>(FAILED_STATUS, e.getErrorCode());
        }
    }

    @Override
    public ResponseData<Integer> batchSave(String domain, List<String> ids, List<String> dataList) {
        ArrayList<List<String>> dataLists = new ArrayList<List<String>>();
        ArrayList<String> idHashList = new ArrayList<String>();
        for (String id : ids) {
            if (StringUtils.isEmpty((CharSequence)id)) {
                logger.error("[mysql->batchSave] the id of the data is empty.");
                return new ResponseData<Integer>(FAILED_STATUS, KEY_INVALID);
            }
            idHashList.add(DataToolUtils.getHash(id));
        }
        dataLists.add(idHashList);
        dataLists.add(dataList);
        try {
            return new SqlExecutor(domain).batchSave("insert into $1(id, data) values(?,?)", CHECK_TABLE_SQL, CREATE_TABLE_SQL, dataLists);
        }
        catch (WeIdBaseException e) {
            logger.error("[mysql->batchSave] batchSave the data error.", (Throwable)e);
            return new ResponseData<Integer>(FAILED_STATUS, e.getErrorCode());
        }
    }

    @Override
    public ResponseData<Integer> delete(String domain, String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            logger.error("[mysql->delete] the id of the data is empty.");
            return new ResponseData<Integer>(FAILED_STATUS, KEY_INVALID);
        }
        String dataKey = DataToolUtils.getHash(id);
        try {
            return new SqlExecutor(domain).execute("delete from $1 where id = ?", dataKey);
        }
        catch (WeIdBaseException e) {
            logger.error("[mysql->delete] delete the data error.", (Throwable)e);
            return new ResponseData<Integer>(FAILED_STATUS, e.getErrorCode());
        }
    }

    @Override
    public ResponseData<Integer> update(String domain, String id, String data) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            logger.error("[mysql->update] the id of the data is empty.");
            return new ResponseData<Integer>(FAILED_STATUS, KEY_INVALID);
        }
        String dataKey = DataToolUtils.getHash(id);
        Date date = new Date();
        try {
            return new SqlExecutor(domain).execute("update $1 set updated = ?, data = ? where id = ?", date, data, dataKey);
        }
        catch (WeIdBaseException e) {
            logger.error("[mysql->update] update the data error.", (Throwable)e);
            return new ResponseData<Integer>(FAILED_STATUS, e.getErrorCode());
        }
    }
}

