/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.transportation;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.WeIdAuthentication;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.rpc.WeIdService;
import com.webank.weid.service.BaseService;
import com.webank.weid.service.impl.WeIdServiceImpl;
import com.webank.weid.suite.api.transportation.inf.JsonTransportation;
import com.webank.weid.suite.api.transportation.params.ProtocolProperty;
import com.webank.weid.util.WeIdUtils;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonTransportation
extends BaseService
implements JsonTransportation {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJsonTransportation.class);
    private List<String> verifierWeIdList;
    private WeIdAuthentication weIdAuthentication;
    private static WeIdService weidService = new WeIdServiceImpl();

    protected ErrorCode checkEncodeProperty(ProtocolProperty encodeProperty) {
        if (encodeProperty == null) {
            return ErrorCode.TRANSPORTATION_PROTOCOL_PROPERTY_ERROR;
        }
        if (encodeProperty.getEncodeType() == null) {
            return ErrorCode.TRANSPORTATION_PROTOCOL_ENCODE_ERROR;
        }
        return ErrorCode.SUCCESS;
    }

    protected ErrorCode checkWeIdAuthentication(WeIdAuthentication weIdAuthentication) {
        if (weIdAuthentication == null || weIdAuthentication.getWeIdPrivateKey() == null || weIdAuthentication.getWeId() == null) {
            return ErrorCode.WEID_AUTHORITY_INVALID;
        }
        if (!WeIdUtils.validatePrivateKeyWeIdMatches(weIdAuthentication.getWeIdPrivateKey(), weIdAuthentication.getWeId())) {
            return ErrorCode.WEID_PRIVATEKEY_DOES_NOT_MATCH;
        }
        ResponseData<Boolean> isExists = weidService.isWeIdExist(weIdAuthentication.getWeId());
        if (!isExists.getResult().booleanValue()) {
            return ErrorCode.WEID_DOES_NOT_EXIST;
        }
        return ErrorCode.SUCCESS;
    }

    protected ErrorCode checkProtocolData(Object obj) {
        if (obj == null) {
            return ErrorCode.TRANSPORTATION_PROTOCOL_DATA_INVALID;
        }
        return ErrorCode.SUCCESS;
    }

    public List<String> getVerifiers() {
        return this.verifierWeIdList;
    }

    public void setVerifier(List<String> verifierWeIdList) {
        this.verifierWeIdList = verifierWeIdList;
    }

    @Override
    public JsonTransportation specify(List<String> verifierWeIdList) {
        if (CollectionUtils.isEmpty(verifierWeIdList)) {
            String errorMessage = ErrorCode.ILLEGAL_INPUT.getCode() + "-" + ErrorCode.ILLEGAL_INPUT.getCodeDesc();
            logger.error("[specify] {}, the verifiers is null.", (Object)errorMessage);
            throw new WeIdBaseException(errorMessage);
        }
        for (String weid : verifierWeIdList) {
            ResponseData<Boolean> isExists = weidService.isWeIdExist(weid);
            if (isExists.getResult().booleanValue()) continue;
            String errorMessage = ErrorCode.WEID_DOES_NOT_EXIST.getCode() + "-" + ErrorCode.WEID_DOES_NOT_EXIST.getCodeDesc();
            logger.error("[specify] {} , weid = {} .", (Object)errorMessage, (Object)weid);
            throw new WeIdBaseException(errorMessage);
        }
        this.setVerifier(verifierWeIdList);
        return this;
    }

    public Method getFromJsonMethod(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        Method targetMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals("fromJson") || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != String.class) continue;
            targetMethod = method;
        }
        return targetMethod;
    }

    protected WeIdAuthentication getWeIdAuthentication() {
        return this.weIdAuthentication;
    }

    protected void setWeIdAuthentication(WeIdAuthentication weIdAuthentication) {
        this.weIdAuthentication = weIdAuthentication;
    }
}

