/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.transportation.json.impl;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.WeIdAuthentication;
import com.webank.weid.protocol.inf.JsonSerializer;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.suite.api.transportation.inf.JsonTransportation;
import com.webank.weid.suite.api.transportation.params.EncodeType;
import com.webank.weid.suite.api.transportation.params.ProtocolProperty;
import com.webank.weid.suite.encode.EncodeProcessorFactory;
import com.webank.weid.suite.entity.EncodeData;
import com.webank.weid.suite.entity.JsonVersion;
import com.webank.weid.suite.transportation.AbstractJsonTransportation;
import com.webank.weid.suite.transportation.json.protocol.JsonBaseData;
import com.webank.weid.util.DataToolUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonTransportationImpl
extends AbstractJsonTransportation
implements JsonTransportation {
    private static final Logger logger = LoggerFactory.getLogger(JsonTransportationImpl.class);
    private static final JsonVersion version = JsonVersion.V1;

    @Override
    public <T extends JsonSerializer> ResponseData<String> serialize(T object, ProtocolProperty property) {
        logger.info("[serialize] begin to execute JsonTransportation serialization, property:{}.", (Object)property);
        ErrorCode errorCode = this.checkEncodeProperty(property);
        if (errorCode != ErrorCode.SUCCESS) {
            logger.error("[serialize] checkEncodeProperty fail, errorCode:{}.", (Object)errorCode);
            return new ResponseData<String>("", errorCode);
        }
        errorCode = this.checkProtocolData(object);
        if (errorCode != ErrorCode.SUCCESS) {
            logger.error("[serialize] checkProtocolData fail, errorCode:{}.", (Object)errorCode);
            return new ResponseData<String>("", errorCode);
        }
        try {
            JsonBaseData jsonBaseData = this.buildJsonData(property);
            logger.info("[serialize] encode by {}.", (Object)property.getEncodeType().name());
            if (property.getEncodeType() == EncodeType.ORIGINAL) {
                jsonBaseData.setData(object.toJson());
            } else {
                EncodeData encodeData = new EncodeData(jsonBaseData.getId(), jsonBaseData.getOrgId(), object.toJson(), super.getVerifiers(), property.getKeyExpireTime());
                String data = EncodeProcessorFactory.getEncodeProcessor(property.getEncodeType()).encode(encodeData);
                jsonBaseData.setData(data);
            }
            String jsonData = DataToolUtils.objToJsonStrWithNoPretty(jsonBaseData);
            logger.info("[serialize] JsonTransportation serialization finished.");
            return new ResponseData<String>(jsonData, ErrorCode.SUCCESS);
        }
        catch (WeIdBaseException e) {
            logger.error("[serialize] JsonTransportation serialization due to base error.", (Throwable)e);
            return new ResponseData<String>("", e.getErrorCode());
        }
        catch (Exception e) {
            logger.error("[serialize] JsonTransportation serialization due to unknown error.", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.TRANSPORTATION_BASE_ERROR);
        }
    }

    @Override
    public <T extends JsonSerializer> ResponseData<T> deserialize(String transString, Class<T> clazz) {
        logger.info("[deserialize] begin to execute JsonTransportation deserialize.");
        try {
            String presentationEJson;
            if (StringUtils.isBlank((CharSequence)transString)) {
                logger.error("[deserialize] the transString is blank.");
                return new ResponseData<Object>(null, ErrorCode.TRANSPORTATION_PROTOCOL_DATA_INVALID);
            }
            JsonBaseData jsonBaseData = DataToolUtils.deserialize(transString, JsonBaseData.class);
            ErrorCode errorCode = this.checkJsonBaseData(jsonBaseData);
            if (errorCode != ErrorCode.SUCCESS) {
                logger.error("[deserialize] checkJsonBaseData fail, errorCode:{}.", (Object)errorCode);
                return new ResponseData<Object>(null, errorCode);
            }
            Object data = jsonBaseData.getData();
            if (data instanceof Map) {
                jsonBaseData.setData(DataToolUtils.objToJsonStrWithNoPretty(jsonBaseData.getData()));
            }
            EncodeData encodeData = new EncodeData(jsonBaseData.getId(), jsonBaseData.getOrgId(), jsonBaseData.getData().toString(), super.getWeIdAuthentication());
            EncodeType encodeType = EncodeType.getObject(String.valueOf(jsonBaseData.getEncodeType()));
            if (encodeType == null) {
                return new ResponseData<Object>(null, ErrorCode.TRANSPORTATION_PROTOCOL_ENCODE_ERROR);
            }
            logger.info("[deserialize] decode by {}.", (Object)encodeType.name());
            String presentationEStr = EncodeProcessorFactory.getEncodeProcessor(encodeType).decode(encodeData);
            String presentationEJsonNew = presentationEJson = DataToolUtils.convertUtcToTimestamp(presentationEStr);
            if (DataToolUtils.isValidFromToJson(presentationEJson)) {
                presentationEJsonNew = DataToolUtils.removeTagFromToJson(presentationEJson);
            }
            JsonSerializer object = null;
            Method method = this.getFromJsonMethod(clazz);
            object = method == null ? (JsonSerializer)DataToolUtils.deserialize(presentationEJsonNew, clazz) : (JsonSerializer)method.invoke(null, presentationEJsonNew);
            logger.info("[deserialize] JsonTransportation deserialize finished.");
            return new ResponseData<JsonSerializer>(object, ErrorCode.SUCCESS);
        }
        catch (WeIdBaseException e) {
            logger.error("[deserialize] JsonTransportation deserialize due to base error.", (Throwable)e);
            return new ResponseData<Object>(null, e.getErrorCode());
        }
        catch (Exception e) {
            logger.error("[deserialize] JsonTransportation deserialize due to unknown error.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.TRANSPORTATION_BASE_ERROR);
        }
    }

    @Override
    public <T extends JsonSerializer> ResponseData<T> deserialize(WeIdAuthentication weIdAuthentication, String transString, Class<T> clazz) {
        ErrorCode errorCode = this.checkWeIdAuthentication(weIdAuthentication);
        if (errorCode != ErrorCode.SUCCESS) {
            logger.error("[deserialize] checkWeIdAuthentication fail, errorCode:{}.", (Object)errorCode);
            return new ResponseData<Object>(null, errorCode);
        }
        super.setWeIdAuthentication(weIdAuthentication);
        return this.deserialize(transString, clazz);
    }

    private JsonBaseData buildJsonData(ProtocolProperty property) {
        JsonBaseData jsonBaseData = new JsonBaseData();
        jsonBaseData.setEncodeType(property.getEncodeType().getCode());
        jsonBaseData.setId(DataToolUtils.getUuId32());
        jsonBaseData.setOrgId(fiscoConfig.getCurrentOrgId());
        jsonBaseData.setVersion(version.getCode());
        return jsonBaseData;
    }

    private ErrorCode checkJsonBaseData(JsonBaseData jsonBaseData) {
        if (jsonBaseData == null || StringUtils.isBlank((CharSequence)jsonBaseData.getId()) || StringUtils.isBlank((CharSequence)jsonBaseData.getOrgId()) || jsonBaseData.getData() == null || StringUtils.isBlank((CharSequence)jsonBaseData.getData().toString())) {
            return ErrorCode.TRANSPORTATION_PROTOCOL_DATA_INVALID;
        }
        if (JsonVersion.getJsonVersion(jsonBaseData.getVersion()) == null) {
            return ErrorCode.TRANSPORTATION_PROTOCOL_VERSION_ERROR;
        }
        if (EncodeType.getObject(String.valueOf(jsonBaseData.getEncodeType())) == null) {
            return ErrorCode.TRANSPORTATION_PROTOCOL_ENCODE_ERROR;
        }
        return ErrorCode.SUCCESS;
    }
}

