/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.transportation.qr.impl;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.WeIdAuthentication;
import com.webank.weid.protocol.inf.JsonSerializer;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.suite.api.transportation.inf.QrCodeTransportation;
import com.webank.weid.suite.api.transportation.params.ProtocolProperty;
import com.webank.weid.suite.encode.EncodeProcessorFactory;
import com.webank.weid.suite.entity.EncodeData;
import com.webank.weid.suite.entity.QrCodeVersion;
import com.webank.weid.suite.transportation.AbstractJsonTransportation;
import com.webank.weid.suite.transportation.qr.protocol.QrCodeBaseData;
import com.webank.weid.suite.transportation.qr.protocol.QrCodeVersion1;
import com.webank.weid.util.DataToolUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeJsonTransportationImpl
extends AbstractJsonTransportation
implements QrCodeTransportation {
    private static final Logger logger = LoggerFactory.getLogger(QrCodeJsonTransportationImpl.class);
    private static final QrCodeVersion version = QrCodeVersion.V1;
    private static final Map<String, Class<?>> protocol_version_map = new HashMap();

    @Override
    public <T extends JsonSerializer> ResponseData<String> serialize(T object, ProtocolProperty property) {
        logger.info("[serialize] begin to execute QrCodeTransportation serialization, property:{}", (Object)property);
        ErrorCode errorCode = this.checkEncodeProperty(property);
        if (errorCode != ErrorCode.SUCCESS) {
            logger.error("[serialize] checkEncodeProperty fail, errorCode:{}.", (Object)errorCode);
            return new ResponseData<String>("", errorCode);
        }
        errorCode = this.checkProtocolData(object);
        if (errorCode != ErrorCode.SUCCESS) {
            logger.error("[serialize] checkProtocolData fail, errorCode:{}.", (Object)errorCode);
            return new ResponseData<String>("", errorCode);
        }
        try {
            QrCodeBaseData qrCodeData = QrCodeBaseData.newInstance(protocol_version_map.get(version.name()));
            qrCodeData.buildQrCodeData(property, fiscoConfig.getCurrentOrgId());
            EncodeData encodeData = new EncodeData(qrCodeData.getId(), qrCodeData.getOrgId(), object.toJson(), super.getVerifiers(), property.getKeyExpireTime());
            logger.info("[serialize] encode by {}.", (Object)property.getEncodeType().name());
            String data = EncodeProcessorFactory.getEncodeProcessor(qrCodeData.getEncodeType()).encode(encodeData);
            qrCodeData.setData(data);
            String transString = qrCodeData.buildBuffer().getTransString();
            logger.info("[serialize] QrCodeTransportation serialization finished.");
            return new ResponseData<String>(transString, ErrorCode.SUCCESS);
        }
        catch (WeIdBaseException e) {
            logger.error("[serialize] QrCodeTransportation serialization due to base error.", (Throwable)e);
            return new ResponseData<String>("", e.getErrorCode());
        }
        catch (Exception e) {
            logger.error("[serialize] QrCodeTransportation serialization due to unknown error.", (Throwable)e);
            return new ResponseData<String>("", ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public <T extends JsonSerializer> ResponseData<T> deserialize(String transString, Class<T> clazz) {
        logger.info("[deserialize] begin to execute QrCodeTransportation deserialize.");
        try {
            String presentationEStr;
            QrCodeVersion version = QrCodeBaseData.getQrCodeVersion(transString);
            QrCodeBaseData qrCodeData = QrCodeBaseData.newInstance(protocol_version_map.get(version.name()));
            qrCodeData.buildData(transString);
            EncodeData encodeData = new EncodeData(qrCodeData.getId(), qrCodeData.getOrgId(), qrCodeData.getData(), super.getWeIdAuthentication());
            logger.info("[deserialize] encode by {}.", (Object)qrCodeData.getEncodeType().name());
            String data = EncodeProcessorFactory.getEncodeProcessor(qrCodeData.getEncodeType()).decode(encodeData);
            String presentationEStrNew = presentationEStr = DataToolUtils.convertUtcToTimestamp(data);
            if (DataToolUtils.isValidFromToJson(presentationEStr)) {
                presentationEStrNew = DataToolUtils.removeTagFromToJson(presentationEStr);
            }
            JsonSerializer object = null;
            Method method = this.getFromJsonMethod(clazz);
            object = method == null ? (JsonSerializer)DataToolUtils.deserialize(presentationEStrNew, clazz) : (JsonSerializer)method.invoke(null, presentationEStrNew);
            logger.info("[deserialize] QrCodeTransportation deserialize finished.");
            return new ResponseData<JsonSerializer>(object, ErrorCode.SUCCESS);
        }
        catch (WeIdBaseException e) {
            logger.error("[deserialize] QrCodeTransportation deserialize due to base error.", (Throwable)e);
            return new ResponseData<Object>(null, e.getErrorCode());
        }
        catch (Exception e) {
            logger.error("[deserialize] QrCodeTransportation deserialize due to unknown error.", (Throwable)e);
            return new ResponseData<Object>(null, ErrorCode.UNKNOW_ERROR);
        }
    }

    @Override
    public <T extends JsonSerializer> ResponseData<T> deserialize(WeIdAuthentication weIdAuthentication, String transString, Class<T> clazz) {
        ErrorCode errorCode = this.checkWeIdAuthentication(weIdAuthentication);
        if (errorCode != ErrorCode.SUCCESS) {
            logger.error("[deserialize] checkWeIdAuthentication fail, errorCode:{}.", (Object)errorCode);
            return new ResponseData<Object>(null, errorCode);
        }
        super.setWeIdAuthentication(weIdAuthentication);
        return this.deserialize(transString, clazz);
    }

    static {
        protocol_version_map.put(QrCodeVersion.V1.name(), QrCodeVersion1.class);
    }
}

