/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.suite.transportation.qr.protocol;

import com.webank.weid.constant.ErrorCode;
import com.webank.weid.exception.ProtocolSuiteException;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.suite.api.transportation.params.EncodeType;
import com.webank.weid.suite.api.transportation.params.ProtocolProperty;
import com.webank.weid.suite.entity.QrCodeVersion;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public abstract class QrCodeBaseData {
    protected static final String PROTOCOL_PARTITION = "|";
    protected static final String PROTOCOL_PARTITION_DIVISION = "\\|";
    protected static final String PROTOCOL_VERSION = "version|";
    private EncodeType encodeType;
    private QrCodeVersion version;
    private String orgId;
    private String id;
    private String data;
    private String extendData;
    protected StringBuffer buffer = new StringBuffer();

    public String getExtendData() {
        return this.extendData != null ? this.extendData : "?";
    }

    public String getTransString() {
        return this.buffer.toString();
    }

    public abstract void buildQrCodeData(ProtocolProperty var1, String var2);

    protected void buildHead(EncodeType encodeType, QrCodeVersion version) {
        this.encodeType = encodeType;
        this.version = version;
    }

    public abstract QrCodeBaseData buildBuffer();

    protected void buildBuffer(String[] protocols) {
        this.buffer.setLength(0);
        try {
            for (String protocolField : protocols) {
                Method method = this.getGetterMethod(this.getClass(), protocolField);
                String value = method.invoke((Object)this, new Object[0]).toString();
                if (value.indexOf(PROTOCOL_PARTITION) >= 0) {
                    throw new ProtocolSuiteException(ErrorCode.TRANSPORTATION_PROTOCOL_FIELD_INVALID);
                }
                if (this.buffer.length() == 0) {
                    this.buffer.append(value);
                    continue;
                }
                this.buffer.append(PROTOCOL_PARTITION).append(value);
            }
        }
        catch (ProtocolSuiteException e) {
            throw e;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new WeIdBaseException("buildBuffer error.", e);
        }
    }

    public abstract QrCodeBaseData buildData(String var1);

    protected void buildData(String[] protocols, String transString) {
        this.buffer.setLength(0);
        this.buffer.append(transString);
        String[] values = this.buffer.toString().split(PROTOCOL_PARTITION_DIVISION);
        if (values.length != protocols.length) {
            throw new ProtocolSuiteException(ErrorCode.TRANSPORTATION_PROTOCOL_STRING_INVALID);
        }
        try {
            for (int i = 0; i < protocols.length; ++i) {
                Method setMethod = this.getSetterMethod(this.getClass(), protocols[i]);
                String value = values[i];
                Class<?> theFirstParamType = setMethod.getParameterTypes()[0];
                if (theFirstParamType.isEnum()) {
                    Method method = theFirstParamType.getMethod("getObject", String.class);
                    Object obj = method.invoke(theFirstParamType, value);
                    if (obj == null) {
                        throw new ProtocolSuiteException(ErrorCode.TRANSPORTATION_PROTOCOL_STRING_INVALID);
                    }
                    setMethod.invoke((Object)this, obj);
                    continue;
                }
                setMethod.invoke((Object)this, value);
            }
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new WeIdBaseException("buildData error.", e);
        }
    }

    private Method getGetterMethod(Class<?> cls, String fieldName) throws NoSuchMethodException {
        return cls.getMethod("get" + fieldName.substring(0, 1).toUpperCase(Locale.getDefault()) + fieldName.substring(1), new Class[0]);
    }

    private Method getSetterMethod(Class<?> cls, String fieldName) throws NoSuchMethodException, SecurityException {
        String methodName = "set" + fieldName.substring(0, 1).toUpperCase(Locale.getDefault()) + fieldName.substring(1);
        return cls.getMethod(methodName, this.getGetterMethod(cls, fieldName).getReturnType());
    }

    public static QrCodeBaseData newInstance(Class<?> cls) throws ReflectiveOperationException {
        return (QrCodeBaseData)cls.newInstance();
    }

    public static QrCodeVersion getQrCodeVersion(String transString) {
        if (StringUtils.isBlank((CharSequence)transString) || transString.indexOf(PROTOCOL_PARTITION) == -1) {
            throw new ProtocolSuiteException(ErrorCode.TRANSPORTATION_PROTOCOL_STRING_INVALID);
        }
        String version = transString.substring(0, transString.indexOf(PROTOCOL_PARTITION));
        QrCodeVersion metaVersion = QrCodeVersion.getObject(version);
        if (metaVersion == null) {
            throw new ProtocolSuiteException(ErrorCode.TRANSPORTATION_PROTOCOL_VERSION_ERROR);
        }
        return metaVersion;
    }

    public EncodeType getEncodeType() {
        return this.encodeType;
    }

    public QrCodeVersion getVersion() {
        return this.version;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getId() {
        return this.id;
    }

    public String getData() {
        return this.data;
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setEncodeType(EncodeType encodeType) {
        this.encodeType = encodeType;
    }

    public void setVersion(QrCodeVersion version) {
        this.version = version;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setExtendData(String extendData) {
        this.extendData = extendData;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }
}

