/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.util;

import com.webank.weid.constant.CredentialConstant;
import com.webank.weid.constant.CredentialFieldDisclosureValue;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.base.CredentialPojo;
import com.webank.weid.protocol.base.PresentationE;
import com.webank.weid.protocol.base.PresentationPolicyE;
import com.webank.weid.protocol.request.CreateCredentialPojoArgs;
import com.webank.weid.util.CredentialUtils;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.WeIdUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialPojoUtils {
    private static final Logger logger = LoggerFactory.getLogger(CredentialPojoUtils.class);
    private static Integer NOT_DISCLOSED = CredentialFieldDisclosureValue.NOT_DISCLOSED.getStatus();

    public static String getCredentialThumbprintWithoutSig(CredentialPojo credential, Map<String, Object> salt, Map<String, Object> disclosures) {
        try {
            Map<String, Object> credMap = DataToolUtils.objToMap(credential);
            credMap.remove("proof");
            credMap.put("proof", null);
            String claimHash = CredentialPojoUtils.getClaimHash(credential, salt, disclosures);
            credMap.put("claim", claimHash);
            return DataToolUtils.mapToCompactJson(credMap);
        }
        catch (Exception e) {
            logger.error("get Credential Thumbprint WithoutSig error.", (Throwable)e);
            return "";
        }
    }

    public static String getCredentialThumbprint(CredentialPojo credential, Map<String, Object> salt, Map<String, Object> disclosures) {
        try {
            Map<String, Object> credMap = DataToolUtils.objToMap(credential);
            String claimHash = CredentialPojoUtils.getClaimHash(credential, salt, disclosures);
            credMap.put("claim", claimHash);
            return DataToolUtils.mapToCompactJson(credMap);
        }
        catch (Exception e) {
            logger.error("get Credential Thumbprint error.", (Throwable)e);
            return "";
        }
    }

    public static String getClaimHash(CredentialPojo credential, Map<String, Object> salt, Map<String, Object> disclosures) {
        Map<String, Object> claim = credential.getClaim();
        Map newClaim = DataToolUtils.clone((HashMap)claim);
        CredentialPojoUtils.addSaltAndGetHash(newClaim, salt, disclosures);
        try {
            String jsonData = DataToolUtils.mapToCompactJson(newClaim);
            return jsonData;
        }
        catch (Exception e) {
            logger.error("[getClaimHash] get claim hash failed. {}", (Throwable)e);
            return "";
        }
    }

    private static void addSaltAndGetHash(Map<String, Object> claim, Map<String, Object> salt, Map<String, Object> disclosures) {
        for (Map.Entry<String, Object> entry : salt.entrySet()) {
            String key = entry.getKey();
            Object disclosureObj = null;
            if (disclosures != null) {
                disclosureObj = disclosures.get(key);
            }
            Object saltObj = salt.get(key);
            Object newClaimObj = claim.get(key);
            if (saltObj instanceof Map) {
                CredentialPojoUtils.addSaltAndGetHash((HashMap)newClaimObj, (HashMap)saltObj, (HashMap)disclosureObj);
                continue;
            }
            if (saltObj instanceof List) {
                ArrayList disclosureObjList = null;
                if (disclosureObj != null) {
                    disclosureObjList = (ArrayList)disclosureObj;
                }
                CredentialPojoUtils.addSaltAndGetHashForList((ArrayList)newClaimObj, (ArrayList)saltObj, disclosureObjList);
                continue;
            }
            CredentialPojoUtils.addSaltByDisclose(claim, key, disclosureObj, saltObj, newClaimObj);
        }
    }

    private static void addSaltByDisclose(Map<String, Object> claim, String key, Object disclosureObj, Object saltObj, Object newClaimObj) {
        if (disclosureObj == null) {
            if (!NOT_DISCLOSED.toString().equals(saltObj.toString())) {
                claim.put(key, CredentialPojoUtils.getFieldSaltHash(String.valueOf(newClaimObj), String.valueOf(saltObj)));
            }
        } else if (NOT_DISCLOSED.toString().equals(disclosureObj.toString())) {
            claim.put(key, CredentialPojoUtils.getFieldSaltHash(String.valueOf(newClaimObj), String.valueOf(saltObj)));
        }
    }

    private static void addSaltAndGetHashForList(List<Object> claim, List<Object> salt, List<Object> disclosures) {
        for (int i = 0; claim != null && i < claim.size(); ++i) {
            Object disclosureObj;
            Object obj = claim.get(i);
            Object saltObj = salt.get(i);
            if (obj instanceof Map) {
                Object disclosureObj2 = null;
                if (disclosures != null) {
                    disclosureObj2 = disclosures.get(0);
                }
                CredentialPojoUtils.addSaltAndGetHash((HashMap)obj, (HashMap)saltObj, (HashMap)disclosureObj2);
                continue;
            }
            if (!(obj instanceof List)) continue;
            ArrayList disclosureObjList = null;
            if (disclosures != null && (disclosureObj = disclosures.get(i)) != null) {
                disclosureObjList = (ArrayList)disclosureObj;
            }
            CredentialPojoUtils.addSaltAndGetHashForList((ArrayList)obj, (ArrayList)saltObj, disclosureObjList);
        }
    }

    public static ErrorCode checkPresentationEValid(PresentationE presentationE) {
        if (presentationE == null || presentationE.getVerifiableCredential() == null || presentationE.getVerifiableCredential().isEmpty() || presentationE.getProof() == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (StringUtils.isEmpty((CharSequence)presentationE.getSignature())) {
            return ErrorCode.CREDENTIAL_SIGNATURE_NOT_EXISTS;
        }
        return ErrorCode.SUCCESS;
    }

    public static boolean checkPresentationPolicyEValid(PresentationPolicyE presentationPolicyE) {
        return presentationPolicyE != null && presentationPolicyE.getPolicy() != null && presentationPolicyE.getPolicy().size() != 0;
    }

    public static String getFieldSaltHash(String field, String salt) {
        return DataToolUtils.sha3(String.valueOf(field) + String.valueOf(salt));
    }

    public static Map<String, Object> getDisclosuredClaimData(CredentialPojo credentialPojo) {
        if (credentialPojo == null || !CredentialPojoUtils.validClaimAndSaltForMap(credentialPojo.getClaim(), credentialPojo.getSalt())) {
            logger.error("getDisclosuredClaimData failed, credentialPojo is null or claim and salt of credentialPojo not match ");
            return null;
        }
        Map<String, Object> claimMap = credentialPojo.getClaim();
        Map newMap = DataToolUtils.clone((HashMap)claimMap);
        Map<String, Object> saltMap = credentialPojo.getSalt();
        CredentialPojoUtils.getDisclosureClaimData(saltMap, newMap);
        return newMap;
    }

    private static void getDisclosureClaimData(Map<String, Object> saltMap, Map<String, Object> claim) {
        for (Map.Entry<String, Object> entry : saltMap.entrySet()) {
            String saltKey = entry.getKey();
            Object saltV = entry.getValue();
            Object claimV = claim.get(saltKey);
            if (saltV instanceof Map) {
                CredentialPojoUtils.getDisclosureClaimData((HashMap)saltV, (HashMap)claimV);
                continue;
            }
            if (saltV instanceof List) {
                CredentialPojoUtils.getDisclosureClaimDataForList((ArrayList)saltV, (ArrayList)claimV);
                continue;
            }
            CredentialPojoUtils.removeNotDisclosureData(claim, saltKey, saltV);
        }
    }

    private static void removeNotDisclosureData(Map<String, Object> claim, String saltKey, Object saltV) {
        if (!StringUtils.isBlank((CharSequence)saltV.toString()) && String.valueOf(saltV).equals(NOT_DISCLOSED.toString())) {
            claim.remove(saltKey);
        }
    }

    private static void getDisclosureClaimDataForList(List<Object> salt, List<Object> claim) {
        for (int i = 0; claim != null && i < salt.size(); ++i) {
            Object saltObj = salt.get(i);
            Object claimObj = claim.get(i);
            if (saltObj instanceof Map) {
                CredentialPojoUtils.getDisclosureClaimData((HashMap)saltObj, (HashMap)claimObj);
                continue;
            }
            if (!(saltObj instanceof List)) continue;
            CredentialPojoUtils.getDisclosureClaimDataForList((ArrayList)saltObj, (ArrayList)claimObj);
        }
    }

    public static boolean validClaimAndSaltForMap(Map<String, Object> claim, Map<String, Object> salt) {
        if (claim == null || salt == null) {
            return false;
        }
        Set<String> claimKeys = claim.keySet();
        Set<String> saltKeys = salt.keySet();
        if (claimKeys.size() != saltKeys.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : claim.entrySet()) {
            ArrayList saltValue;
            ArrayList claimValue;
            String k = entry.getKey();
            Object claimV = entry.getValue();
            Object saltV = salt.get(k);
            if (!salt.containsKey(k)) {
                return false;
            }
            if (!(claimV instanceof Map ? !CredentialPojoUtils.validClaimAndSaltForMap((HashMap)claimV, (HashMap)saltV) : claimV instanceof List && !CredentialPojoUtils.validClaimAndSaltForList(claimValue = (ArrayList)claimV, saltValue = (ArrayList)saltV))) continue;
            return false;
        }
        return true;
    }

    private static boolean validClaimAndSaltForList(List<Object> claimList, List<Object> saltList) {
        if (claimList == null || saltList == null) {
            return false;
        }
        if (claimList.size() != saltList.size()) {
            return false;
        }
        for (int i = 0; i < claimList.size(); ++i) {
            Object claimObj = claimList.get(i);
            Object saltObj = saltList.get(i);
            if (claimObj instanceof Map) {
                if (!(saltObj instanceof Map)) {
                    return false;
                }
                if (CredentialPojoUtils.validClaimAndSaltForMap((HashMap)claimObj, (HashMap)saltObj)) continue;
                return false;
            }
            if (!(claimObj instanceof List)) continue;
            if (!(saltObj instanceof List)) {
                return false;
            }
            ArrayList claimObjV = (ArrayList)claimObj;
            ArrayList saltObjV = (ArrayList)saltObj;
            if (CredentialPojoUtils.validClaimAndSaltForList(claimObjV, saltObjV)) continue;
            return false;
        }
        return true;
    }

    public static ErrorCode isCreateCredentialPojoArgsValid(CreateCredentialPojoArgs args) {
        if (args == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (args.getCptId() == null || args.getCptId() < 0) {
            return ErrorCode.CPT_ID_ILLEGAL;
        }
        if (!WeIdUtils.isWeIdValid(args.getIssuer())) {
            return ErrorCode.CREDENTIAL_ISSUER_INVALID;
        }
        if (args.getClaim() == null) {
            return ErrorCode.CREDENTIAL_CLAIM_NOT_EXISTS;
        }
        ErrorCode errorCode = CredentialPojoUtils.validDateExpired(args.getIssuanceDate(), args.getExpirationDate());
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return errorCode;
        }
        if (args.getWeIdAuthentication() == null || args.getWeIdAuthentication().getWeIdPrivateKey() == null || StringUtils.isBlank((CharSequence)args.getWeIdAuthentication().getWeIdPrivateKey().getPrivateKey()) || StringUtils.isBlank((CharSequence)args.getWeIdAuthentication().getWeIdPublicKeyId())) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        return ErrorCode.SUCCESS;
    }

    private static ErrorCode validDateExpired(Long issuanceDate, Long expirationDate) {
        if (issuanceDate != null && issuanceDate <= 0L) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        if (expirationDate == null || expirationDate < 0L || expirationDate == 0L || !DateUtils.isAfterCurrentTime(expirationDate)) {
            return ErrorCode.CREDENTIAL_EXPIRE_DATE_ILLEGAL;
        }
        if (issuanceDate != null && expirationDate < issuanceDate) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        return ErrorCode.SUCCESS;
    }

    public static ErrorCode isCredentialPojoValid(CredentialPojo args) {
        if (args == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (args.getCptId() == null || args.getCptId() < 0) {
            return ErrorCode.CPT_ID_ILLEGAL;
        }
        if (!WeIdUtils.isWeIdValid(args.getIssuer())) {
            return ErrorCode.CREDENTIAL_ISSUER_INVALID;
        }
        if (args.getClaim() == null) {
            return ErrorCode.CREDENTIAL_CLAIM_NOT_EXISTS;
        }
        if (args.getIssuanceDate() == null) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        ErrorCode errorCode = CredentialPojoUtils.validDateExpired(args.getIssuanceDate(), args.getExpirationDate());
        if (errorCode.getCode() != ErrorCode.SUCCESS.getCode()) {
            return errorCode;
        }
        ErrorCode contentResponseData = CredentialPojoUtils.isCredentialContentValid(args);
        if (ErrorCode.SUCCESS.getCode() != contentResponseData.getCode()) {
            return contentResponseData;
        }
        return ErrorCode.SUCCESS;
    }

    private static ErrorCode isCredentialContentValid(CredentialPojo args) {
        String credentialId = args.getId();
        if (StringUtils.isEmpty((CharSequence)credentialId) || !CredentialUtils.isValidUuid(credentialId)) {
            return ErrorCode.CREDENTIAL_ID_NOT_EXISTS;
        }
        String context = args.getContext();
        if (StringUtils.isEmpty((CharSequence)context)) {
            return ErrorCode.CREDENTIAL_CONTEXT_NOT_EXISTS;
        }
        if (CollectionUtils.isEmpty(args.getType())) {
            return ErrorCode.CREDENTIAL_TYPE_IS_NULL;
        }
        Map<String, Object> proof = args.getProof();
        return CredentialPojoUtils.isCredentialProofValid(proof);
    }

    private static ErrorCode isCredentialProofValid(Map<String, Object> proof) {
        if (proof == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        String type = null;
        if (proof.get("type") == null) {
            return ErrorCode.CREDENTIAL_SIGNATURE_TYPE_ILLEGAL;
        }
        type = String.valueOf(proof.get("type"));
        if (!CredentialPojoUtils.isCredentialProofTypeValid(type)) {
            return ErrorCode.CREDENTIAL_SIGNATURE_TYPE_ILLEGAL;
        }
        if (proof.get("created") == null) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        Long created = Long.valueOf(String.valueOf(proof.get("created")));
        if (created <= 0L) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        if (proof.get("creator") == null) {
            return ErrorCode.CREDENTIAL_ISSUER_INVALID;
        }
        String creator = String.valueOf(proof.get("creator"));
        if (StringUtils.isEmpty((CharSequence)creator)) {
            return ErrorCode.CREDENTIAL_ISSUER_INVALID;
        }
        if (type.equalsIgnoreCase(CredentialConstant.CredentialProofType.ECDSA.getTypeName())) {
            if (proof.get("signatureValue") == null) {
                return ErrorCode.CREDENTIAL_SIGNATURE_BROKEN;
            }
            String signature = String.valueOf(proof.get("signatureValue"));
            if (StringUtils.isEmpty((CharSequence)signature) || !DataToolUtils.isValidBase64String(signature)) {
                return ErrorCode.CREDENTIAL_SIGNATURE_BROKEN;
            }
        }
        return ErrorCode.SUCCESS;
    }

    private static boolean isCredentialProofTypeValid(String type) {
        if (!StringUtils.isEmpty((CharSequence)type)) {
            for (CredentialConstant.CredentialProofType proofType : CredentialConstant.CredentialProofType.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)proofType.getTypeName())) continue;
                return true;
            }
        }
        return false;
    }
}

