/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.util;

import com.webank.weid.constant.CredentialConstant;
import com.webank.weid.constant.CredentialFieldDisclosureValue;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.protocol.base.Credential;
import com.webank.weid.protocol.base.CredentialPojo;
import com.webank.weid.protocol.base.WeIdPrivateKey;
import com.webank.weid.protocol.request.CreateCredentialArgs;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.WeIdUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.crypto.Sign;

public final class CredentialUtils {
    public static String getCredentialThumbprintWithoutSig(Credential credential, Map<String, Object> disclosures) {
        try {
            Credential rawCredential = CredentialUtils.copyCredential(credential);
            rawCredential.setProof(null);
            return CredentialUtils.getCredentialThumbprint(rawCredential, disclosures);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static Map<String, String> buildCredentialProof(Credential credential, String privateKey, Map<String, Object> disclosureMap) {
        HashMap<String, String> proof = new HashMap<String, String>();
        proof.put("created", credential.getIssuanceDate().toString());
        proof.put("creator", credential.getIssuer());
        proof.put("type", CredentialUtils.getDefaultCredentialProofType());
        proof.put("signature", CredentialUtils.getCredentialSignature(credential, privateKey, disclosureMap));
        return proof;
    }

    public static Credential copyCredential(Credential credential) {
        Map<String, Object> originalClaim;
        Credential ct = new Credential();
        ct.setContext(credential.getContext());
        Map<String, String> originalProof = credential.getProof();
        if (originalProof != null) {
            Map proof = DataToolUtils.deserialize(DataToolUtils.serialize(originalProof), HashMap.class);
            ct.setProof(proof);
        }
        if ((originalClaim = credential.getClaim()) != null) {
            Map claim = DataToolUtils.deserialize(DataToolUtils.serialize(originalClaim), HashMap.class);
            ct.setClaim(claim);
        }
        ct.setIssuanceDate(credential.getIssuanceDate());
        ct.setCptId(credential.getCptId());
        ct.setExpirationDate(credential.getExpirationDate());
        ct.setIssuer(credential.getIssuer());
        ct.setId(credential.getId());
        return ct;
    }

    public static CredentialPojo copyCredential(CredentialPojo credentialPojo) {
        List<String> originalType;
        Map<String, Object> originalClaim;
        CredentialPojo cpj = new CredentialPojo();
        cpj.setContext(credentialPojo.getContext());
        cpj.setIssuanceDate(credentialPojo.getIssuanceDate());
        cpj.setCptId(credentialPojo.getCptId());
        cpj.setExpirationDate(credentialPojo.getExpirationDate());
        cpj.setIssuer(credentialPojo.getIssuer());
        cpj.setId(credentialPojo.getId());
        Map<String, Object> originalProof = credentialPojo.getProof();
        if (originalProof != null) {
            Map proof = DataToolUtils.deserialize(DataToolUtils.serialize(originalProof), HashMap.class);
            cpj.setProof(proof);
        }
        if ((originalClaim = credentialPojo.getClaim()) != null) {
            Map claim = DataToolUtils.deserialize(DataToolUtils.serialize(originalClaim), HashMap.class);
            cpj.setClaim(claim);
        }
        if ((originalType = credentialPojo.getType()) != null) {
            ArrayList<String> type = new ArrayList<String>(originalType.size());
            if (originalType.size() > 0) {
                for (String originalTypeItem : originalType) {
                    type.add(originalTypeItem);
                }
            }
            cpj.setType(type);
        }
        return cpj;
    }

    public static String getCredentialThumbprint(Credential credential, Map<String, Object> disclosures) {
        try {
            Map<String, Object> credMap = DataToolUtils.objToMap(credential);
            String claimHash = CredentialUtils.getClaimHash(credential, disclosures);
            credMap.put("claim", claimHash);
            return DataToolUtils.mapToCompactJson(credMap);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getClaimHash(Credential credential, Map<String, Object> disclosures) {
        Map<String, Object> disclosureMap;
        Map<String, Object> claim = credential.getClaim();
        HashMap<String, Object> claimHashMap = new HashMap<String, Object>(claim);
        if (disclosures == null) {
            disclosureMap = new HashMap<String, Object>(claim);
            for (Map.Entry<String, Object> entry : disclosureMap.entrySet()) {
                disclosureMap.put(entry.getKey(), CredentialFieldDisclosureValue.DISCLOSED.getStatus());
            }
        } else {
            disclosureMap = disclosures;
        }
        for (Map.Entry<String, Object> entry : disclosureMap.entrySet()) {
            if (!CredentialFieldDisclosureValue.DISCLOSED.getStatus().equals(entry.getValue())) continue;
            claimHashMap.put(entry.getKey(), CredentialUtils.getFieldHash(claimHashMap.get(entry.getKey())));
        }
        ArrayList list = new ArrayList(claimHashMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        StringBuffer hash = new StringBuffer();
        for (Map.Entry entry : list) {
            hash.append((String)entry.getKey()).append(entry.getValue());
        }
        return hash.toString();
    }

    public static String getFieldHash(Object field) {
        return DataToolUtils.sha3(String.valueOf(field));
    }

    public static String getDefaultCredentialContext() {
        return "https://github.com/WeBankFinTech/WeIdentity/blob/master/context/v1";
    }

    public static CreateCredentialArgs extractCredentialMetadata(Credential arg) {
        if (arg == null) {
            return null;
        }
        CreateCredentialArgs generateCredentialArgs = new CreateCredentialArgs();
        generateCredentialArgs.setCptId(arg.getCptId());
        generateCredentialArgs.setIssuer(arg.getIssuer());
        generateCredentialArgs.setIssuanceDate(arg.getIssuanceDate());
        generateCredentialArgs.setExpirationDate(arg.getExpirationDate());
        generateCredentialArgs.setClaim(arg.getClaim());
        return generateCredentialArgs;
    }

    public static String getCredentialSignature(Credential credential, String privateKey, Map<String, Object> disclosureMap) {
        String rawData = CredentialUtils.getCredentialThumbprintWithoutSig(credential, disclosureMap);
        Sign.SignatureData sigData = DataToolUtils.signMessage(rawData, privateKey);
        return new String(DataToolUtils.base64Encode(DataToolUtils.simpleSignatureSerialization(sigData)), StandardCharsets.UTF_8);
    }

    public static String getCredentialHash(Credential arg) {
        String rawData = CredentialUtils.getCredentialThumbprint(arg, null);
        if (StringUtils.isEmpty((CharSequence)rawData)) {
            return "";
        }
        return DataToolUtils.sha3(rawData);
    }

    public static Bytes32 convertCredentialIdToBytes32(String id) {
        if (!CredentialUtils.isValidUuid(id)) {
            return new Bytes32(new byte[32]);
        }
        String mergedId = id.replaceAll("-", "");
        byte[] uuidBytes = mergedId.getBytes(StandardCharsets.UTF_8);
        return DataToolUtils.bytesArrayToBytes32(uuidBytes);
    }

    public static boolean isValidUuid(String id) {
        Pattern p = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");
        return p.matcher(id).matches();
    }

    public static ErrorCode isCreateCredentialArgsValid(CreateCredentialArgs args) {
        if (args == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (args.getCptId() == null || args.getCptId() < 0) {
            return ErrorCode.CPT_ID_ILLEGAL;
        }
        if (!WeIdUtils.isWeIdValid(args.getIssuer())) {
            return ErrorCode.CREDENTIAL_ISSUER_INVALID;
        }
        Long issuanceDate = args.getIssuanceDate();
        if (issuanceDate != null && issuanceDate <= 0L) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        Long expirationDate = args.getExpirationDate();
        if (expirationDate == null || expirationDate < 0L || expirationDate == 0L || issuanceDate != null && expirationDate < issuanceDate || expirationDate < System.currentTimeMillis()) {
            return ErrorCode.CREDENTIAL_EXPIRE_DATE_ILLEGAL;
        }
        if (args.getClaim() == null || args.getClaim().isEmpty()) {
            return ErrorCode.CREDENTIAL_CLAIM_NOT_EXISTS;
        }
        return ErrorCode.SUCCESS;
    }

    public static ErrorCode isCredentialValid(Credential args) {
        if (args == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        CreateCredentialArgs createCredentialArgs = CredentialUtils.extractCredentialMetadata(args);
        ErrorCode metadataResponseData = CredentialUtils.isCreateCredentialArgsValid(createCredentialArgs);
        if (ErrorCode.SUCCESS.getCode() != metadataResponseData.getCode()) {
            return metadataResponseData;
        }
        ErrorCode contentResponseData = CredentialUtils.isCredentialContentValid(args);
        if (ErrorCode.SUCCESS.getCode() != contentResponseData.getCode()) {
            return contentResponseData;
        }
        return ErrorCode.SUCCESS;
    }

    public static ErrorCode isCredentialContentValid(Credential args) {
        String credentialId = args.getId();
        if (StringUtils.isEmpty((CharSequence)credentialId) || !CredentialUtils.isValidUuid(credentialId)) {
            return ErrorCode.CREDENTIAL_ID_NOT_EXISTS;
        }
        String context = args.getContext();
        if (StringUtils.isEmpty((CharSequence)context)) {
            return ErrorCode.CREDENTIAL_CONTEXT_NOT_EXISTS;
        }
        Long issuanceDate = args.getIssuanceDate();
        if (issuanceDate == null) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        if (issuanceDate > args.getExpirationDate()) {
            return ErrorCode.CREDENTIAL_EXPIRED;
        }
        Map<String, String> proof = args.getProof();
        return CredentialUtils.isCredentialProofValid(proof);
    }

    private static ErrorCode isCredentialProofValid(Map<String, String> proof) {
        String signature;
        if (proof == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        String type = proof.get("type");
        if (!CredentialUtils.isCredentialProofTypeValid(type)) {
            return ErrorCode.CREDENTIAL_SIGNATURE_TYPE_ILLEGAL;
        }
        Long created = Long.valueOf(proof.get("created"));
        if (created <= 0L) {
            return ErrorCode.CREDENTIAL_ISSUANCE_DATE_ILLEGAL;
        }
        String creator = proof.get("creator");
        if (!StringUtils.isEmpty((CharSequence)creator) && !WeIdUtils.isWeIdValid(creator)) {
            return ErrorCode.CREDENTIAL_ISSUER_INVALID;
        }
        if (type.equalsIgnoreCase(CredentialConstant.CredentialProofType.ECDSA.getTypeName()) && (StringUtils.isEmpty((CharSequence)(signature = proof.get("signature"))) || !DataToolUtils.isValidBase64String(signature))) {
            return ErrorCode.CREDENTIAL_SIGNATURE_BROKEN;
        }
        return ErrorCode.SUCCESS;
    }

    public static String getDefaultCredentialProofType() {
        return CredentialConstant.CredentialProofType.ECDSA.getTypeName();
    }

    private static boolean isCredentialProofTypeValid(String type) {
        if (!StringUtils.isEmpty((CharSequence)type)) {
            for (CredentialConstant.CredentialProofType proofType : CredentialConstant.CredentialProofType.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)proofType.getTypeName())) continue;
                return true;
            }
        }
        return false;
    }

    public static ErrorCode isCreateEvidenceArgsValid(Credential credential, WeIdPrivateKey weIdPrivateKey) {
        if (credential == null) {
            return ErrorCode.ILLEGAL_INPUT;
        }
        if (!WeIdUtils.isPrivateKeyValid(weIdPrivateKey)) {
            return ErrorCode.CREDENTIAL_PRIVATE_KEY_NOT_EXISTS;
        }
        return ErrorCode.SUCCESS;
    }
}

