/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.reinert.jjschema.v1.JsonSchemaV4Factory;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.exception.DataTypeCastException;
import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.AuthenticationProperty;
import com.webank.weid.protocol.base.PublicKeyProperty;
import com.webank.weid.protocol.base.WeIdDocument;
import com.webank.weid.protocol.response.RsvSignature;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.PropertyUtils;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.DynamicArray;
import org.bcos.web3j.abi.datatypes.DynamicBytes;
import org.bcos.web3j.abi.datatypes.StaticArray;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.abi.datatypes.generated.Uint8;
import org.bcos.web3j.crypto.ECKeyPair;
import org.bcos.web3j.crypto.Hash;
import org.bcos.web3j.crypto.Keys;
import org.bcos.web3j.crypto.Sign;
import org.bcos.web3j.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataToolUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataToolUtils.class);
    private static final String SEPARATOR_CHAR = "-";
    private static final String CHARSET = StandardCharsets.UTF_8.toString();
    private static final String FORMAT_NAME = "JPG";
    private static final String DEFAULT_SALT_LENGTH = "5";
    private static final int QRCODE_SIZE = 300;
    private static final int LOGO_WIDTH = 60;
    private static final int LOGO_HEIGHT = 60;
    private static final int SERIALIZED_SIGNATUREDATA_LENGTH = 65;
    private static final int radix = 10;
    private static final String TO_JSON = "toJson";
    private static final String FROM_JSON = "fromJson";
    private static final String KEY_CREATED = "created";
    private static final String KEY_ISSUANCEDATE = "issuanceDate";
    private static final String KEY_EXPIRATIONDATE = "expirationDate";
    private static final String KEY_CLAIM = "claim";
    private static final String KEY_FROM_TOJSON = "$from";
    private static final List<String> CONVERT_UTC_LONG_KEYLIST = new ArrayList<String>();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectWriter OBJECT_WRITER_UN_PRETTY_PRINTER;

    public static String sha3(String utfString) {
        return Numeric.toHexString((byte[])DataToolUtils.sha3(utfString.getBytes(StandardCharsets.UTF_8)));
    }

    public static byte[] sha3(byte[] input) {
        return Hash.sha3((byte[])input, (int)0, (int)input.length);
    }

    public static String getHash(String hexInput) {
        return DataToolUtils.sha3(hexInput);
    }

    public static String getRandomSalt() {
        String length = PropertyUtils.getProperty("salt.length", DEFAULT_SALT_LENGTH);
        int saltLength = Integer.valueOf(length);
        String salt = RandomStringUtils.random((int)saltLength, (boolean)true, (boolean)true);
        return salt;
    }

    public static <T> String serialize(T object) {
        StringWriter write = new StringWriter();
        try {
            OBJECT_MAPPER.writeValue((Writer)write, object);
        }
        catch (JsonGenerationException e) {
            logger.error("JsonGenerationException when serialize object to json", (Throwable)e);
        }
        catch (JsonMappingException e) {
            logger.error("JsonMappingException when serialize object to json", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException when serialize object to json", (Throwable)e);
        }
        return ((Object)write).toString();
    }

    public static <T> T deserialize(String json, Class<T> clazz) {
        Object object = null;
        try {
            if (DataToolUtils.isValidFromToJson(json)) {
                logger.error("this jsonString is converted by toJson(), please use fromJson() to deserialize it");
                throw new DataTypeCastException("deserialize json to Object error");
            }
            object = OBJECT_MAPPER.readValue(json, TypeFactory.rawClass(clazz));
        }
        catch (JsonParseException e) {
            logger.error("JsonParseException when deserialize json to object", (Throwable)e);
            throw new DataTypeCastException(e);
        }
        catch (JsonMappingException e) {
            logger.error("JsonMappingException when deserialize json to object", (Throwable)e);
            throw new DataTypeCastException(e);
        }
        catch (IOException e) {
            logger.error("IOException when deserialize json to object", (Throwable)e);
            throw new DataTypeCastException(e);
        }
        return (T)object;
    }

    public static <T> List<T> deserializeToList(String json, Class<T> clazz) {
        List object = null;
        try {
            JavaType javaType = OBJECT_MAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{TypeFactory.rawClass(clazz)});
            object = (List)OBJECT_MAPPER.readValue(json, javaType);
        }
        catch (JsonParseException e) {
            logger.error("JsonParseException when serialize object to json", (Throwable)e);
            throw new DataTypeCastException(e);
        }
        catch (JsonMappingException e) {
            logger.error("JsonMappingException when serialize object to json", (Throwable)e);
            new DataTypeCastException(e);
        }
        catch (IOException e) {
            logger.error("IOException when serialize object to json", (Throwable)e);
        }
        return object;
    }

    public static String objToJsonStrWithNoPretty(Object obj) {
        try {
            return OBJECT_WRITER_UN_PRETTY_PRINTER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new DataTypeCastException(e);
        }
    }

    public static String mapToCompactJson(Map<String, Object> map) throws Exception {
        return OBJECT_MAPPER.readTree(DataToolUtils.serialize(map)).toString();
    }

    public static Map<String, Object> objToMap(Object object) throws Exception {
        JsonNode jsonNode = OBJECT_MAPPER.readTree(DataToolUtils.serialize(object));
        return (HashMap)OBJECT_MAPPER.convertValue((Object)jsonNode, HashMap.class);
    }

    public static <T extends Serializable> T clone(T obj) {
        Serializable clonedObj = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            clonedObj = (Serializable)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            logger.error("clone object has error.", (Throwable)e);
        }
        return (T)clonedObj;
    }

    public static JsonNode loadJsonObject(String jsonString) throws IOException {
        return JsonLoader.fromString((String)jsonString);
    }

    public static boolean isValidateJsonVersusSchema(String jsonData, String jsonSchema) throws Exception {
        JsonNode jsonDataNode = DataToolUtils.loadJsonObject(jsonData);
        JsonNode jsonSchemaNode = DataToolUtils.loadJsonObject(jsonSchema);
        JsonSchema schema = JsonSchemaFactory.byDefault().getJsonSchema(jsonSchemaNode);
        ProcessingReport report = schema.validate(jsonDataNode);
        if (report.isSuccess()) {
            logger.info(report.toString());
            return true;
        }
        Iterator it = report.iterator();
        StringBuffer errorMsg = new StringBuffer();
        while (it.hasNext()) {
            errorMsg.append(((ProcessingMessage)it.next()).getMessage());
        }
        logger.error("Json schema validator failed, error: {}", (Object)errorMsg.toString());
        return false;
    }

    public static boolean isValidJsonSchema(String jsonSchema) throws IOException {
        return JsonSchemaFactory.byDefault().getSyntaxValidator().schemaIsValid(DataToolUtils.loadJsonObject(jsonSchema));
    }

    public static boolean isCptJsonSchemaValid(String cptJsonSchema) throws IOException {
        return StringUtils.isNotEmpty((CharSequence)cptJsonSchema) && DataToolUtils.isValidJsonSchema(cptJsonSchema) && cptJsonSchema.length() <= WeIdConstant.JSON_SCHEMA_MAX_LENGTH;
    }

    public static ECKeyPair createKeyPair() throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return Keys.createEcKeyPair();
    }

    public static Sign.SignatureData signMessage(String message, ECKeyPair keyPair) {
        return Sign.signMessage((byte[])DataToolUtils.sha3(message.getBytes(StandardCharsets.UTF_8)), (ECKeyPair)keyPair);
    }

    public static Sign.SignatureData signMessage(String message, String privateKeyString) {
        BigInteger privateKey = new BigInteger(privateKeyString);
        ECKeyPair keyPair = new ECKeyPair(privateKey, DataToolUtils.publicKeyFromPrivate(privateKey));
        return Sign.signMessage((byte[])DataToolUtils.sha3(message.getBytes(StandardCharsets.UTF_8)), (ECKeyPair)keyPair);
    }

    public static String sign(String rawData, String privateKeyString) {
        Sign.SignatureData sigData = DataToolUtils.signMessage(rawData, privateKeyString);
        return new String(DataToolUtils.base64Encode(DataToolUtils.simpleSignatureSerialization(sigData)), StandardCharsets.UTF_8);
    }

    public static BigInteger signatureToPublicKey(String message, Sign.SignatureData signatureData) throws SignatureException {
        return Sign.signedMessageToKey((byte[])DataToolUtils.sha3(message.getBytes(StandardCharsets.UTF_8)), (Sign.SignatureData)signatureData);
    }

    public static boolean verifySignature(String message, Sign.SignatureData signatureData, BigInteger publicKey) throws SignatureException {
        BigInteger extractedPublicKey = DataToolUtils.signatureToPublicKey(message, signatureData);
        return extractedPublicKey.equals(publicKey);
    }

    public static boolean verifySignature(String message, String signature, BigInteger publicKey) throws SignatureException {
        Sign.SignatureData signatureData = DataToolUtils.convertBase64StringToSignatureData(signature);
        BigInteger extractedPublicKey = DataToolUtils.signatureToPublicKey(message, signatureData);
        return extractedPublicKey.equals(publicKey);
    }

    public static BigInteger publicKeyFromPrivate(BigInteger privateKey) {
        return Sign.publicKeyFromPrivate((BigInteger)privateKey);
    }

    public static ECKeyPair createKeyPairFromPrivate(BigInteger privateKey) {
        return ECKeyPair.create((BigInteger)privateKey);
    }

    public static byte[] base64Decode(byte[] base64Bytes) {
        return org.bouncycastle.util.encoders.Base64.decode((byte[])base64Bytes);
    }

    public static byte[] base64Encode(byte[] nonBase64Bytes) {
        return org.bouncycastle.util.encoders.Base64.encode((byte[])nonBase64Bytes);
    }

    public static boolean isValidBase64String(String string) {
        return Base64.isBase64((String)string);
    }

    public static byte[] simpleSignatureSerialization(Sign.SignatureData signatureData) {
        byte[] serializedSignatureData = new byte[65];
        serializedSignatureData[0] = signatureData.getV();
        System.arraycopy(signatureData.getR(), 0, serializedSignatureData, 1, 32);
        System.arraycopy(signatureData.getS(), 0, serializedSignatureData, 33, 32);
        return serializedSignatureData;
    }

    public static Sign.SignatureData simpleSignatureDeserialization(byte[] serializedSignatureData) {
        if (65 != serializedSignatureData.length) {
            throw new WeIdBaseException("signature data illegal");
        }
        byte v = serializedSignatureData[0];
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        System.arraycopy(serializedSignatureData, 1, r, 0, 32);
        System.arraycopy(serializedSignatureData, 33, s, 0, 32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return signatureData;
    }

    public static Sign.SignatureData rawSignatureDeserialization(int v, byte[] r, byte[] s) {
        byte valueByte = (byte)v;
        return new Sign.SignatureData(valueByte, r, s);
    }

    public static ErrorCode verifySignatureFromWeId(String rawData, String signature, WeIdDocument weIdDocument) {
        Sign.SignatureData signatureData = null;
        try {
            signatureData = DataToolUtils.convertBase64StringToSignatureData(signature);
        }
        catch (Exception e) {
            logger.error("verify Signature failed.", (Throwable)e);
            return ErrorCode.CREDENTIAL_SIGNATURE_BROKEN;
        }
        return DataToolUtils.verifySignatureFromWeId(rawData, signatureData, weIdDocument);
    }

    public static ErrorCode verifySignatureFromWeId(String rawData, Sign.SignatureData signatureData, WeIdDocument weIdDocument) {
        ArrayList<String> publicKeysListToVerify = new ArrayList<String>();
        for (AuthenticationProperty authenticationProperty : weIdDocument.getAuthentication()) {
            String index = authenticationProperty.getPublicKey();
            for (PublicKeyProperty publicKeyProperty : weIdDocument.getPublicKey()) {
                if (!publicKeyProperty.getId().equalsIgnoreCase(index)) continue;
                publicKeysListToVerify.add(publicKeyProperty.getPublicKey());
            }
        }
        try {
            boolean result = false;
            for (String publicKeyItem : publicKeysListToVerify) {
                if (!StringUtils.isNotEmpty((CharSequence)publicKeyItem)) continue;
                result = result || DataToolUtils.verifySignature(rawData, signatureData, new BigInteger(publicKeyItem));
            }
            if (!result) {
                return ErrorCode.CREDENTIAL_ISSUER_MISMATCH;
            }
        }
        catch (SignatureException e) {
            logger.error("some exceptions occurred in signature verification", (Throwable)e);
            return ErrorCode.CREDENTIAL_EXCEPTION_VERIFYSIGNATURE;
        }
        return ErrorCode.SUCCESS;
    }

    public static RsvSignature convertSignatureDataToRsv(Sign.SignatureData signatureData) {
        Uint8 v = DataToolUtils.intToUnt8(signatureData.getV());
        Bytes32 r = DataToolUtils.bytesArrayToBytes32(signatureData.getR());
        Bytes32 s = DataToolUtils.bytesArrayToBytes32(signatureData.getS());
        RsvSignature rsvSignature = new RsvSignature();
        rsvSignature.setV(v);
        rsvSignature.setR(r);
        rsvSignature.setS(s);
        return rsvSignature;
    }

    public static Sign.SignatureData convertBase64StringToSignatureData(String base64Signature) {
        return DataToolUtils.simpleSignatureDeserialization(DataToolUtils.base64Decode(base64Signature.getBytes(StandardCharsets.UTF_8)));
    }

    public static String getUuId32() {
        return UUID.randomUUID().toString().replaceAll(SEPARATOR_CHAR, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compress(String arg) throws IOException {
        if (null == arg || arg.length() <= 0) {
            return arg;
        }
        ByteArrayOutputStream out = null;
        GZIPOutputStream gzip = null;
        try {
            String value;
            out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            gzip.write(arg.getBytes(StandardCharsets.UTF_8.toString()));
            DataToolUtils.close(gzip);
            String string = value = out.toString(StandardCharsets.ISO_8859_1.toString());
            return string;
        }
        finally {
            DataToolUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unCompress(String arg) throws IOException {
        String string;
        if (null == arg || arg.length() <= 0) {
            return arg;
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gzip = null;
        try {
            String value;
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(arg.getBytes(StandardCharsets.ISO_8859_1.toString()));
            gzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            int n = 0;
            while ((n = gzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            string = value = out.toString(StandardCharsets.UTF_8.toString());
        }
        catch (Throwable throwable) {
            DataToolUtils.close(gzip);
            DataToolUtils.close(in);
            DataToolUtils.close(out);
            throw throwable;
        }
        DataToolUtils.close(gzip);
        DataToolUtils.close(in);
        DataToolUtils.close(out);
        return string;
    }

    private static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.error("close OutputStream error", (Throwable)e);
            }
        }
    }

    private static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("close InputStream error", (Throwable)e);
            }
        }
    }

    private static BufferedImage createImage(String content, String imgPath, ErrorCorrectionLevel errorCorrectionLevel, boolean needCompress) throws WriterException, IOException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 300, 300, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (StringUtils.isBlank((CharSequence)imgPath)) {
            return image;
        }
        DataToolUtils.insertImage(image, imgPath, needCompress);
        return image;
    }

    private static void insertImage(BufferedImage source, String imgPath, boolean needCompress) throws IOException {
        File file = new File(imgPath);
        if (!file.exists()) {
            logger.error("imgPath:[{}] is not exists.", (Object)imgPath);
            return;
        }
        Image src = ImageIO.read(new File(imgPath));
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        if (needCompress) {
            if (width > 60) {
                width = 60;
            }
            if (height > 60) {
                height = 60;
            }
            Image image = src.getScaledInstance(width, height, 4);
            BufferedImage tag = new BufferedImage(width, height, 1);
            Graphics g = tag.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            src = image;
        }
        Graphics2D graph = source.createGraphics();
        int x = (300 - width) / 2;
        int y = (300 - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    private static void qrCodeEncode(String content, String imgPath, String destPath, ErrorCorrectionLevel errorCorrectionLevel, boolean needCompress) throws WriterException, IOException {
        BufferedImage image = DataToolUtils.createImage(content, imgPath, errorCorrectionLevel, needCompress);
        ImageIO.write((RenderedImage)image, FORMAT_NAME, new File(destPath));
    }

    public static Integer generateQrCode(String content, ErrorCorrectionLevel errorCorrectionLevel, String destPath) {
        try {
            DataToolUtils.qrCodeEncode(content, null, destPath, errorCorrectionLevel, false);
            return ErrorCode.SUCCESS.getCode();
        }
        catch (WriterException e) {
            logger.error("generateQrCode into file WriterException.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("generateQrCode into file IOException.", (Throwable)e);
        }
        return ErrorCode.UNKNOW_ERROR.getCode();
    }

    public static Integer generateQrCode(String content, ErrorCorrectionLevel errorCorrectionLevel, OutputStream stream) {
        try {
            BufferedImage image = DataToolUtils.createImage(content, null, errorCorrectionLevel, false);
            ImageIO.write((RenderedImage)image, FORMAT_NAME, stream);
            return ErrorCode.SUCCESS.getCode();
        }
        catch (WriterException e) {
            logger.error("generateQrCode into OutputStream WriterException.", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("generateQrCode into OutputStream IOException.", (Throwable)e);
        }
        return ErrorCode.UNKNOW_ERROR.getCode();
    }

    public static Bytes32 bytesArrayToBytes32(byte[] byteValue) {
        byte[] byteValueLen32 = new byte[32];
        System.arraycopy(byteValue, 0, byteValueLen32, 0, byteValue.length);
        return new Bytes32(byteValueLen32);
    }

    public static Bytes32 stringToBytes32(String string) {
        byte[] byteValueLen32 = new byte[32];
        if (StringUtils.isEmpty((CharSequence)string)) {
            return new Bytes32(byteValueLen32);
        }
        byte[] byteValue = string.getBytes(StandardCharsets.UTF_8);
        System.arraycopy(byteValue, 0, byteValueLen32, 0, byteValue.length);
        return new Bytes32(byteValueLen32);
    }

    public static byte[] bytes32ToBytesArray(Bytes32 bytes32) {
        byte[] bytesArray = new byte[32];
        byte[] bytes32Value = bytes32.getValue();
        System.arraycopy(bytes32Value, 0, bytesArray, 0, 32);
        return bytesArray;
    }

    public static String bytes32ToString(Bytes32 bytes32) {
        return new String(bytes32.getValue(), StandardCharsets.UTF_8).trim();
    }

    public static byte[] stringToByteArray(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new byte[1];
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] stringToByte32Array(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return new byte[32];
        }
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        byte[] newBytes = new byte[32];
        System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
        return newBytes;
    }

    public static List<byte[]> stringToByte32ArrayList(String data, int size) {
        List<byte[]> byteList = new ArrayList<byte[]>();
        if (StringUtils.isBlank((CharSequence)data)) {
            for (int i = 0; i < size; ++i) {
                byteList.add(new byte[32]);
            }
            return byteList;
        }
        byte[] dataBytes = data.getBytes(StandardCharsets.UTF_8);
        if (dataBytes.length <= WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH) {
            byte[] newBytes = new byte[32];
            System.arraycopy(dataBytes, 0, newBytes, 0, dataBytes.length);
            byteList.add(newBytes);
        } else {
            byteList = DataToolUtils.splitBytes(dataBytes, size);
        }
        if (byteList.size() < size) {
            ArrayList<byte[]> addList = new ArrayList<byte[]>();
            for (int i = 0; i < size - byteList.size(); ++i) {
                addList.add(new byte[32]);
            }
            byteList.addAll(addList);
        }
        return byteList;
    }

    private static synchronized List<byte[]> splitBytes(byte[] bytes, int size) {
        ArrayList<byte[]> byteList = new ArrayList<byte[]>();
        double splitLength = Double.parseDouble(WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH + "");
        int arrayLength = (int)Math.ceil((double)bytes.length / splitLength);
        byte[] result = new byte[arrayLength];
        int from = 0;
        int to = 0;
        for (int i = 0; i < arrayLength; ++i) {
            from = (int)((double)i * splitLength);
            to = (int)((double)from + splitLength);
            if (to > bytes.length) {
                to = bytes.length;
            }
            if ((result = Arrays.copyOfRange(bytes, from, to)).length < size) {
                byte[] newBytes = new byte[32];
                System.arraycopy(result, 0, newBytes, 0, result.length);
                byteList.add(newBytes);
                continue;
            }
            byteList.add(result);
        }
        return byteList;
    }

    public static List<byte[]> bytesArrayListToBytes32ArrayList(List<byte[]> list, int size) {
        ArrayList<byte[]> bytesList = new ArrayList<byte[]>();
        if (list.isEmpty()) {
            for (int i = 0; i < size; ++i) {
                bytesList.add(new byte[32]);
            }
            return bytesList;
        }
        for (byte[] bytes : list) {
            if (bytes.length > WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH) continue;
            byte[] newBytes = new byte[32];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            bytesList.add(newBytes);
        }
        if (bytesList.size() < size) {
            ArrayList<byte[]> addList = new ArrayList<byte[]>();
            for (int i = 0; i < size - bytesList.size(); ++i) {
                addList.add(new byte[32]);
            }
            bytesList.addAll(addList);
        }
        return bytesList;
    }

    public static String bytes32ToStringWithoutTrim(Bytes32 bytes32) {
        byte[] strs = bytes32.getValue();
        return new String(strs, StandardCharsets.UTF_8);
    }

    public static Uint256 intToUint256(int value) {
        return new Uint256(new BigInteger(String.valueOf(value)));
    }

    public static int uint256ToInt(Uint256 value) {
        return value.getValue().intValue();
    }

    public static DynamicBytes stringToDynamicBytes(String input) {
        return new DynamicBytes(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String dynamicBytesToString(DynamicBytes input) {
        return new String(input.getValue(), StandardCharsets.UTF_8);
    }

    public static Int256 intToInt256(int value) {
        return new Int256((long)value);
    }

    public static int int256ToInt(Int256 value) {
        return value.getValue().intValue();
    }

    public static Uint8 intToUnt8(int value) {
        return new Uint8((long)value);
    }

    public static int uint8ToInt(Uint8 value) {
        return value.getValue().intValue();
    }

    public static Int256 longToInt256(long value) {
        return new Int256(value);
    }

    public static long int256ToLong(Int256 value) {
        return value.getValue().longValue();
    }

    public static StaticArray<Int256> longArrayToInt256StaticArray(long[] longArray) {
        ArrayList<Int256> int256List = new ArrayList<Int256>();
        for (int i = 0; i < longArray.length; ++i) {
            int256List.add(DataToolUtils.longToInt256(longArray[i]));
        }
        StaticArray in256StaticArray = new StaticArray(int256List);
        return in256StaticArray;
    }

    public static StaticArray<Bytes32> stringArrayToBytes32StaticArray(String[] stringArray) {
        ArrayList<Bytes32> bytes32List = new ArrayList<Bytes32>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (StringUtils.isNotEmpty((CharSequence)stringArray[i])) {
                bytes32List.add(DataToolUtils.stringToBytes32(stringArray[i]));
                continue;
            }
            bytes32List.add(DataToolUtils.stringToBytes32(""));
        }
        StaticArray bytes32StaticArray = new StaticArray(bytes32List);
        return bytes32StaticArray;
    }

    public static StaticArray<Bytes32> byteArrayListToBytes32StaticArray(List<byte[]> bytes) {
        ArrayList<Bytes32> bytes32List = new ArrayList<Bytes32>();
        for (int i = 0; i < bytes.size(); ++i) {
            bytes32List.add(DataToolUtils.bytesArrayToBytes32(bytes.get(i)));
        }
        StaticArray bytes32StaticArray = new StaticArray(bytes32List);
        return bytes32StaticArray;
    }

    public static StaticArray<Address> addressArrayToAddressStaticArray(Address[] addressArray) {
        ArrayList<Address> addressList = new ArrayList<Address>();
        for (int i = 0; i < addressArray.length; ++i) {
            addressList.add(addressArray[i]);
        }
        StaticArray addressStaticArray = new StaticArray(addressList);
        return addressStaticArray;
    }

    public static String[] bytes32DynamicArrayToStringArrayWithoutTrim(DynamicArray<Bytes32> bytes32DynamicArray) {
        List bytes32List = bytes32DynamicArray.getValue();
        String[] stringArray = new String[bytes32List.size()];
        for (int i = 0; i < bytes32List.size(); ++i) {
            stringArray[i] = DataToolUtils.bytes32ToStringWithoutTrim((Bytes32)bytes32List.get(i));
        }
        return stringArray;
    }

    public static String bytes32DynamicArrayToStringWithoutTrim(DynamicArray<Bytes32> bytes32DynamicArray) {
        List bytes32List = bytes32DynamicArray.getValue();
        ArrayList<byte[]> byteArraylist = new ArrayList<byte[]>();
        for (int i = 0; i < bytes32List.size(); ++i) {
            byteArraylist.add(DataToolUtils.bytes32ToBytesArray((Bytes32)bytes32List.get(i)));
        }
        return DataToolUtils.byte32ListToString(byteArraylist, bytes32List.size());
    }

    public static long[] int256DynamicArrayToLongArray(DynamicArray<Int256> int256DynamicArray) {
        List int256list = int256DynamicArray.getValue();
        long[] longArray = new long[int256list.size()];
        for (int i = 0; i < int256list.size(); ++i) {
            longArray[i] = DataToolUtils.int256ToLong((Int256)int256list.get(i));
        }
        return longArray;
    }

    public static List<BigInteger> listToListBigInteger(List<BigInteger> list, int size) {
        ArrayList<BigInteger> bigIntegerList = new ArrayList<BigInteger>();
        for (BigInteger bs : list) {
            bigIntegerList.add(bs);
        }
        ArrayList<BigInteger> addList = new ArrayList<BigInteger>();
        if (bigIntegerList.size() < size) {
            for (int i = 0; i < size - bigIntegerList.size(); ++i) {
                addList.add(BigInteger.ZERO);
            }
            bigIntegerList.addAll(addList);
        }
        return bigIntegerList;
    }

    public static String generateDefaultCptJsonSchema(Integer cptId) {
        String cptClassStr = "com.webank.weid.protocol.cpt.Cpt" + cptId;
        try {
            return DataToolUtils.generateDefaultCptJsonSchema(Class.forName(cptClassStr));
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String generateDefaultCptJsonSchema(Class myClass) {
        try {
            JsonSchemaV4Factory schemaFactory = new JsonSchemaV4Factory();
            schemaFactory.setAutoPutDollarSchema(true);
            JsonNode cptSchema = schemaFactory.createSchema(myClass);
            return DataToolUtils.objToJsonStrWithNoPretty(cptSchema);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String generateUnformattedCptJsonSchema() {
        ArrayList anyStringList = new ArrayList();
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put("type", "string");
        anyStringList.add(stringMap);
        HashMap<String, String> nullMap = new HashMap<String, String>();
        nullMap.put("type", "null");
        anyStringList.add(nullMap);
        LinkedHashMap anyMap = new LinkedHashMap();
        anyMap.put("anyOf", anyStringList);
        LinkedHashMap patternMap = new LinkedHashMap();
        patternMap.put("^.*$", anyMap);
        LinkedHashMap<String, Object> cptSchemaMap = new LinkedHashMap<String, Object>();
        cptSchemaMap.put("$schema", "http://json-schema.org/draft-04/schema#");
        cptSchemaMap.put("type", "object");
        cptSchemaMap.put("title", "Unformatted CPT");
        cptSchemaMap.put("description", "Universal unformatted CPT template");
        cptSchemaMap.put("patternProperties", patternMap);
        return DataToolUtils.objToJsonStrWithNoPretty(cptSchemaMap);
    }

    public static synchronized String byte32ListToString(List<byte[]> bytesList, int size) {
        if (bytesList.isEmpty()) {
            return "";
        }
        int zeroCount = 0;
        for (int i = 0; i < bytesList.size(); ++i) {
            for (int j = 0; j < bytesList.get(i).length; ++j) {
                if (bytesList.get(i)[j] != 0) continue;
                ++zeroCount;
            }
        }
        if (WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH * size - zeroCount == 0) {
            return "";
        }
        byte[] newByte = new byte[WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH * size - zeroCount];
        int index = 0;
        for (int i = 0; i < bytesList.size(); ++i) {
            for (int j = 0; j < bytesList.get(i).length; ++j) {
                if (bytesList.get(i)[j] == 0) continue;
                newByte[index] = bytesList.get(i)[j];
                ++index;
            }
        }
        return new String(newByte).toString();
    }

    public static List<BigInteger> getParamCreatedList(int length) {
        long created = DateUtils.getNoMillisecondTimeStamp();
        ArrayList<BigInteger> createdList = new ArrayList<BigInteger>();
        createdList.add(BigInteger.valueOf(created));
        return createdList;
    }

    public static String convertTimestampToUtc(String jsonString) {
        String timestampToUtcString;
        try {
            timestampToUtcString = DataToolUtils.dealObjectOfConvertUtcAndLong(JSONObject.parseObject((String)jsonString), CONVERT_UTC_LONG_KEYLIST, TO_JSON).toString();
        }
        catch (JSONException | ParseException e) {
            logger.error("replaceJsonObj exception.", e);
            throw new DataTypeCastException(e);
        }
        return timestampToUtcString;
    }

    public static String convertUtcToTimestamp(String jsonString) {
        String utcToTimestampString;
        try {
            utcToTimestampString = DataToolUtils.dealObjectOfConvertUtcAndLong(JSONObject.parseObject((String)jsonString), CONVERT_UTC_LONG_KEYLIST, FROM_JSON).toString();
        }
        catch (JSONException | ParseException e) {
            logger.error("replaceJsonObj exception.", e);
            throw new DataTypeCastException(e);
        }
        return utcToTimestampString;
    }

    private static JSONObject dealObjectOfConvertUtcAndLong(JSONObject jsonObj, List<String> list, String type) throws ParseException {
        JSONObject resJson = new JSONObject();
        Set keySet = jsonObj.keySet();
        for (String key : keySet) {
            Object obj = jsonObj.get((Object)key);
            if (obj instanceof JSONObject) {
                if (key.equals(KEY_CLAIM)) {
                    resJson.put(key, obj);
                    continue;
                }
                resJson.put(key, (Object)DataToolUtils.dealObjectOfConvertUtcAndLong((JSONObject)obj, list, type));
                continue;
            }
            if (obj instanceof JSONArray) {
                resJson.put(key, (Object)DataToolUtils.dealArrayOfConvertUtcAndLong((JSONArray)obj, list, type));
                continue;
            }
            if (list.contains(key)) {
                if (TO_JSON.equals(type)) {
                    if (DataToolUtils.isValidLongString(String.valueOf(obj))) {
                        resJson.put(key, (Object)DateUtils.convertNoMillisecondTimestampToUtc(Long.parseLong(String.valueOf(obj))));
                        continue;
                    }
                    resJson.put(key, obj);
                    continue;
                }
                if (DateUtils.isValidDateString(String.valueOf(obj))) {
                    resJson.put(key, (Object)DateUtils.convertUtcDateToNoMillisecondTime(String.valueOf(obj)));
                    continue;
                }
                resJson.put(key, obj);
                continue;
            }
            resJson.put(key, obj);
        }
        return resJson;
    }

    private static JSONArray dealArrayOfConvertUtcAndLong(JSONArray jsonArr, List<String> list, String type) throws ParseException {
        JSONArray resJson = new JSONArray();
        for (int i = 0; i < jsonArr.size(); ++i) {
            Object jsonObj = jsonArr.get(i);
            if (jsonObj instanceof JSONObject) {
                resJson.add((Object)DataToolUtils.dealObjectOfConvertUtcAndLong((JSONObject)jsonObj, list, type));
                continue;
            }
            resJson.add(jsonObj);
        }
        return resJson;
    }

    public static boolean isValidLongString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        long result = 0L;
        int i = 0;
        int len = str.length();
        long limit = -9223372036854775807L;
        char firstChar = str.charAt(0);
        if (firstChar <= '0') {
            return false;
        }
        long multmin = limit / 10L;
        while (i < len) {
            int digit;
            if ((digit = Character.digit(str.charAt(i++), 10)) < 0) {
                return false;
            }
            if (result < multmin) {
                return false;
            }
            if ((result *= 10L) < limit + (long)digit) {
                return false;
            }
            result -= (long)digit;
        }
        return true;
    }

    public static boolean isValidFromToJson(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            logger.error("input json param is null.");
            return false;
        }
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject((String)json);
        }
        catch (JSONException e) {
            logger.error("convert jsonString to JSONObject failed." + (Object)((Object)e));
            return false;
        }
        return jsonObject.containsKey((Object)KEY_FROM_TOJSON);
    }

    public static String addTagFromToJson(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (!jsonObject.containsKey((Object)KEY_FROM_TOJSON)) {
            jsonObject.fluentPut(KEY_FROM_TOJSON, (Object)TO_JSON);
        }
        return jsonObject.toString();
    }

    public static String removeTagFromToJson(String json) {
        JSONObject jsonObject = JSONObject.parseObject((String)json);
        if (jsonObject.containsKey((Object)KEY_FROM_TOJSON)) {
            jsonObject.fluentRemove((Object)KEY_FROM_TOJSON);
        }
        return jsonObject.toString();
    }

    static {
        OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
        OBJECT_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.SETTER, JsonAutoDetect.Visibility.NONE);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        OBJECT_WRITER_UN_PRETTY_PRINTER = OBJECT_MAPPER.writer();
        CONVERT_UTC_LONG_KEYLIST.add(KEY_CREATED);
        CONVERT_UTC_LONG_KEYLIST.add(KEY_ISSUANCEDATE);
        CONVERT_UTC_LONG_KEYLIST.add(KEY_EXPIRATIONDATE);
    }
}

