/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static String TIME_ZONE = "Asia/Shanghai";
    private static String STRING_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static String UTC_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static String getTimestamp(Date date) {
        return DateUtils.getDefaultDateFormat().format(date);
    }

    public static String getTimestamp(long date) {
        return DateUtils.getDefaultDateFormat().format(date);
    }

    private static DateFormat getDefaultDateFormat() {
        TimeZone tz = TimeZone.getTimeZone("Asia/Shanghai");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(tz);
        return df;
    }

    private static DateTimeFormatter getDefaultDateTimeFormatter() {
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern(UTC_DATE_FORMAT);
        return ftf.withZone(ZoneId.of(TIME_ZONE));
    }

    public static Date convertStringToDate(String dateString) throws ParseException {
        return DateUtils.getDefaultDateFormat().parse(dateString);
    }

    public static Date convertLongStringToDate(String dateString) throws ParseException {
        return new Date(Long.parseLong(dateString));
    }

    public static long converDateToTimeStamp(String time) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STRING_DATE_FORMAT);
        Date date = simpleDateFormat.parse(time);
        long ts = date.getTime();
        return ts;
    }

    public static Long convertUtcDateToTimeStamp(String time) throws ParseException {
        DateFormat simpleDateFormat = DateUtils.getDefaultDateFormat();
        Date date = simpleDateFormat.parse(time);
        return date.getTime();
    }

    public static Long convertUtcDateToNoMillisecondTime(String time) {
        DateTimeFormatter dtf = DateUtils.getDefaultDateTimeFormatter();
        LocalDateTime date = LocalDateTime.parse(time, dtf);
        return date.toInstant(ZoneOffset.of("+8")).getEpochSecond();
    }

    public static boolean isValidDateString(String dateString) {
        try {
            DateFormat df = DateUtils.getDefaultDateFormat();
            df.setLenient(false);
            df.parse(dateString);
            return true;
        }
        catch (ParseException parseEx) {
            return false;
        }
    }

    public static String convertTimestampToUtc(Long date) {
        DateFormat df = DateUtils.getDefaultDateFormat();
        df.setLenient(false);
        return df.format(new Date(date));
    }

    public static String convertNoMillisecondTimestampToUtc(Long date) {
        if (String.valueOf(date) != null && String.valueOf(date).length() == DateUtils.getNoMillisecondTimeStampString().length()) {
            DateTimeFormatter dtf = DateUtils.getDefaultDateTimeFormatter();
            return dtf.format(LocalDateTime.ofInstant(Instant.ofEpochSecond(date), ZoneId.of(TIME_ZONE)));
        }
        logger.error("the timestamp is illegal.");
        return null;
    }

    public static Int256 getCurrentTimeStampInt256() {
        return new Int256(System.currentTimeMillis());
    }

    public static Int256 getNoMillisecondTimeStampInt256() {
        return new Int256(DateUtils.getNoMillisecondTimeStamp().longValue());
    }

    public static String getCurrentTimeStampString() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static Long getCurrentTimeStamp() {
        return System.currentTimeMillis();
    }

    public static Long getNoMillisecondTimeStamp() {
        return Instant.now().getEpochSecond();
    }

    public static String getNoMillisecondTimeStampString() {
        return String.valueOf(Instant.now().getEpochSecond());
    }

    public static boolean isAfterCurrentTime(Long date) {
        if (String.valueOf(date) != null && String.valueOf(date).length() == DateUtils.getCurrentTimeStampString().length()) {
            return date > DateUtils.getCurrentTimeStamp();
        }
        if (String.valueOf(date) != null && String.valueOf(date).length() == DateUtils.getNoMillisecondTimeStampString().length()) {
            return date > DateUtils.getNoMillisecondTimeStamp();
        }
        return false;
    }

    public static Long convertToNoMillisecondTimeStamp(Long date) {
        if (String.valueOf(date) == null) {
            logger.error("the timestamp is null.");
            return null;
        }
        if (String.valueOf(date) != null && String.valueOf(date).length() != DateUtils.getCurrentTimeStampString().length()) {
            if (String.valueOf(date).length() == DateUtils.getNoMillisecondTimeStampString().length()) {
                return date;
            }
            logger.error("the timestamp is illegal.");
            return null;
        }
        DateTimeFormatter ftf = DateTimeFormatter.ofPattern(STRING_DATE_FORMAT);
        String time = ftf.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(date), ZoneId.of(TIME_ZONE)));
        LocalDateTime parse = LocalDateTime.parse(time, ftf);
        return LocalDateTime.from(parse).atZone(ZoneId.of(TIME_ZONE)).toInstant().getEpochSecond();
    }
}

