/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);
    private static final String WEIDENTITY_PROP_NAME = "weidentity.properties";
    private static final String FISCO_PROP_NAME = "fisco.properties";
    private static Properties prop = new Properties();

    private static void loadProperties(String filePath) throws IOException {
        InputStream in = PropertyUtils.class.getClassLoader().getResourceAsStream(filePath);
        prop.load(in);
        in.close();
    }

    public static String getProperty(String key) {
        return prop.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return prop.getProperty(key, defaultValue);
    }

    static {
        try {
            PropertyUtils.loadProperties(WEIDENTITY_PROP_NAME);
            PropertyUtils.loadProperties(FISCO_PROP_NAME);
        }
        catch (IOException e) {
            logger.error("[PropertyUtils] Load weidentity.properties file failed.", (Throwable)e);
        }
    }
}

