/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webank.weid.config.FiscoConfig;
import com.webank.weid.constant.ErrorCode;
import com.webank.weid.constant.WeIdConstant;
import com.webank.weid.protocol.base.CptBaseInfo;
import com.webank.weid.protocol.response.ResponseData;
import com.webank.weid.protocol.response.RsvSignature;
import com.webank.weid.protocol.response.TransactionInfo;
import com.webank.weid.service.BaseService;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.DateUtils;
import com.webank.weid.util.PropertyUtils;
import com.webank.weid.util.WeIdUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bcos.channel.client.Service;
import org.bcos.channel.handler.ChannelConnections;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.abi.datatypes.DynamicBytes;
import org.bcos.web3j.abi.datatypes.StaticArray;
import org.bcos.web3j.abi.datatypes.Type;
import org.bcos.web3j.abi.datatypes.generated.Bytes32;
import org.bcos.web3j.abi.datatypes.generated.Int256;
import org.bcos.web3j.abi.datatypes.generated.Uint256;
import org.bcos.web3j.protocol.Web3j;
import org.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.bcos.web3j.protocol.core.DefaultBlockParameterNumber;
import org.bcos.web3j.protocol.core.methods.response.EthBlock;
import org.bcos.web3j.protocol.core.methods.response.EthBlockNumber;
import org.bcos.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.bcos.web3j.protocol.core.methods.response.EthSendTransaction;
import org.bcos.web3j.protocol.core.methods.response.Transaction;
import org.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.bcos.web3j.protocol.exceptions.TransactionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class TransactionUtils {
    private static final Logger logger = LoggerFactory.getLogger(TransactionUtils.class);

    public static TransactionReceipt sendTransaction(Web3j web3j, String transactionHex) throws Exception {
        if (web3j == null || StringUtils.isEmpty((CharSequence)transactionHex)) {
            return null;
        }
        EthSendTransaction ethSendTransaction = (EthSendTransaction)web3j.ethSendRawTransaction(transactionHex).sendAsync().get(WeIdConstant.TRANSACTION_RECEIPT_TIMEOUT.intValue(), TimeUnit.SECONDS);
        if (ethSendTransaction.hasError()) {
            logger.error("Error processing transaction request: " + ethSendTransaction.getError().getMessage());
            return null;
        }
        Optional<TransactionReceipt> receiptOptional = TransactionUtils.getTransactionReceiptRequest(web3j, ethSendTransaction.getTransactionHash());
        int sumTime = 0;
        try {
            for (int i = 0; i < WeIdConstant.POLL_TRANSACTION_ATTEMPTS; ++i) {
                if (!receiptOptional.isPresent()) {
                    Thread.sleep(WeIdConstant.POLL_TRANSACTION_SLEEP_DURATION.intValue());
                    sumTime += WeIdConstant.POLL_TRANSACTION_SLEEP_DURATION.intValue();
                } else {
                    return receiptOptional.get();
                }
                receiptOptional = TransactionUtils.getTransactionReceiptRequest(web3j, ethSendTransaction.getTransactionHash());
            }
        }
        catch (Exception e) {
            throw new TransactionTimeoutException("Transaction receipt was not generated after " + sumTime / 1000 + " seconds for transaction: " + ethSendTransaction);
        }
        return null;
    }

    public static BigInteger getBlockLimit() {
        try {
            return ((EthBlockNumber)((Web3j)BaseService.getWeb3j()).ethBlockNumber().send()).getBlockNumber().add(new BigInteger(String.valueOf(WeIdConstant.ADDITIVE_BLOCK_HEIGHT)));
        }
        catch (Exception e) {
            return new BigInteger("9999999999");
        }
    }

    public static ResponseData<List<Type>> buildCreateWeIdInputParameters(String inputParam) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode inputParamNode = objectMapper.readTree(inputParam);
        JsonNode publicKeyNode = inputParamNode.get("publicKey");
        if (publicKeyNode == null) {
            return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
        }
        String publicKey = publicKeyNode.textValue();
        if (StringUtils.isEmpty((CharSequence)publicKey)) {
            logger.error("[createWeId]: input parameter publickey is null.");
            return new ResponseData<Object>(null, ErrorCode.WEID_PUBLICKEY_INVALID);
        }
        String weId = WeIdUtils.convertPublicKeyToWeId(publicKey);
        String addr = WeIdUtils.convertWeIdToAddress(weId);
        if (!WeIdUtils.isValidAddress(addr)) {
            logger.error("[createWeId]: input parameter publickey is invalid.");
            return new ResponseData<Object>(null, ErrorCode.WEID_PUBLICKEY_INVALID);
        }
        List<Type> result = Arrays.asList(new Address(addr), DataToolUtils.stringToBytes32("created"), DataToolUtils.stringToDynamicBytes(DateUtils.getNoMillisecondTimeStampString()), DateUtils.getNoMillisecondTimeStampInt256());
        return new ResponseData<List<Type>>(result, ErrorCode.SUCCESS);
    }

    public static ResponseData<List<Type>> buildAuthorityIssuerInputParameters(String inputParam) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode inputParamNode = objectMapper.readTree(inputParam);
        JsonNode weIdNode = inputParamNode.get("weId");
        JsonNode nameNode = inputParamNode.get("name");
        if (weIdNode == null || nameNode == null) {
            return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
        }
        String weId = weIdNode.textValue();
        if (!WeIdUtils.isWeIdValid(weId)) {
            return new ResponseData<Object>(null, ErrorCode.WEID_DOES_NOT_EXIST);
        }
        String name = nameNode.textValue();
        if (StringUtils.isEmpty((CharSequence)name) || name.length() > WeIdConstant.MAX_AUTHORITY_ISSUER_NAME_LENGTH) {
            logger.error("Input cpt publisher : {} is invalid.", (Object)name);
            return new ResponseData<Object>(null, ErrorCode.AUTHORITY_ISSUER_NAME_ILLEGAL);
        }
        List<Type> result = Arrays.asList(new Address(WeIdUtils.convertWeIdToAddress(weId)), TransactionUtils.getParamName(name), TransactionUtils.getParamCreated(WeIdConstant.AUTHORITY_ISSUER_ARRAY_LEGNTH), TransactionUtils.getDefaultAccValue());
        return new ResponseData<List<Type>>(result, ErrorCode.SUCCESS);
    }

    private static StaticArray<Bytes32> getParamName(String name) {
        String[] nameArray = new String[WeIdConstant.AUTHORITY_ISSUER_ARRAY_LEGNTH.intValue()];
        nameArray[0] = name;
        return DataToolUtils.stringArrayToBytes32StaticArray(nameArray);
    }

    private static DynamicBytes getDefaultAccValue() {
        String defaultAccValue = "1";
        DynamicBytes accValue = new DynamicBytes(defaultAccValue.getBytes(StandardCharsets.UTF_8));
        return accValue;
    }

    public static ResponseData<List<Type>> buildRegisterCptInputParameters(String inputParam) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode inputParamNode = objectMapper.readTree(inputParam);
        JsonNode weIdNode = inputParamNode.get("weId");
        JsonNode cptJsonSchemaNode = inputParamNode.get("cptJsonSchema");
        JsonNode cptSignatureNode = inputParamNode.get("cptSignature");
        if (weIdNode == null || cptJsonSchemaNode == null || cptSignatureNode == null) {
            return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
        }
        String weId = weIdNode.textValue();
        if (!WeIdUtils.isWeIdValid(weId)) {
            return new ResponseData<Object>(null, ErrorCode.WEID_DOES_NOT_EXIST);
        }
        String cptJsonSchema = cptJsonSchemaNode.toString();
        String cptJsonSchemaNew = TransactionUtils.complementCptJsonSchema(cptJsonSchema);
        Map cptJsonSchemaMap = DataToolUtils.deserialize(cptJsonSchemaNew, HashMap.class);
        if (StringUtils.isEmpty((CharSequence)cptJsonSchemaNew) || !DataToolUtils.isCptJsonSchemaValid(cptJsonSchemaNew)) {
            logger.error("Input cpt json schema : {} is invalid.", (Object)cptJsonSchemaNew);
            return new ResponseData<Object>(null, ErrorCode.CPT_JSON_SCHEMA_INVALID);
        }
        String cptSignature = cptSignatureNode.textValue();
        if (!DataToolUtils.isValidBase64String(cptSignature)) {
            logger.error("Input cpt signature invalid: {}", (Object)cptSignature);
            return new ResponseData<Object>(null, ErrorCode.ILLEGAL_INPUT);
        }
        RsvSignature rsvSignature = DataToolUtils.convertSignatureDataToRsv(DataToolUtils.convertBase64StringToSignatureData(cptSignature));
        StaticArray<Bytes32> bytes32Array = DataToolUtils.stringArrayToBytes32StaticArray(new String[WeIdConstant.CPT_STRING_ARRAY_LENGTH.intValue()]);
        List<Type> result = Arrays.asList(new Address(WeIdUtils.convertWeIdToAddress(weId)), TransactionUtils.getParamCreated(WeIdConstant.CPT_LONG_ARRAY_LENGTH), bytes32Array, TransactionUtils.getParamJsonSchema(cptJsonSchemaNew), rsvSignature.getV(), rsvSignature.getR(), rsvSignature.getS());
        return new ResponseData<List<Type>>(result, ErrorCode.SUCCESS);
    }

    public static String complementCptJsonSchema(String cptJsonSchemaOld) {
        try {
            Map cptJsonSchemaMapOld = DataToolUtils.deserialize(cptJsonSchemaOld, HashMap.class);
            HashMap<String, String> cptJsonSchemaMapNew = new HashMap<String, String>();
            cptJsonSchemaMapNew.put("$schema", "http://json-schema.org/draft-04/schema#");
            cptJsonSchemaMapNew.put("type", "object");
            cptJsonSchemaMapNew.putAll(cptJsonSchemaMapOld);
            return DataToolUtils.serialize(cptJsonSchemaMapNew);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static StaticArray<Int256> getParamCreated(int length) {
        long created;
        long[] longArray = new long[length];
        longArray[1] = created = DateUtils.getNoMillisecondTimeStamp().longValue();
        return DataToolUtils.longArrayToInt256StaticArray(longArray);
    }

    public static StaticArray<Int256> getParamUpdated(int length) {
        long created;
        long[] longArray = new long[length];
        longArray[2] = created = DateUtils.getNoMillisecondTimeStamp().longValue();
        return DataToolUtils.longArrayToInt256StaticArray(longArray);
    }

    public static StaticArray<Bytes32> getParamJsonSchema(String cptJsonSchema) {
        List<byte[]> bytes = DataToolUtils.stringToByte32ArrayList(cptJsonSchema, WeIdConstant.JSON_SCHEMA_ARRAY_LENGTH);
        return DataToolUtils.byteArrayListToBytes32StaticArray(bytes);
    }

    private static Optional<TransactionReceipt> getTransactionReceiptRequest(Web3j web3j, String transactionHash) throws Exception {
        EthGetTransactionReceipt transactionReceipt = (EthGetTransactionReceipt)web3j.ethGetTransactionReceipt(transactionHash).send();
        if (transactionReceipt.hasError()) {
            logger.error("Error processing transaction request: " + transactionReceipt.getError().getMessage());
            return Optional.empty();
        }
        return transactionReceipt.getTransactionReceipt();
    }

    public static BigInteger getNonce() {
        SecureRandom r = new SecureRandom();
        return new BigInteger(250, r);
    }

    public static ResponseData<CptBaseInfo> getResultByResolveEvent(Uint256 retCode, Uint256 cptId, Int256 cptVersion, TransactionReceipt receipt) {
        TransactionInfo info = new TransactionInfo(receipt);
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_ID_AUTHORITY_ISSUER_EXCEED_MAX.getCode()) {
            logger.error("[getResultByResolveEvent] cptId limited max value. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_ID_AUTHORITY_ISSUER_EXCEED_MAX, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_ALREADY_EXIST.getCode()) {
            logger.error("[getResultByResolveEvent] cpt already exists on chain. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_ALREADY_EXIST, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_NO_PERMISSION.getCode()) {
            logger.error("[getResultByResolveEvent] no permission. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_NO_PERMISSION, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_PUBLISHER_NOT_EXIST.getCode()) {
            logger.error("[getResultByResolveEvent] publisher does not exist. cptId:{}", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_PUBLISHER_NOT_EXIST, info);
        }
        if (DataToolUtils.uint256ToInt(retCode) == ErrorCode.CPT_NOT_EXISTS.getCode()) {
            logger.error("[getResultByResolveEvent] cpt id : {} does not exist.", (Object)DataToolUtils.uint256ToInt(cptId));
            return new ResponseData<Object>(null, ErrorCode.CPT_NOT_EXISTS, info);
        }
        CptBaseInfo result = new CptBaseInfo();
        result.setCptId(DataToolUtils.uint256ToInt(cptId));
        result.setCptVersion(DataToolUtils.int256ToInt(cptVersion));
        return new ResponseData<CptBaseInfo>(result, ErrorCode.SUCCESS, info);
    }

    public static ResponseData<CptBaseInfo> getResultByResolveEvent(BigInteger retCode, BigInteger cptId, BigInteger cptVersion, org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt receipt) {
        TransactionInfo info = new TransactionInfo(receipt);
        if (retCode.intValue() == ErrorCode.CPT_ID_AUTHORITY_ISSUER_EXCEED_MAX.getCode()) {
            logger.error("[getResultByResolveEvent] cptId limited max value. cptId:{}", (Object)retCode.intValue());
            return new ResponseData<Object>(null, ErrorCode.CPT_ID_AUTHORITY_ISSUER_EXCEED_MAX, info);
        }
        if (retCode.intValue() == ErrorCode.CPT_ALREADY_EXIST.getCode()) {
            logger.error("[getResultByResolveEvent] cpt already exists on chain. cptId:{}", (Object)cptId.intValue());
            return new ResponseData<Object>(null, ErrorCode.CPT_ALREADY_EXIST, info);
        }
        if (retCode.intValue() == ErrorCode.CPT_NO_PERMISSION.getCode()) {
            logger.error("[getResultByResolveEvent] no permission. cptId:{}", (Object)cptId.intValue());
            return new ResponseData<Object>(null, ErrorCode.CPT_NO_PERMISSION, info);
        }
        if (retCode.intValue() == ErrorCode.CPT_PUBLISHER_NOT_EXIST.getCode()) {
            logger.error("[getResultByResolveEvent] publisher does not exist. cptId:{}", (Object)cptId.intValue());
            return new ResponseData<Object>(null, ErrorCode.CPT_PUBLISHER_NOT_EXIST, info);
        }
        if (retCode.intValue() == ErrorCode.CPT_NOT_EXISTS.getCode()) {
            logger.error("[getResultByResolveEvent] cpt id : {} does not exist.", (Object)cptId.intValue());
            return new ResponseData<Object>(null, ErrorCode.CPT_NOT_EXISTS, info);
        }
        CptBaseInfo result = new CptBaseInfo();
        result.setCptId(cptId.intValue());
        result.setCptVersion(cptVersion.intValue());
        ResponseData<CptBaseInfo> responseData = new ResponseData<CptBaseInfo>(result, ErrorCode.SUCCESS, info);
        return responseData;
    }

    public static Transaction getTransaction(TransactionInfo info) {
        List<Transaction> transactionList;
        if (info == null) {
            return null;
        }
        Web3j web3j = (Web3j)BaseService.getWeb3j();
        EthBlock ethBlock = null;
        BigInteger blockNumber = info.getBlockNumber();
        try {
            ethBlock = (EthBlock)web3j.ethGetBlockByNumber((DefaultBlockParameter)new DefaultBlockParameterNumber(blockNumber), true).send();
        }
        catch (IOException e) {
            logger.error("Cannot get a block with number: {}. Error: {}", (Object)blockNumber, (Object)e);
        }
        if (ethBlock == null) {
            logger.error("Block number {} is null", (Object)blockNumber);
            return null;
        }
        try {
            transactionList = TransactionUtils.getTransactionListFromBlock(ethBlock);
        }
        catch (Exception e) {
            logger.error("Error occurred during getting transaction list with block number: {}. Error: {}", (Object)blockNumber, (Object)e);
            return null;
        }
        if (transactionList.size() == 0) {
            logger.error("Cannot get any transaction with block number: {}", (Object)blockNumber);
            return null;
        }
        return TransactionUtils.getTransactionFromList(transactionList, info);
    }

    public static Service buildFiscoBcosService(FiscoConfig fiscoConfig) {
        if (!fiscoConfig.getVersion().startsWith("1")) {
            logger.error("Only 1.x version FISCO-BCOS chain configurations are allowed. Abort.");
            return null;
        }
        String currentOrgId = PropertyUtils.getProperty("blockchain.orgid");
        Service service = new Service();
        service.setOrgID(currentOrgId);
        service.setConnectSeconds(Integer.valueOf(fiscoConfig.getWeb3sdkTimeout()));
        ChannelConnections channelConnections = new ChannelConnections();
        channelConnections.setCaCertPath("classpath:" + fiscoConfig.getV1CaCrtPath());
        channelConnections.setClientCertPassWord(fiscoConfig.getV1ClientCrtPassword());
        channelConnections.setClientKeystorePath("classpath:" + fiscoConfig.getV1ClientKeyStorePath());
        channelConnections.setKeystorePassWord(fiscoConfig.getV1KeyStorePassword());
        channelConnections.setConnectionsStr(Arrays.asList(fiscoConfig.getNodes().split(",")));
        ConcurrentHashMap<String, ChannelConnections> allChannelConnections = new ConcurrentHashMap<String, ChannelConnections>();
        allChannelConnections.put(currentOrgId, channelConnections);
        service.setAllChannelConnections(allChannelConnections);
        ThreadPoolTaskExecutor pool = new ThreadPoolTaskExecutor();
        pool.setBeanName("web3sdk");
        pool.setCorePoolSize(Integer.valueOf(fiscoConfig.getWeb3sdkCorePoolSize()).intValue());
        pool.setMaxPoolSize(Integer.valueOf(fiscoConfig.getWeb3sdkMaxPoolSize()).intValue());
        pool.setQueueCapacity(Integer.valueOf(fiscoConfig.getWeb3sdkQueueSize()).intValue());
        pool.setKeepAliveSeconds(Integer.valueOf(fiscoConfig.getWeb3sdkKeepAliveSeconds()).intValue());
        pool.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        pool.initialize();
        service.setThreadPool(pool);
        return service;
    }

    private static List<Transaction> getTransactionListFromBlock(EthBlock ethBlock) {
        return ethBlock.getBlock().getTransactions().stream().map(transactionResult -> (Transaction)transactionResult.get()).collect(Collectors.toList());
    }

    private static Transaction getTransactionFromList(List<Transaction> transactionList, TransactionInfo info) {
        for (Transaction transaction : transactionList) {
            if (!transaction.getHash().equalsIgnoreCase(info.getTransactionHash()) || transaction.getTransactionIndex().longValue() != info.getTransactionIndex().longValue()) continue;
            return transaction;
        }
        return null;
    }
}

