/*
 * Decompiled with CFR 0.152.
 */
package com.webank.weid.util;

import com.webank.weid.exception.WeIdBaseException;
import com.webank.weid.protocol.base.WeIdPrivateKey;
import com.webank.weid.util.DataToolUtils;
import com.webank.weid.util.PropertyUtils;
import java.math.BigInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.bcos.web3j.abi.datatypes.Address;
import org.bcos.web3j.crypto.ECKeyPair;
import org.bcos.web3j.crypto.Keys;
import org.bcos.web3j.crypto.WalletUtils;
import org.fisco.bcos.web3j.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeIdUtils {
    private static final Logger logger = LoggerFactory.getLogger(WeIdUtils.class);
    private static final String CHAIN_ID = PropertyUtils.getProperty("chain.id");

    public static String convertWeIdToAddress(String weId) {
        if (StringUtils.isEmpty((CharSequence)weId) || !StringUtils.contains((CharSequence)weId, (CharSequence)"did:weid:")) {
            return "";
        }
        String[] weIdFields = StringUtils.splitByWholeSeparator((String)weId, (String)":");
        return weIdFields[weIdFields.length - 1];
    }

    public static String convertAddressToWeId(String address) {
        if (StringUtils.isEmpty((CharSequence)address)) {
            return "";
        }
        return WeIdUtils.buildWeIdByAddress(address);
    }

    public static boolean isWeIdValid(String weId) {
        return StringUtils.isNotEmpty((CharSequence)weId) && StringUtils.startsWith((CharSequence)weId, (CharSequence)"did:weid:") && WeIdUtils.isMatchTheChainId(weId) && WeIdUtils.isValidAddress(WeIdUtils.convertWeIdToAddress(weId));
    }

    public static String convertPublicKeyToWeId(String publicKey) {
        try {
            String address = Keys.getAddress((BigInteger)new BigInteger(publicKey));
            return WeIdUtils.buildWeIdByAddress(address);
        }
        catch (Exception e) {
            logger.error("convert publicKey to weId error.", (Throwable)e);
            return "";
        }
    }

    private static String buildWeIdByAddress(String address) {
        if (StringUtils.isEmpty((CharSequence)CHAIN_ID)) {
            throw new WeIdBaseException("the chain Id is illegal.");
        }
        StringBuffer weId = new StringBuffer();
        weId.append("did:weid:").append(CHAIN_ID).append(":");
        if (!StringUtils.contains((CharSequence)address, (CharSequence)"0x")) {
            weId.append("0x");
        }
        weId.append(address);
        return weId.toString();
    }

    public static boolean isPrivateKeyValid(WeIdPrivateKey weIdPrivateKey) {
        return null != weIdPrivateKey && StringUtils.isNotEmpty((CharSequence)weIdPrivateKey.getPrivateKey()) && NumberUtils.isDigits((String)weIdPrivateKey.getPrivateKey()) && new BigInteger(weIdPrivateKey.getPrivateKey()).compareTo(BigInteger.ZERO) > 0;
    }

    public static boolean isKeypairMatch(String privateKey, String publicKey) {
        try {
            ECKeyPair keyPair = ECKeyPair.create((BigInteger)new BigInteger(privateKey));
            return StringUtils.equals((CharSequence)String.valueOf(keyPair.getPublicKey()), (CharSequence)publicKey);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidAddress(String addr) {
        if (StringUtils.isEmpty((CharSequence)addr) || !Pattern.compile("0x[a-fA-f0-9]{40}").matcher(addr).matches()) {
            return false;
        }
        try {
            return WalletUtils.isValidAddress((String)addr);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isMatchTheChainId(String weId) {
        String[] weIdFields = StringUtils.splitByWholeSeparator((String)weId, (String)":");
        if (weIdFields.length == 4) {
            return weIdFields[2].equals(CHAIN_ID);
        }
        return true;
    }

    public static boolean isEmptyAddress(Address addr) {
        return addr.getValue().equals(BigInteger.ZERO);
    }

    public static boolean isEmptyAddress(org.fisco.bcos.web3j.abi.datatypes.Address addr) {
        return addr.getValue().equals(BigInteger.ZERO);
    }

    public static boolean isEmptyStringAddress(String addr) {
        return Numeric.toBigInt((String)addr).equals(BigInteger.ZERO);
    }

    public static boolean validatePrivateKeyWeIdMatches(WeIdPrivateKey privateKey, String weId) {
        boolean isMatch = false;
        try {
            BigInteger publicKey = DataToolUtils.publicKeyFromPrivate(new BigInteger(privateKey.getPrivateKey()));
            String address1 = "0x" + Keys.getAddress((BigInteger)publicKey);
            String address2 = WeIdUtils.convertWeIdToAddress(weId);
            if (address1.equals(address2)) {
                isMatch = true;
            }
        }
        catch (Exception e) {
            logger.error("Validate private key We Id matches failed. Error message :{}", (Throwable)e);
            return isMatch;
        }
        return isMatch;
    }
}

