/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.auth.signer;

import com.webullpay.openapi.auth.signer.SignAlgorithm;
import com.webullpay.openapi.auth.signer.Signer;
import com.webullpay.openapi.execption.ClientException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class HmacSHA1Signer
implements Signer {
    private static final String ALGORITHM = "HmacSHA1";
    private static final String VERSION = "1.0";

    @Override
    public String getSign(String source, String secret) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), ALGORITHM));
            byte[] signData = mac.doFinal(source.getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printBase64Binary((byte[])signData);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ClientException("InvalidCredential", e);
        }
    }

    @Override
    public String signerName() {
        return SignAlgorithm.HMAC_SHA1.getSignerName();
    }

    @Override
    public String signerVersion() {
        return VERSION;
    }
}

