/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.auth.signer;

import com.webullpay.openapi.auth.signer.SignAlgorithm;
import com.webullpay.openapi.auth.signer.Signer;
import com.webullpay.openapi.execption.ClientException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.xml.bind.DatatypeConverter;

public class SHA256withRSASigner
implements Signer {
    private static final String ALGORITHM = "RSA";
    private static final String VERSION = "1.0";

    @Override
    public String getSign(String source, String secret) {
        try {
            Signature rsaSign = Signature.getInstance(SignAlgorithm.SHA256_WITH_RSA.getSignerName());
            KeyFactory kf = KeyFactory.getInstance(ALGORITHM);
            byte[] keySpec = DatatypeConverter.parseBase64Binary((String)secret);
            PrivateKey privateKey = kf.generatePrivate(new PKCS8EncodedKeySpec(keySpec));
            rsaSign.initSign(privateKey);
            rsaSign.update(source.getBytes(StandardCharsets.UTF_8));
            byte[] sign = rsaSign.sign();
            return DatatypeConverter.printBase64Binary((byte[])sign);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException | InvalidKeySpecException e) {
            throw new ClientException("InvalidCredential", e);
        }
    }

    @Override
    public String signerName() {
        return SignAlgorithm.SHA256_WITH_RSA.getSignerName();
    }

    @Override
    public String signerVersion() {
        return VERSION;
    }
}

