/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.endpoint;

import com.webullpay.openapi.common.ApiModule;
import com.webullpay.openapi.endpoint.EndpointResolver;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

class SettableEndpointResolver
implements EndpointResolver {
    private final Map<String, String> endpoints = new ConcurrentHashMap<String, String>();

    private SettableEndpointResolver() {
    }

    public static SettableEndpointResolver getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public void addEndpoint(String regionId, ApiModule apiModule, String endpoint) {
        String entryKey = this.getKey(regionId, apiModule);
        this.endpoints.put(entryKey, endpoint);
    }

    @Override
    public int order() {
        return 1;
    }

    @Override
    public Optional<String> resolve(String regionId, ApiModule apiModule) {
        String entryKey = this.getKey(regionId, apiModule);
        return Optional.ofNullable(this.endpoints.get(entryKey));
    }

    private String getKey(String regionId, ApiModule apiModule) {
        return regionId + "-" + apiModule.name();
    }

    private static class InstanceHolder {
        private static final SettableEndpointResolver instance = new SettableEndpointResolver();

        private InstanceHolder() {
        }
    }
}

