/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.http;

import com.webullpay.openapi.auth.composer.DefaultSignatureComposer;
import com.webullpay.openapi.config.ProjectReaderHelper;
import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.execption.ServerException;
import com.webullpay.openapi.http.HttpApiConfig;
import com.webullpay.openapi.http.HttpRequest;
import com.webullpay.openapi.http.HttpResponse;
import com.webullpay.openapi.http.RuntimeOptions;
import com.webullpay.openapi.http.okhttp.OkHttpClientPool;
import com.webullpay.openapi.http.okhttp.OkHttpRequestBuilder;
import com.webullpay.openapi.http.retry.DefaultHttpRetryCondition;
import com.webullpay.openapi.http.retry.HttpRetryContext;
import com.webullpay.openapi.http.retry.SynchronousHttpRetryable;
import com.webullpay.openapi.logger.Logger;
import com.webullpay.openapi.logger.LoggerFactory;
import com.webullpay.openapi.retry.RetriedFailedException;
import com.webullpay.openapi.retry.RetryPolicy;
import com.webullpay.openapi.retry.backoff.DefaultMixedBackoffStrategy;
import com.webullpay.openapi.serialize.JsonSerializer;
import com.webullpay.openapi.serialize.SerializeConfig;
import com.webullpay.openapi.utils.Assert;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpApiClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpApiClient.class);
    private final HttpApiConfig config;
    private final RetryPolicy retryPolicy;
    private final RuntimeOptions runtimeOptions;

    public HttpApiClient(HttpApiConfig config) {
        Assert.notNull("config", (Object)config);
        this.config = config;
        this.retryPolicy = this.config.getAutoRetry() ? new RetryPolicy(new DefaultHttpRetryCondition(this.config.getMaxRetries()), new DefaultMixedBackoffStrategy()) : RetryPolicy.never();
        this.runtimeOptions = config.getRuntimeOptions();
    }

    public HttpApiConfig getConfig() {
        return this.config;
    }

    public Action request(HttpRequest httpRequest) {
        return new Action(httpRequest);
    }

    public class Action {
        private final HttpRequest request;
        private Type responseType;
        private SerializeConfig serializeConfig = SerializeConfig.httpDefault();

        private Action(HttpRequest request) {
            Assert.notNull("request", (Object)request);
            this.request = request;
        }

        public Action responseType(Type responseType) {
            Assert.notNull("responseType", (Object)responseType);
            this.responseType = responseType;
            return this;
        }

        public Action serializeWith(SerializeConfig serializeConfig) {
            Assert.notNull("serializeConfig", (Object)serializeConfig);
            this.serializeConfig = serializeConfig;
            return this;
        }

        public <T> T doAction() {
            Assert.notNull("responseType", (Object)this.responseType);
            try (HttpResponse response = this.doRequest(this.request);){
                if (response.getException() != null) {
                    throw response.getException();
                }
                String responseStr = response.getResponseBody();
                if (logger.isTraceEnabled()) {
                    logger.trace("HTTP request uri={}, response body={}", this.request.getUri(), responseStr);
                }
                Object t = JsonSerializer.fromJson(responseStr, this.responseType, this.serializeConfig);
                return t;
            }
        }

        private HttpResponse doRequest(HttpRequest request) {
            HttpRetryContext retryContext;
            Assert.notNull("request", (Object)request);
            request.setEndpointIfAbsent(HttpApiClient.this.config.getEndpoint());
            request.setPortIfAbsent(HttpApiClient.this.config.getPort());
            Supplier<HttpResponse> singleRequest = () -> this.doSingleRequest(request);
            try {
                HttpResponse response = singleRequest.get();
                if (response.isSuccess()) {
                    return response;
                }
                retryContext = new HttpRetryContext(request.getUri(), request.getMethod(), response.getStatusCode(), 1, response.getException());
            }
            catch (Exception ex) {
                retryContext = new HttpRetryContext(request.getUri(), request.getMethod(), 400, 1, ex);
            }
            SynchronousHttpRetryable retryable = new SynchronousHttpRetryable(singleRequest, HttpApiClient.this.retryPolicy);
            try {
                return (HttpResponse)retryable.retry(retryContext);
            }
            catch (RetriedFailedException ex) {
                if (ex.getCause() instanceof ClientException) {
                    throw (ClientException)ex.getCause();
                }
                if (ex.getCause() instanceof ServerException) {
                    throw (ServerException)ex.getCause();
                }
                throw new ClientException("InvalidRequest", ex.getCause());
            }
        }

        private HttpResponse doSingleRequest(HttpRequest request) {
            String sign = DefaultSignatureComposer.getSign(request.getEndpoint(), HttpApiClient.this.config.getAppKey(), HttpApiClient.this.config.getAppSecret(), request);
            request.getHeaders().putIfAbsent("x-signature", sign);
            request.getHeaders().putIfAbsent("x-version", request.getVersion());
            try {
                URL url = new URL(request.getURL());
                RuntimeOptions options = request.getRuntimeOptions() != null ? request.getRuntimeOptions().parent(HttpApiClient.this.runtimeOptions) : HttpApiClient.this.runtimeOptions;
                OkHttpClient okHttpClient = OkHttpClientPool.get(url, options);
                Request okHttpRequest = OkHttpRequestBuilder.newRequest(request).url(url).header(request.getHeaders()).build();
                Response okHttpResponse = okHttpClient.newCall(okHttpRequest).execute();
                return new HttpResponse(okHttpResponse);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.error("Http request error, host:{}, SDK version:{}", request.getEndpoint(), ProjectReaderHelper.getClientSDKInfo(), e);
                }
                throw new ClientException("InvalidRequest", e);
            }
        }
    }
}

