/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.http;

import com.webullpay.openapi.auth.signer.SignAlgorithm;
import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.http.RuntimeOptions;
import com.webullpay.openapi.http.common.HttpMethod;
import com.webullpay.openapi.http.common.HttpProtocol;
import com.webullpay.openapi.serialize.JsonSerializer;
import com.webullpay.openapi.serialize.SerializeConfig;
import com.webullpay.openapi.utils.Assert;
import com.webullpay.openapi.utils.StringUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private String endpoint;
    private Integer port;
    private final String uri;
    private final String version;
    private final HttpMethod method;
    private final HttpProtocol protocol;
    private final SignAlgorithm signAlgorithm;
    private Map<String, String> headers;
    private Map<String, Object> query;
    private Object body;
    private String bodyString;
    private RuntimeOptions runtimeOptions;
    private static final String COLON = ":";
    private static final String QUERY_START = "?";
    private static final String QUERY_AND = "&";
    private static final String QUERY_EQUALS = "=";

    String setEndpointIfAbsent(String endpoint) {
        Assert.notBlank("endpoint", endpoint);
        if (StringUtils.isBlank(this.endpoint)) {
            this.endpoint = endpoint;
        }
        return this.endpoint;
    }

    Integer setPortIfAbsent(Integer port) {
        if (this.port == null) {
            this.port = port;
        }
        return this.port;
    }

    public HttpRequest(String requestUri, String version, HttpMethod httpMethod) {
        this(null, null, requestUri, version, httpMethod, HttpProtocol.HTTPS, SignAlgorithm.HMAC_SHA1);
    }

    public HttpRequest(String endpoint, String requestUri, String version, HttpMethod httpMethod) {
        this(endpoint, null, requestUri, version, httpMethod, HttpProtocol.HTTPS, SignAlgorithm.HMAC_SHA1);
    }

    public HttpRequest(String endpoint, Integer port, String requestUri, String version, HttpMethod method, HttpProtocol protocol, SignAlgorithm signAlgorithm) {
        this.endpoint = endpoint;
        this.port = port;
        this.uri = requestUri;
        this.version = version;
        this.method = method;
        this.protocol = protocol;
        this.signAlgorithm = signAlgorithm;
        this.headers = new HashMap<String, String>();
        this.query = new HashMap<String, Object>();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUri() {
        return this.uri;
    }

    public String getVersion() {
        return this.version;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpProtocol getProtocol() {
        return this.protocol;
    }

    public SignAlgorithm getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, Object> getQuery() {
        return this.query;
    }

    public Object getBody() {
        return this.body;
    }

    public String getBodyString() {
        return this.bodyString;
    }

    public RuntimeOptions getRuntimeOptions() {
        return this.runtimeOptions;
    }

    public void setHeaders(Map<String, String> headers) {
        Assert.notNull("headers", headers);
        this.headers = headers;
    }

    public void setQuery(Map<String, Object> query) {
        Assert.notNull("query", query);
        this.query = query;
    }

    public void setBody(Object body) {
        this.body = body;
        this.bodyString = JsonSerializer.toJson(this.body, SerializeConfig.httpDefault());
    }

    public void setRuntimeOptions(RuntimeOptions runtimeOptions) {
        this.runtimeOptions = runtimeOptions;
    }

    String getURL() {
        StringBuilder urlBuilder = new StringBuilder();
        this.buildUri(urlBuilder);
        this.appendQuery(urlBuilder, this.query);
        return urlBuilder.toString();
    }

    private void buildUri(StringBuilder urlBuilder) {
        HttpProtocol httpProtocol = this.protocol != null ? this.protocol : HttpProtocol.HTTPS;
        urlBuilder.append(httpProtocol.getPrefix());
        urlBuilder.append(this.endpoint);
        if (this.port != null) {
            urlBuilder.append(COLON).append(this.port);
        }
        if (this.uri != null) {
            urlBuilder.append(this.uri);
        }
    }

    private void appendQuery(StringBuilder urlBuilder, Map<String, Object> queries) {
        if (queries != null && queries.size() > 0) {
            if (urlBuilder.indexOf(QUERY_START) >= 1) {
                urlBuilder.append(QUERY_AND);
            } else {
                urlBuilder.append(QUERY_START);
            }
            try {
                for (Map.Entry<String, Object> entry : queries.entrySet()) {
                    String val;
                    String key = entry.getKey();
                    if (entry.getValue() == null || !StringUtils.isNotEmpty(val = String.valueOf(entry.getValue()))) continue;
                    urlBuilder.append(URLEncoder.encode(key, StandardCharsets.UTF_8.name()));
                    urlBuilder.append(QUERY_EQUALS);
                    urlBuilder.append(URLEncoder.encode(val, StandardCharsets.UTF_8.name()));
                    urlBuilder.append(QUERY_AND);
                }
            }
            catch (Exception e) {
                throw new ClientException("Parse URL error", e);
            }
            urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        }
    }

    public String toString() {
        return "HttpRequest{endpoint='" + this.endpoint + '\'' + ", port=" + this.port + ", uri='" + this.uri + '\'' + ", version='" + this.version + '\'' + ", method=" + (Object)((Object)this.method) + ", protocol=" + (Object)((Object)this.protocol) + ", signAlgorithm=" + (Object)((Object)this.signAlgorithm) + ", headers=" + this.headers + ", query=" + this.query + ", body=" + this.bodyString + ", runtimeOptions=" + this.runtimeOptions + '}';
    }
}

