/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.http;

import com.google.gson.reflect.TypeToken;
import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.http.exception.HttpServerException;
import com.webullpay.openapi.logger.Logger;
import com.webullpay.openapi.logger.LoggerFactory;
import com.webullpay.openapi.serialize.JsonSerializer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public class HttpResponse
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private HttpServerException exception;
    private final Response response;
    private final int statusCode;
    private final String statusMessage;
    private final String requestId;
    private final HashMap<String, String> headers = new HashMap();
    private final InputStream body;

    public HttpResponse(Response response) {
        this.response = response;
        this.statusCode = response.code();
        this.statusMessage = response.message();
        this.body = response.body() != null ? response.body().byteStream() : null;
        Map resultHeaders = response.headers().toMultimap();
        for (Map.Entry entry : resultHeaders.entrySet()) {
            this.headers.put((String)entry.getKey(), String.join((CharSequence)";", (Iterable)entry.getValue()));
        }
        this.requestId = this.headers.get("x-request-id");
        if (this.statusCode < 200 || this.statusCode >= 300) {
            String responseBody = this.getResponseBody();
            Map responseMap = new HashMap();
            try {
                responseMap = (Map)JsonSerializer.fromJson(responseBody, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (Exception e) {
                logger.warn("Failed to parse response as json format, response:{}, requestId:{}", responseBody, this.requestId);
            }
            String errorCode = null;
            String message = null;
            if (responseMap.containsKey("error_code")) {
                errorCode = responseMap.get("error_code").toString();
            }
            if (responseMap.containsKey("message")) {
                message = responseMap.get("message").toString();
            }
            if (errorCode == null || errorCode.isEmpty()) {
                errorCode = responseMap.getOrDefault("code", "UnknownServerError").toString();
            }
            if (message == null || message.isEmpty()) {
                message = responseMap.getOrDefault("msg", "").toString();
            }
            this.exception = new HttpServerException(errorCode, message, this.statusCode, this.requestId);
        }
    }

    public boolean isSuccess() {
        return this.getException() == null;
    }

    public HttpServerException getException() {
        return this.exception;
    }

    public InputStream getResponse() {
        return this.body;
    }

    public String getResponseBody() {
        if (this.body == null) {
            return String.format("{\"message\":\"%s\"}", this.statusMessage);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        try {
            int read;
            while ((read = this.body.read(buff)) != -1) {
                os.write(buff, 0, read);
            }
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
        return os.toString();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public void close() {
        this.response.close();
    }
}

