/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.http;

import com.webullpay.openapi.http.common.ProxyType;
import com.webullpay.openapi.utils.Assert;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class RuntimeOptions {
    private static final RuntimeOptions ROOT_DEFAULT = new RuntimeOptions(true).connectTimeout(5000L, TimeUnit.MILLISECONDS).readTimeout(10000L, TimeUnit.MILLISECONDS).maxIdleConn(5).ignoreSSL(false);
    private RuntimeOptions parent;
    private Long connectTimeoutMillis;
    private Long readTimeoutMillis;
    private Integer maxIdleConn;
    private Boolean ignoreSSL;
    private ProxyType proxyType;
    private String proxyAddress;

    public RuntimeOptions() {
        this(false);
    }

    private RuntimeOptions(boolean isRoot) {
        this.parent = isRoot ? null : ROOT_DEFAULT;
    }

    RuntimeOptions parent(RuntimeOptions parent) {
        Assert.notNull("parent", (Object)parent);
        this.parent = parent;
        return this;
    }

    public RuntimeOptions connectTimeout(long connectTimeout, TimeUnit timeUnit) {
        Assert.nonnegative("connectTimeout", connectTimeout);
        Assert.notNull("timeUnit", (Object)timeUnit);
        this.connectTimeoutMillis = timeUnit.toMillis(connectTimeout);
        return this;
    }

    public RuntimeOptions readTimeout(long readTimeout, TimeUnit timeUnit) {
        Assert.nonnegative("readTimeout", readTimeout);
        Assert.notNull("timeUnit", (Object)timeUnit);
        this.readTimeoutMillis = timeUnit.toMillis(readTimeout);
        return this;
    }

    public RuntimeOptions maxIdleConn(int maxIdleConn) {
        Assert.nonnegative("maxIdleConn", maxIdleConn);
        this.maxIdleConn = maxIdleConn;
        return this;
    }

    public RuntimeOptions ignoreSSL(boolean ignoreSSL) {
        this.ignoreSSL = ignoreSSL;
        return this;
    }

    public RuntimeOptions proxy(ProxyType proxyType, String proxyAddress) {
        Assert.notNull("proxyType", (Object)proxyType);
        Assert.notBlank("proxyAddress", proxyAddress);
        this.proxyType = proxyType;
        this.proxyAddress = proxyAddress;
        return this;
    }

    public long getConnectTimeout(TimeUnit timeUnit) {
        long timeout = this.connectTimeoutMillis != null ? this.connectTimeoutMillis.longValue() : this.parent.getConnectTimeout(timeUnit);
        return timeUnit.convert(timeout, TimeUnit.MILLISECONDS);
    }

    public long getReadTimeout(TimeUnit timeUnit) {
        long timeout = this.readTimeoutMillis != null ? this.readTimeoutMillis.longValue() : this.parent.getReadTimeout(timeUnit);
        return timeUnit.convert(timeout, TimeUnit.MILLISECONDS);
    }

    public int getMaxIdleConn() {
        return this.maxIdleConn != null ? this.maxIdleConn.intValue() : this.parent.getMaxIdleConn();
    }

    public boolean getIgnoreSSL() {
        return this.ignoreSSL != null ? this.ignoreSSL.booleanValue() : this.parent.getIgnoreSSL();
    }

    public Optional<ProxyType> getProxyType() {
        return this.proxyType != null || this.parent == null ? Optional.ofNullable(this.proxyType) : this.parent.getProxyType();
    }

    public String getProxyAddress() {
        return this.proxyAddress != null || this.parent == null ? this.proxyAddress : this.parent.getProxyAddress();
    }

    public String toString() {
        return "RuntimeOptions{parent=" + this.parent + ", connectTimeoutMillis=" + this.connectTimeoutMillis + ", readTimeoutMillis=" + this.readTimeoutMillis + ", maxIdleConn=" + this.maxIdleConn + ", ignoreSSL=" + this.ignoreSSL + ", proxyType=" + (Object)((Object)this.proxyType) + ", proxyAddress='" + this.proxyAddress + '\'' + '}';
    }
}

