/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.http.okhttp;

import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.http.certificate.IgnoreHostnameVerifier;
import com.webullpay.openapi.http.certificate.IgnoreX509TrustManager;
import com.webullpay.openapi.http.okhttp.interceptors.SocksProxyAuthInterceptor;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class OkHttpClientBuilder {
    private final OkHttpClient.Builder builder = new OkHttpClient().newBuilder();

    public static OkHttpClientBuilder builder() {
        return new OkHttpClientBuilder();
    }

    private OkHttpClientBuilder() {
    }

    public OkHttpClientBuilder connectTimeout(long connectTimeout, TimeUnit timeUnit) {
        this.builder.connectTimeout(connectTimeout, timeUnit);
        return this;
    }

    public OkHttpClientBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
        this.builder.readTimeout(readTimeout, timeUnit);
        return this;
    }

    public OkHttpClientBuilder connectionPool(int maxIdleConnections) {
        ConnectionPool connectionPool = new ConnectionPool(maxIdleConnections, 10000L, TimeUnit.MILLISECONDS);
        this.builder.connectionPool(connectionPool);
        return this;
    }

    public OkHttpClientBuilder certificate(boolean ignoreSSL) {
        try {
            if (ignoreSSL) {
                IgnoreX509TrustManager ignoreX509TrustManager = new IgnoreX509TrustManager();
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{ignoreX509TrustManager}, new SecureRandom());
                this.builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)ignoreX509TrustManager).hostnameVerifier((HostnameVerifier)new IgnoreHostnameVerifier());
            }
            return this;
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    public OkHttpClientBuilder proxy(Proxy.Type type, String proxyAddress) {
        try {
            URI url = new URI(proxyAddress);
            this.builder.proxy(new Proxy(type, new InetSocketAddress(url.getHost(), url.getPort())));
            return this;
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    public OkHttpClientBuilder proxyAuthenticator(Proxy.Type type, String proxyAddress) {
        try {
            URI proxyUrl;
            String userInfo;
            if (Proxy.Type.HTTP == type) {
                URL proxyUrl2 = new URL(proxyAddress);
                String userInfo2 = proxyUrl2.getUserInfo();
                if (null != userInfo2) {
                    String[] userMessage = userInfo2.split(":");
                    String credential = Credentials.basic((String)userMessage[0], (String)userMessage[1]);
                    Authenticator authenticator = (route, response) -> response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    this.builder.proxyAuthenticator(authenticator);
                }
            } else if (Proxy.Type.SOCKS == type && null != (userInfo = (proxyUrl = new URI(proxyAddress)).getUserInfo())) {
                String[] userMessage = userInfo.split(":");
                this.builder.addInterceptor((Interceptor)new SocksProxyAuthInterceptor(userMessage[0], userMessage[1]));
            }
            return this;
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage(), e);
        }
    }

    public OkHttpClient build() {
        return this.builder.build();
    }
}

