/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.http.retry;

import com.webullpay.openapi.http.retry.RetryOnExceptionCondition;
import com.webullpay.openapi.http.retry.RetryOnHttpMethodCondition;
import com.webullpay.openapi.http.retry.RetryOnHttpStatusCondition;
import com.webullpay.openapi.retry.RetryContext;
import com.webullpay.openapi.retry.condition.AndMergeRetryCondition;
import com.webullpay.openapi.retry.condition.MaxRetryTimesCondition;
import com.webullpay.openapi.retry.condition.OrMergeRetryCondition;
import com.webullpay.openapi.retry.condition.RetryCondition;
import java.util.ArrayList;

public class DefaultHttpRetryCondition
implements RetryCondition {
    private final OrMergeRetryCondition orMergeRetryCondition;

    public DefaultHttpRetryCondition(int maxRetryTimes) {
        ArrayList<RetryCondition> orMergeRetryConditions = new ArrayList<RetryCondition>();
        orMergeRetryConditions.add(new MaxRetryTimesCondition(maxRetryTimes));
        orMergeRetryConditions.add(new RetryOnHttpMethodCondition());
        ArrayList<RetryCondition> andMergeRetryConditions = new ArrayList<RetryCondition>();
        andMergeRetryConditions.add(new RetryOnExceptionCondition());
        andMergeRetryConditions.add(new RetryOnHttpStatusCondition());
        orMergeRetryConditions.add(new AndMergeRetryCondition(andMergeRetryConditions));
        this.orMergeRetryCondition = new OrMergeRetryCondition(orMergeRetryConditions);
    }

    @Override
    public boolean shouldRetry(RetryContext context) {
        return this.orMergeRetryCondition.shouldRetry(context);
    }
}

