/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.http.retry;

import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.execption.ServerException;
import com.webullpay.openapi.retry.RetryContext;
import com.webullpay.openapi.retry.condition.RetryCondition;
import com.webullpay.openapi.utils.CollectionUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class RetryOnExceptionCondition
implements RetryCondition {
    private static final Set<String> RETRYABLE_NORMAL_ERRORS = CollectionUtils.newHashSet("SERVICE_NOT_AVAILABLE", "GATEWAY_TIMEOUT", "INTERNAL_ERROR");
    private static final Set<String> RETRYABLE_THROTTLING_ERRORS = Collections.singleton("TOO_MANY_REQUESTS");

    @Override
    public boolean shouldRetry(RetryContext context) {
        Throwable cause = context.getCause();
        if (cause instanceof ClientException && cause.getCause() instanceof IOException) {
            return true;
        }
        if (cause instanceof ServerException) {
            ServerException serverCause = (ServerException)cause;
            if (RETRYABLE_NORMAL_ERRORS.contains(serverCause.getErrorCode())) {
                return true;
            }
            if (RETRYABLE_THROTTLING_ERRORS.contains(serverCause.getErrorCode())) {
                context.setThrottled(true);
                return true;
            }
        }
        return false;
    }
}

