/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.logger;

import com.webullpay.openapi.logger.FormattingTuple;
import com.webullpay.openapi.logger.Logger;
import com.webullpay.openapi.logger.MessageFormatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

final class JdkLogger
implements Logger {
    private static final String FQCN = JdkLogger.class.getName();
    private final java.util.logging.Logger logger;

    JdkLogger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    @Override
    public String name() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String msg) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, msg, null);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINEST)) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.log(Level.FINEST, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.logger.isLoggable(Level.FINEST)) {
            FormattingTuple tuple = MessageFormatter.format(format, args);
            this.log(Level.FINEST, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, msg, t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public void debug(String msg) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg, null);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.log(Level.FINE, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.logger.isLoggable(Level.FINE)) {
            FormattingTuple tuple = MessageFormatter.format(format, args);
            this.log(Level.FINE, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg, t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg, null);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (this.logger.isLoggable(Level.INFO)) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.log(Level.INFO, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.logger.isLoggable(Level.INFO)) {
            FormattingTuple tuple = MessageFormatter.format(format, args);
            this.log(Level.INFO, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg, t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String msg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg, null);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.log(Level.WARNING, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.logger.isLoggable(Level.WARNING)) {
            FormattingTuple tuple = MessageFormatter.format(format, args);
            this.log(Level.WARNING, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg, t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String msg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, msg, null);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.log(Level.SEVERE, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            FormattingTuple tuple = MessageFormatter.format(format, args);
            this.log(Level.SEVERE, tuple.getMessage(), tuple.getThrowable());
        }
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.logger.isLoggable(Level.SEVERE)) {
            this.log(Level.SEVERE, msg, t);
        }
    }

    private void log(Level level, String msg, Throwable t) {
        LogRecord r = new LogRecord(level, msg);
        r.setLoggerName(this.name());
        r.setThrown(t);
        JdkLogger.setCaller(r);
        this.logger.log(r);
    }

    private static void setCaller(LogRecord r) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        int callerIndex = JdkLogger.findCallerStackDepth(stackTrace);
        if (callerIndex >= 0) {
            StackTraceElement element = stackTrace[callerIndex];
            r.setSourceClassName(element.getClassName());
            r.setSourceMethodName(element.getMethodName());
        }
    }

    private static int findCallerStackDepth(StackTraceElement[] stackTrace) {
        int loggerIndex = -1;
        for (int i = 0; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (!className.equals(FQCN)) continue;
            loggerIndex = i;
            break;
        }
        int callerIndex = -1;
        for (int i = loggerIndex + 1; i < stackTrace.length; ++i) {
            String className = stackTrace[i].getClassName();
            if (className.equals(FQCN)) continue;
            callerIndex = i;
            break;
        }
        return callerIndex;
    }
}

