/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.retry;

import com.webullpay.openapi.retry.RetryContext;
import com.webullpay.openapi.retry.backoff.BackoffStrategy;
import com.webullpay.openapi.retry.backoff.NoDelayStrategy;
import com.webullpay.openapi.retry.condition.NoRetryCondition;
import com.webullpay.openapi.retry.condition.RetryCondition;
import com.webullpay.openapi.utils.Assert;
import java.util.concurrent.TimeUnit;

public class RetryPolicy
implements RetryCondition,
BackoffStrategy {
    private final RetryCondition retryCondition;
    private final BackoffStrategy backoffStrategy;

    public RetryPolicy(RetryCondition retryCondition, BackoffStrategy backoffStrategy) {
        Assert.notNull("retryCondition", (Object)retryCondition);
        Assert.notNull("backoffStrategy", (Object)backoffStrategy);
        this.retryCondition = retryCondition;
        this.backoffStrategy = backoffStrategy;
    }

    @Override
    public long nextRetryDelay(RetryContext context, TimeUnit timeUnit) {
        return this.backoffStrategy.nextRetryDelay(context, timeUnit);
    }

    @Override
    public boolean shouldRetry(RetryContext context) {
        return this.retryCondition.shouldRetry(context);
    }

    public static RetryPolicy never() {
        return new RetryPolicy(NoRetryCondition.getInstance(), NoDelayStrategy.getInstance());
    }
}

