/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.retry;

import com.webullpay.openapi.logger.Logger;
import com.webullpay.openapi.logger.LoggerFactory;
import com.webullpay.openapi.retry.RetriedFailedException;
import com.webullpay.openapi.retry.RetryContext;
import com.webullpay.openapi.retry.RetryPolicy;
import com.webullpay.openapi.retry.Retryable;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class SynchronousRetryable<T>
implements Retryable<T> {
    private static final Logger logger = LoggerFactory.getLogger(SynchronousRetryable.class);
    private final Supplier<T> doRetry;
    private final RetryPolicy retryPolicy;

    protected SynchronousRetryable(Supplier<T> doRetry, RetryPolicy retryPolicy) {
        this.doRetry = doRetry;
        this.retryPolicy = retryPolicy;
    }

    @Override
    public T retry(RetryContext context) throws RetriedFailedException {
        boolean shouldRetry = this.retryPolicy.shouldRetry(context);
        if (shouldRetry) {
            RetryContext continueCtx;
            if (logger.isTraceEnabled()) {
                logger.error("Start retrying, attempts={}, caused by:", context.getRetriesAttempted(), context.getCause());
            }
            long delayMillis = this.retryPolicy.nextRetryDelay(context, TimeUnit.MILLISECONDS);
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interrupted) {
                Thread.currentThread().interrupt();
                throw new RetriedFailedException(interrupted);
            }
            try {
                T result = this.doRetry.get();
                Optional<RetryContext> maybeContinue = this.maybeContinue(context, result, null);
                if (!maybeContinue.isPresent()) {
                    return result;
                }
                continueCtx = maybeContinue.get();
            }
            catch (Exception ex) {
                Optional<RetryContext> maybeContinue = this.maybeContinue(context, null, ex);
                if (!maybeContinue.isPresent()) {
                    throw new RetriedFailedException(ex);
                }
                continueCtx = maybeContinue.get();
            }
            return this.retry(continueCtx);
        }
        if (context.getCause() != null) {
            throw new RetriedFailedException(context.getCause());
        }
        return null;
    }

    protected abstract Optional<RetryContext> maybeContinue(RetryContext var1, T var2, Throwable var3);
}

