/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.retry.backoff;

import com.webullpay.openapi.retry.RetryContext;
import com.webullpay.openapi.retry.backoff.BackoffStrategy;
import java.util.concurrent.TimeUnit;

public class ExponentialBackoffStrategy
implements BackoffStrategy {
    private static final int MAX_RETRY_LIMIT = 30;
    private final long initialDelayNanos;
    private final long maxDelayNanos;

    public ExponentialBackoffStrategy() {
        this(1L, 120L, TimeUnit.SECONDS);
    }

    public ExponentialBackoffStrategy(long initialDelay, long maxDelay, TimeUnit timeUnit) {
        this.initialDelayNanos = timeUnit.toNanos(initialDelay);
        this.maxDelayNanos = timeUnit.toNanos(maxDelay);
    }

    @Override
    public long nextRetryDelay(RetryContext context, TimeUnit timeUnit) {
        int retries = Math.min(30, context.getRetriesAttempted());
        long delay = Math.min(this.maxDelayNanos, this.initialDelayNanos << retries);
        if (delay < this.initialDelayNanos) {
            delay = this.maxDelayNanos;
        }
        return timeUnit.convert(delay, TimeUnit.NANOSECONDS);
    }
}

