/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.retry.backoff;

import com.webullpay.openapi.retry.RetryContext;
import com.webullpay.openapi.retry.backoff.ExponentialBackoffStrategy;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class JitterExponentialBackoffStrategy
extends ExponentialBackoffStrategy {
    public JitterExponentialBackoffStrategy(long initialDelay, long maxDelay, TimeUnit timeUnit) {
        super(initialDelay, maxDelay, timeUnit);
    }

    @Override
    public long nextRetryDelay(RetryContext context, TimeUnit timeUnit) {
        long delay = super.nextRetryDelay(context, TimeUnit.NANOSECONDS);
        long randomDelay = (long)((double)delay / 4.0 / 2.147483647E9 * (double)ThreadLocalRandom.current().nextInt());
        return timeUnit.convert(delay + randomDelay, TimeUnit.NANOSECONDS);
    }
}

