/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.serialize;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.webullpay.openapi.serialize.SerializeConfig;
import java.lang.reflect.Type;

public class JsonSerializer {
    private static final Gson GSON = new Gson();
    private static final Gson UNDERSCORES_TO_CAMEL = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    private JsonSerializer() {
    }

    public static String toJson(Object object) {
        return GSON.toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)GSON.fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfT) {
        return (T)GSON.fromJson(json, typeOfT);
    }

    public static String toJson(Object object, SerializeConfig serializeConfig) {
        return JsonSerializer.get(serializeConfig).toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> classOfT, SerializeConfig serializeConfig) {
        return (T)JsonSerializer.get(serializeConfig).fromJson(json, classOfT);
    }

    public static <T> T fromJson(String json, Type typeOfT, SerializeConfig serializeConfig) {
        return (T)JsonSerializer.get(serializeConfig).fromJson(json, typeOfT);
    }

    private static Gson get(SerializeConfig serializeConfig) {
        return serializeConfig.isUnderscoresToCamel() ? UNDERSCORES_TO_CAMEL : GSON;
    }
}

